/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.config;

import java.util.Optional;
import java.util.function.Predicate;
import org.junit.jupiter.engine.config.ConfigurationParameterConverter;
import org.junit.platform.engine.ConfigurationParameters;

class FilteringConfigurationParameterConverter<T>
implements ConfigurationParameterConverter<T> {
    private final Predicate<? super String> predicate;
    private final ConfigurationParameterConverter<T> delegate;

    static <T> FilteringConfigurationParameterConverter<T> exclude(Predicate<? super String> exclusion, ConfigurationParameterConverter<T> delegate) {
        return new FilteringConfigurationParameterConverter<T>(Predicate.not(exclusion), delegate);
    }

    private FilteringConfigurationParameterConverter(Predicate<? super String> predicate, ConfigurationParameterConverter<T> delegate) {
        this.predicate = predicate;
        this.delegate = delegate;
    }

    @Override
    public Optional<T> get(ConfigurationParameters configurationParameters, String key) {
        return configurationParameters.get(key).map(String::strip).filter(this.predicate).flatMap(__ -> this.delegate.get(configurationParameters, key));
    }
}

