/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.ant.internal.ui.editor.AntEditor;
import org.eclipse.ant.internal.ui.model.AntElementNode;
import org.eclipse.ant.internal.ui.model.AntModel;
import org.eclipse.ant.internal.ui.model.AntProjectNode;
import org.eclipse.ant.internal.ui.model.IAntElement;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;

public class AntFoldingStructureProvider {
    private final AntEditor fEditor;
    private IDocument fDocument;
    private Map<Position, IAntElement> fPositionToElement = new HashMap<Position, IAntElement>();

    public AntFoldingStructureProvider(AntEditor editor) {
        this.fEditor = editor;
    }

    private void updateFoldingRegions(ProjectionAnnotationModel model, Set<Position> currentRegions) {
        Annotation[] deletions = this.computeDifferences(model, currentRegions);
        HashMap<ProjectionAnnotation, Position> additionsMap = new HashMap<ProjectionAnnotation, Position>();
        for (Position position : currentRegions) {
            IAntElement node = this.fPositionToElement.get(position);
            additionsMap.put(new ProjectionAnnotation(node.collapseProjection()), position);
        }
        if (deletions.length != 0 || additionsMap.size() != 0) {
            model.modifyAnnotations(deletions, additionsMap, new Annotation[0]);
        }
    }

    private Annotation[] computeDifferences(ProjectionAnnotationModel model, Set<Position> additions) {
        ArrayList<Annotation> deletions = new ArrayList<Annotation>();
        Iterator iter = model.getAnnotationIterator();
        while (iter.hasNext()) {
            Object annotation = iter.next();
            if (!(annotation instanceof ProjectionAnnotation)) continue;
            Annotation annot = (Annotation)annotation;
            Position position = model.getPosition(annot);
            if (additions.contains(position)) {
                additions.remove(position);
                continue;
            }
            deletions.add(annot);
        }
        return deletions.toArray(new Annotation[deletions.size()]);
    }

    public void updateFoldingRegions(AntModel antModel) {
        this.fPositionToElement = new HashMap<Position, IAntElement>();
        try {
            ProjectionAnnotationModel model = this.fEditor.getAdapter(ProjectionAnnotationModel.class);
            if (model == null) {
                return;
            }
            HashSet<Position> currentRegions = new HashSet<Position>();
            ArrayList<IAntElement> root = new ArrayList<IAntElement>();
            AntProjectNode node = antModel.getProjectNode();
            if (node != null && node.getOffset() != -1) {
                root.add(node);
                List<AntElementNode> nodes = antModel.getNonStructuralNodes();
                root.addAll(nodes);
            }
            this.addFoldingRegions(currentRegions, root);
            this.updateFoldingRegions(model, currentRegions);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void addFoldingRegions(Set<Position> regions, List<IAntElement> children) throws BadLocationException {
        for (IAntElement element : children) {
            List<IAntElement> childNodes;
            int endLine;
            if (element.getImportNode() != null || element.isExternal()) continue;
            int startLine = this.fDocument.getLineOfOffset(element.getOffset());
            if (startLine < (endLine = this.fDocument.getLineOfOffset(element.getOffset() + element.getLength()))) {
                int start = this.fDocument.getLineOffset(startLine);
                int end = this.fDocument.getLineOffset(endLine) + this.fDocument.getLineLength(endLine);
                Position position = new Position(start, end - start);
                regions.add(position);
                this.fPositionToElement.put(position, element);
            }
            if ((childNodes = element.getChildNodes()) == null) continue;
            this.addFoldingRegions(regions, childNodes);
        }
    }

    public void setDocument(IDocument document) {
        this.fDocument = document;
    }
}

