/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.console;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.console.ConsoleMessages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.views.console.ProcessConsole;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.console.TextConsole;

public class JavacMarkerCreator {
    private final TextConsole fConsole;
    private IProcess fProcess;
    private static List<IFile> fgFilesToBeCleaned = new ArrayList<IFile>();
    private final Map<IFile, List<MarkerInfo>> fFileToMarkerInfo = new HashMap<IFile, List<MarkerInfo>>();
    private final boolean fUseCustomMessage;

    public JavacMarkerCreator(TextConsole console, boolean useCustomMessage) {
        this.fConsole = console;
        this.fUseCustomMessage = useCustomMessage;
        if (this.fConsole instanceof ProcessConsole) {
            this.fProcess = ((ProcessConsole)this.fConsole).getProcess();
        }
    }

    protected ISchedulingRule getMarkerRule(IResource resource) {
        ISchedulingRule rule = null;
        if (resource != null) {
            IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
            rule = ruleFactory.markerRule(resource);
        }
        return rule;
    }

    protected void run(ISchedulingRule rule, IWorkspaceRunnable wr) {
        try {
            ResourcesPlugin.getWorkspace().run(wr, rule, 0, null);
        }
        catch (CoreException e) {
            AntUIPlugin.log(e.getStatus());
        }
    }

    protected void addFileToBeCleaned(IFile file) {
        fgFilesToBeCleaned.add(file);
    }

    protected void addMarker(IFile file, int lineNumber, int offset, Integer type) {
        MarkerInfo info = new MarkerInfo();
        info.setLineNumber(lineNumber);
        info.setOffset(offset);
        info.setType(type);
        List<MarkerInfo> infos = this.fFileToMarkerInfo.get(file);
        if (infos == null) {
            infos = new ArrayList<MarkerInfo>();
            this.fFileToMarkerInfo.put(file, infos);
        }
        infos.add(info);
    }

    private void createMarkers(IFile file, List<MarkerInfo> infos) {
        IWorkspaceRunnable wr = monitor -> {
            try {
                for (MarkerInfo info : infos) {
                    IMarker marker = file.createMarker("org.eclipse.jdt.core.problem");
                    HashMap<String, Object> attributes = new HashMap<String, Object>(3);
                    attributes.put("lineNumber", info.fLineNumber);
                    String message = this.getMessage(info);
                    attributes.put("message", message);
                    attributes.put("severity", info.fType);
                    marker.setAttributes(attributes);
                }
            }
            catch (CoreException e) {
                AntUIPlugin.log(e.getStatus());
            }
        };
        this.run(this.getMarkerRule((IResource)file), wr);
    }

    protected String getMessage(MarkerInfo info) {
        IDocument doc = this.fConsole.getDocument();
        String message = ConsoleMessages.JavacMarkerCreator_0;
        if (this.fUseCustomMessage) {
            FindReplaceDocumentAdapter adapter = new FindReplaceDocumentAdapter(doc);
            try {
                IRegion match = adapter.find(info.fOffset, "[javac] ----------", true, false, false, false);
                if (match != null && (match = adapter.find(match.getOffset(), "[javac]", false, false, false, false)) != null) {
                    int start = match.getOffset() + match.getLength() + 1;
                    IRegion lineInfo = doc.getLineInformationOfOffset(start);
                    message = doc.get(start, lineInfo.getOffset() - start + lineInfo.getLength());
                }
            }
            catch (BadLocationException e) {
                AntUIPlugin.log(e);
            }
        }
        return message;
    }

    protected void finished(IProcess process) {
        if (process.equals(this.fProcess)) {
            for (IFile file : fgFilesToBeCleaned) {
                try {
                    file.deleteMarkers("org.eclipse.jdt.core.problem", true, 2);
                }
                catch (CoreException e) {
                    AntUIPlugin.log(e.getStatus());
                }
            }
            for (IFile file : this.fFileToMarkerInfo.keySet()) {
                this.createMarkers(file, this.fFileToMarkerInfo.get(file));
            }
            this.fFileToMarkerInfo.clear();
            fgFilesToBeCleaned.clear();
        }
    }

    private static class MarkerInfo {
        public int fLineNumber;
        public int fOffset;
        public Integer fType;

        private MarkerInfo() {
        }

        public void setLineNumber(int lineNumber) {
            this.fLineNumber = lineNumber;
        }

        public void setOffset(int offset) {
            this.fOffset = offset;
        }

        public void setType(Integer type) {
            this.fType = type;
        }
    }
}

