/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.tasks;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class PluginVersionReplaceTask
extends Task {
    private static final String PLUGIN_START_TAG = "<plugin";
    private static final String FRAGMENT_START_TAG = "<fragment";
    private static final String COMMENT_START_TAG = "<!--";
    private static final String COMMENT_END_TAG = "-->";
    private static final String VERSION = "version";
    private static final String BACKSLASH = "\"";
    private String pluginFilePath;
    private boolean plugin = true;
    private String newVersion;

    public void setPluginFilePath(String path) {
        this.pluginFilePath = path;
    }

    public void setVersionNumber(String qualifier) {
        this.newVersion = qualifier;
    }

    public void setInput(String input) {
        if (input.equalsIgnoreCase("fragment.xml")) {
            this.plugin = false;
        }
    }

    public void execute() {
        StringBuffer buffer = null;
        try {
            buffer = this.readFile(new File(this.pluginFilePath));
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        int startPlugin = this.scan(buffer, 0, this.plugin ? PLUGIN_START_TAG : FRAGMENT_START_TAG);
        int startComment = this.scan(buffer, 0, COMMENT_START_TAG);
        int endComment = startComment > -1 ? this.scan(buffer, startComment, COMMENT_END_TAG) : -1;
        while (startComment != -1 && startPlugin > startComment && startPlugin < endComment) {
            startPlugin = this.scan(buffer, endComment, this.plugin ? PLUGIN_START_TAG : FRAGMENT_START_TAG);
            startComment = this.scan(buffer, endComment, COMMENT_START_TAG);
            int n = endComment = startComment > -1 ? this.scan(buffer, startComment, COMMENT_END_TAG) : -1;
        }
        if (startPlugin == -1) {
            return;
        }
        int endPlugin = this.scan(buffer, startPlugin + 1, ">");
        boolean versionFound = false;
        while (!versionFound) {
            int versionAttr = this.scan(buffer, startPlugin, VERSION);
            if (versionAttr == -1 || versionAttr > endPlugin) {
                return;
            }
            if (!Character.isWhitespace(buffer.charAt(versionAttr - 1))) {
                startPlugin = versionAttr + VERSION.length();
                continue;
            }
            int endVersionWord = versionAttr + VERSION.length();
            while (Character.isWhitespace(buffer.charAt(endVersionWord)) && endVersionWord < endPlugin) {
                ++endVersionWord;
            }
            if (endVersionWord > endPlugin) {
                return;
            }
            if (buffer.charAt(endVersionWord) != '=') {
                startPlugin = endVersionWord;
                continue;
            }
            int startVersionId = this.scan(buffer, versionAttr + 1, BACKSLASH);
            int endVersionId = this.scan(buffer, startVersionId + 1, BACKSLASH);
            buffer.replace(startVersionId + 1, endVersionId, this.newVersion);
            versionFound = true;
        }
        try {
            Throwable versionAttr = null;
            Object var8_14 = null;
            try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(this.pluginFilePath)), StandardCharsets.UTF_8);){
                w.write(buffer.toString());
            }
            catch (Throwable throwable) {
                if (versionAttr == null) {
                    versionAttr = throwable;
                } else if (versionAttr != throwable) {
                    versionAttr.addSuppressed(throwable);
                }
                throw versionAttr;
            }
        }
        catch (FileNotFoundException versionAttr) {
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private int scan(StringBuffer buf, int start, String targetName) {
        return this.scan(buf, start, new String[]{targetName});
    }

    private int scan(StringBuffer buf, int start, String[] targets) {
        int i = start;
        while (i < buf.length()) {
            String[] stringArray = targets;
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                String match;
                String target2 = stringArray[n2];
                if (i < buf.length() - target2.length() && target2.equalsIgnoreCase(match = buf.substring(i, i + target2.length()))) {
                    return i;
                }
                ++n2;
            }
            ++i;
        }
        return -1;
    }

    private StringBuffer readFile(File targetName) throws IOException {
        return new StringBuffer(Files.readString(targetName.toPath()));
    }
}

