/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.function;

import java.lang.ref.WeakReference;
import java.util.Vector;
import org.eclipse.core.runtime.Assert;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCombined;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCombinedOperator;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionFunction;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionNested;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.ExpressionBuilderDialog;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.ExpressionBuilderWizard;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.actions.DeleteFunctionParameterAction;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.function.FunctionBuilderPage;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.multiexpr.ExpressionElement;
import org.eclipse.datatools.sqltools.sqlbuilder.model.ExpressionHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLBuilderConstants;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.util.LabelValuePair;
import org.eclipse.datatools.sqltools.sqlbuilder.views.BuilderUtility;
import org.eclipse.datatools.sqltools.sqlbuilder.views.ComboBoxCellEditor;
import org.eclipse.datatools.sqltools.sqlbuilder.views.DynamicComboBoxCellEditor;
import org.eclipse.datatools.sqltools.sqlbuilder.views.NavigableTableViewer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ParamTable
extends NavigableTableViewer
implements IMenuListener {
    public static final String PARAMETER_NUMBER = "org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.PARAMETER_NUMBER";
    public static final String PARAMETER_EXPRESSION = "org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.PARAMETER_EXPRESSION";
    public static final String PARAMETER_OPERATOR = "org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.PARAMETER_OPERATOR";
    private SQLDomainModel domainModel;
    private DynamicComboBoxCellEditor expressionsComboBoxCellEditor;
    private OperatorsComboBoxCellEditor operatorsComboBoxCellEditor;
    private SQLQueryObject sqlStatement;
    private FunctionBuilderPage functionBuilderPage;
    private Table table;
    private TableColumn c1;
    private TableColumn c2;
    private TableColumn c3;
    private boolean isSupportsStar = false;
    String functionName = "";

    ParamTable(FunctionBuilderPage fbp, Composite parent, SQLDomainModel domainModel, SQLQueryObject sqlStmt) {
        super(new Table(parent, 65538));
        this.domainModel = domainModel;
        this.sqlStatement = sqlStmt;
        this.functionBuilderPage = fbp;
        this.table = this.getTable();
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.c1 = new TableColumn(this.table, 0);
        this.c1.setText(Messages._UI_COLUMN_PARAMETER);
        this.expressionsComboBoxCellEditor = new DynamicComboBoxCellEditor((Composite)this.table, null, (Object)this);
        this.c2 = new TableColumn(this.table, 0);
        this.c2.setText(Messages._UI_COLUMN_VALUE);
        this.operatorsComboBoxCellEditor = new OperatorsComboBoxCellEditor((Composite)this.table);
        this.c3 = new TableColumn(this.table, 0);
        this.c3.setText(Messages._UI_COLUMN_OPERATOR);
        this.fillOperatorsComboBox();
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(75, true));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(250, true));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(75, true));
        this.table.setLayout((Layout)layout);
        String[] properties = new String[]{PARAMETER_NUMBER, PARAMETER_EXPRESSION, PARAMETER_OPERATOR};
        this.setColumnProperties(properties);
        CellEditor[] cellEditorArray = new CellEditor[3];
        cellEditorArray[1] = this.expressionsComboBoxCellEditor;
        cellEditorArray[2] = this.operatorsComboBoxCellEditor;
        CellEditor[] editors = cellEditorArray;
        this.setCellEditors(editors);
        this.setCellModifier(new ParamTableCellModifier(this));
        this.setLabelProvider((IBaseLabelProvider)new ParamTableLabelProvider());
        this.setContentProvider((IContentProvider)new ParamTableContentProvider());
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(this.getControl());
        this.getControl().setMenu(menu);
    }

    public FunctionBuilderPage getFunctionBuilderPage() {
        return this.functionBuilderPage;
    }

    public SQLDomainModel getDomainModel() {
        return this.domainModel;
    }

    public SQLQueryObject getSQLStatement() {
        return this.sqlStatement;
    }

    @Override
    public void refresh() {
        if (!this.isCellEditorActive()) {
            super.refresh();
        }
    }

    public void setSupportsStar(boolean isColumnFunc) {
        this.isSupportsStar = isColumnFunc;
    }

    public void setFunctionName(String name) {
        this.functionName = name;
    }

    public void refreshCellEditor(int row) {
        QueryValueExpression expr;
        boolean existsExpression = false;
        Object obj = this.getElementAt(row);
        if (obj instanceof ExpressionElement && (expr = ((ExpressionElement)obj).getExpression()) instanceof QueryValueExpression) {
            existsExpression = true;
        }
        BuilderUtility.fillColumnComboBox(this.expressionsComboBoxCellEditor, this.sqlStatement, true, existsExpression);
        if (this.isSupportsStar) {
            LabelValuePair[] star = new LabelValuePair[]{new LabelValuePair("*", ExpressionHelper.createExpression("*"))};
            this.expressionsComboBoxCellEditor.addItemsToStart(star);
        }
        CellEditor[] cellEditorArray = new CellEditor[3];
        cellEditorArray[1] = this.expressionsComboBoxCellEditor;
        cellEditorArray[2] = this.operatorsComboBoxCellEditor;
        CellEditor[] editors = cellEditorArray;
        this.setCellEditors(editors);
    }

    public void menuAboutToShow(IMenuManager menu) {
        DeleteFunctionParameterAction deleteFunctionParameterAction = new DeleteFunctionParameterAction(this, this.functionBuilderPage);
        menu.add((IAction)deleteFunctionParameterAction);
    }

    private void fillOperatorsComboBox() {
        LabelValuePair[] operators = new LabelValuePair[]{new LabelValuePair(" ", "NO_OPERATOR"), new LabelValuePair("+", "+"), new LabelValuePair("-", "-"), new LabelValuePair("*", "*"), new LabelValuePair("/", "/"), new LabelValuePair("CONCAT", "CONCAT")};
        this.operatorsComboBoxCellEditor.createItems(operators);
    }

    protected void inputChanged(Object input, Object oldInput) {
        super.inputChanged(input, oldInput);
    }

    class OperatorsComboBoxCellEditor
    extends ComboBoxCellEditor {
        public OperatorsComboBoxCellEditor(Composite parent) {
            super(parent, null);
        }

        @Override
        protected void doSetValue(Object value) {
            super.doSetValue(value);
        }
    }

    public class ParamTableCellModifier
    implements ICellModifier {
        ParamTable viewer;
        Object currentElement;
        Object currentValue;
        String currentProperty;
        ExpressionElement expressionElement;
        QueryValueExpression expr;

        public ParamTableCellModifier(ParamTable viewer) {
            this.viewer = viewer;
        }

        public boolean canModify(Object element, String property) {
            return property.equals(ParamTable.PARAMETER_EXPRESSION) || property.equals(ParamTable.PARAMETER_OPERATOR);
        }

        public Object getValue(Object element, String property) {
            return element;
        }

        public void modify(Object element, String property, Object value) {
            this.currentElement = element;
            this.currentProperty = property;
            this.currentValue = value;
            if (property.equals(ParamTable.PARAMETER_EXPRESSION)) {
                Assert.isTrue((boolean)(this.currentElement instanceof TableItem));
                Object data = ((TableItem)this.currentElement).getData();
                if (this.currentValue == null) {
                    return;
                }
                if (data instanceof ExpressionElement) {
                    this.expressionElement = (ExpressionElement)data;
                    if (this.currentValue instanceof QueryValueExpression) {
                        this.expr = (QueryValueExpression)this.currentValue;
                        this.expressionElement.setExpression(this.expr);
                        Vector elements = this.expressionElement.getElementsVector();
                        if (elements != null && !elements.isEmpty()) {
                            ExpressionElement e = (ExpressionElement)elements.get(0);
                            QueryValueExpression firstExpr = e.getExpression();
                            QueryValueExpression root = ExpressionHelper.getRoot(firstExpr);
                            int paramNo = e.getParameterNum();
                            ParamTable.this.getFunctionBuilderPage().setParamValue(paramNo, root);
                        }
                        Display.getCurrent().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ParamTableCellModifier.this.viewer.refresh();
                            }
                        });
                        ParamTable.this.getFunctionBuilderPage().updateFinishButton();
                    } else if (this.currentValue instanceof String) {
                        String valueString = (String)this.currentValue;
                        QueryValueExpression currExpr = this.expressionElement.getExpression();
                        if (valueString.equals(SQLBuilderConstants.P_BUILD_EXPRESSION) || valueString.equals(SQLBuilderConstants.P_EDIT_EXPRESSION) || valueString.equals(SQLBuilderConstants.P_REPLACE_EXPRESSION)) {
                            ExpressionBuilderWizard wizard = new ExpressionBuilderWizard(ParamTable.this.getDomainModel(), ParamTable.this.getSQLStatement());
                            if (valueString.equals(SQLBuilderConstants.P_BUILD_EXPRESSION) || valueString.equals(SQLBuilderConstants.P_REPLACE_EXPRESSION)) {
                                wizard.setInputExpression(null);
                            } else if (valueString.equals(SQLBuilderConstants.P_EDIT_EXPRESSION)) {
                                wizard.setInputExpression(currExpr);
                                if (ParamTable.this.functionName.equals("XMLELEMENT") || ParamTable.this.functionName.equals("XML2CLOB") || ParamTable.this.functionName.equals("XMLAGG") || ParamTable.this.functionName.equals("XMLATTRIBUTES")) {
                                    wizard.setIsXMLFunction(true);
                                } else {
                                    wizard.setIsXMLFunction(false);
                                }
                            }
                            wizard.setIsColumn(false);
                            ExpressionBuilderDialog dialog = new ExpressionBuilderDialog(Display.getDefault().getActiveShell(), wizard);
                            dialog.create();
                            dialog.setBlockOnOpen(true);
                            int result = dialog.open();
                            QueryValueExpression newExpr = null;
                            if (result == 0) {
                                newExpr = wizard.getSQLExpression();
                            }
                            if (newExpr instanceof ValueExpressionCombined) {
                                ValueExpressionNested nestedExpr = ExpressionHelper.createNestedExpression(newExpr);
                                this.expressionElement.setExpression((QueryValueExpression)nestedExpr);
                            } else {
                                this.expressionElement.setExpression(newExpr);
                            }
                            Vector elements = this.expressionElement.getElementsVector();
                            if (elements != null && !elements.isEmpty()) {
                                ExpressionElement e = (ExpressionElement)elements.get(0);
                                QueryValueExpression firstExpr = e.getExpression();
                                QueryValueExpression root = ExpressionHelper.getRoot(firstExpr);
                                int paramNo = e.getParameterNum();
                                ParamTable.this.getFunctionBuilderPage().setParamValue(paramNo, root);
                            }
                            Display.getCurrent().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    ParamTableCellModifier.this.viewer.refresh();
                                }
                            });
                            ParamTable.this.getFunctionBuilderPage().updateFinishButton();
                        }
                    }
                }
            } else if (property.equals(ParamTable.PARAMETER_OPERATOR)) {
                Assert.isTrue((boolean)(element instanceof TableItem));
                Object data = ((TableItem)this.currentElement).getData();
                if (this.currentValue == null) {
                    return;
                }
                if (data instanceof ExpressionElement) {
                    this.expressionElement = (ExpressionElement)data;
                    if (this.currentValue instanceof String) {
                        ValueExpressionCombinedOperator currentOp = this.expressionElement.getOperator();
                        this.expressionElement.setOperator((String)this.currentValue);
                        Vector elements = this.expressionElement.getElementsVector();
                        if (elements != null && !elements.isEmpty()) {
                            ExpressionElement e = (ExpressionElement)elements.get(0);
                            QueryValueExpression firstExpr = e.getExpression();
                            QueryValueExpression root = ExpressionHelper.getRoot(firstExpr);
                            int paramNo = e.getParameterNum();
                            if (currentOp != null) {
                                ParamTable.this.getFunctionBuilderPage().setParamValue(paramNo, root);
                            } else {
                                ParamTable.this.getFunctionBuilderPage().insertParamValue(paramNo, root);
                            }
                        }
                        Display.getCurrent().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ParamTableCellModifier.this.viewer.refresh();
                            }
                        });
                        ParamTable.this.getFunctionBuilderPage().updateFinishButton();
                    }
                }
            }
        }
    }

    public class ParamTableContentProvider
    implements IStructuredContentProvider {
        protected Vector allTableElements;
        protected Vector tableElements;
        protected int expressionNumber;
        int noOfParams;

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object old, Object newobj) {
        }

        public Object[] getElements(Object object) {
            this.allTableElements = new Vector();
            if (object instanceof ValueExpressionFunction) {
                ValueExpressionFunction funcExpr = (ValueExpressionFunction)object;
                EList paramExprList = funcExpr.getParameterList();
                int paramExprs = paramExprList.size();
                QueryValueExpression paramExpr = null;
                int i = 0;
                while (i < paramExprs) {
                    this.tableElements = new Vector();
                    paramExpr = (QueryValueExpression)paramExprList.get(i);
                    this.getAllExpressionElements(paramExpr, i);
                    this.addBlankExpressionElement(paramExpr, i);
                    this.allTableElements.addAll(this.tableElements);
                    ++i;
                }
            }
            return this.allTableElements.toArray();
        }

        void getAllExpressionElements(QueryValueExpression expr, int paramNum) {
            if (expr instanceof ValueExpressionCombined) {
                ValueExpressionCombined combinedExpr = (ValueExpressionCombined)expr;
                QueryValueExpression leftChild = combinedExpr.getLeftValueExpr();
                QueryValueExpression rightChild = combinedExpr.getRightValueExpr();
                if (leftChild != null) {
                    this.getAllExpressionElements(leftChild, paramNum);
                }
                if (rightChild != null) {
                    this.getAllExpressionElements(rightChild, paramNum);
                }
            } else {
                ValueExpressionCombinedOperator operator = null;
                ValueExpressionCombined parent = expr.getValueExprCombinedLeft();
                if (parent == null && expr.getValueExprCombinedRight() != null) {
                    parent = expr.getValueExprCombinedRight().getValueExprCombinedLeft();
                }
                if (parent != null) {
                    operator = parent.getCombinedOperator();
                }
                this.creatExpressionElement(expr, operator, paramNum);
            }
        }

        void creatExpressionElement(QueryValueExpression node, ValueExpressionCombinedOperator opr, int paramNum) {
            ExpressionElement exprElement = new ExpressionElement(node, opr, paramNum);
            WeakReference<Vector> tableElementRef = new WeakReference<Vector>(this.tableElements);
            exprElement.setExprElementVectorRef(tableElementRef);
            this.tableElements.add(exprElement);
        }

        void addBlankExpressionElement(QueryValueExpression initialNode, int paramNum) {
            if (this.tableElements.size() == 0) {
                this.creatExpressionElement(initialNode, null, 0);
            } else {
                ExpressionElement lastElement = (ExpressionElement)this.tableElements.lastElement();
                if (lastElement.getOperator() != null) {
                    this.creatExpressionElement(null, null, paramNum);
                }
            }
        }
    }

    class ParamTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ParamTableLabelProvider() {
        }

        public String getColumnText(Object object, int columnIndex) {
            String colText = "";
            if (object instanceof ExpressionElement) {
                ExpressionElement exprElement = (ExpressionElement)object;
                if (columnIndex == 0) {
                    colText = exprElement.getColumnLabel();
                } else if (columnIndex == 1) {
                    colText = exprElement.getExpressionString();
                } else if (columnIndex == 2) {
                    colText = exprElement.getOperatorString();
                }
            }
            return colText;
        }

        public Image getColumnImage(Object object, int columnIndex) {
            return null;
        }
    }
}

