/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.context.java;

import java.util.List;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.jaxb.core.JptJaxbCoreMessages;
import org.eclipse.jpt.jaxb.core.context.AbstractQName;
import org.eclipse.jpt.jaxb.core.context.JaxbClassMapping;
import org.eclipse.jpt.jaxb.core.context.JaxbContextNode;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.XmlElementWrapper;
import org.eclipse.jpt.jaxb.core.context.XmlNsForm;
import org.eclipse.jpt.jaxb.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jaxb.core.xsd.XsdElementDeclaration;
import org.eclipse.jpt.jaxb.core.xsd.XsdSchema;
import org.eclipse.jpt.jaxb.core.xsd.XsdTypeDefinition;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public abstract class AbstractJavaElementQName
extends AbstractQName {
    public AbstractJavaElementQName(JaxbContextNode parent, AbstractQName.ResourceProxy proxy) {
        super(parent, proxy);
    }

    @Override
    public String getReferencedComponentTypeDescription() {
        return JptJaxbCoreMessages.XML_ELEMENT_DESC;
    }

    protected abstract JavaPersistentAttribute getPersistentAttribute();

    protected JaxbClassMapping getClassMapping() {
        return this.getPersistentAttribute().getClassMapping();
    }

    @Override
    protected JaxbPackage getJaxbPackage() {
        return this.getClassMapping().getJaxbPackage();
    }

    protected abstract XmlElementWrapper getElementWrapper();

    @Override
    protected String buildDefaultName() {
        return this.getPersistentAttribute().getJavaResourceAttribute().getName();
    }

    @Override
    public Iterable<String> getNameProposals() {
        XsdTypeDefinition xsdType = this.getClassMapping().getXsdTypeDefinition();
        if (xsdType == null) {
            return EmptyIterable.instance();
        }
        XmlElementWrapper elementWrapper = this.getElementWrapper();
        if (elementWrapper == null) {
            return xsdType.getElementNameProposals(this.getNamespace());
        }
        XsdElementDeclaration xsdWrapperElement = elementWrapper.getXsdElementDeclaration();
        if (xsdWrapperElement != null) {
            return xsdWrapperElement.getElementNameProposals(this.getNamespace());
        }
        return EmptyIterable.instance();
    }

    @Override
    protected String buildDefaultNamespace() {
        JaxbPackage jaxbPackage = this.getJaxbPackage();
        return jaxbPackage != null && jaxbPackage.getElementFormDefault() == XmlNsForm.QUALIFIED ? this.getClassMapping().getQName().getNamespace() : "";
    }

    @Override
    public Iterable<String> getNamespaceProposals() {
        XsdSchema schema = this.getXsdSchema();
        return schema == null ? EmptyIterable.instance() : schema.getNamespaceProposals();
    }

    @Override
    protected void validateReference(List<IMessage> messages, IReporter reporter) {
        XsdTypeDefinition xsdType = this.getClassMapping().getXsdTypeDefinition();
        if (xsdType == null) {
            return;
        }
        XsdElementDeclaration resolvedXsdElement = null;
        XmlElementWrapper elementWrapper = this.getElementWrapper();
        if (elementWrapper == null) {
            resolvedXsdElement = xsdType.getElement(this.getNamespace(), this.getName());
        } else {
            XsdElementDeclaration xsdWrapperElement = elementWrapper.getXsdElementDeclaration();
            if (xsdWrapperElement == null) {
                return;
            }
            resolvedXsdElement = xsdWrapperElement.getElement(this.getNamespace(), this.getName());
        }
        if (resolvedXsdElement == null) {
            messages.add(this.getUnresolveSchemaComponentMessage());
        }
    }
}

