/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import java.io.File;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.equinox.internal.p2.director.PermissiveSlicer;
import org.eclipse.equinox.internal.p2.engine.DownloadManager;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitPhase;
import org.eclipse.equinox.internal.p2.engine.Phase;
import org.eclipse.equinox.internal.p2.engine.PhaseSet;
import org.eclipse.equinox.internal.p2.engine.ProfileMetadataRepository;
import org.eclipse.equinox.internal.p2.engine.phases.Collect;
import org.eclipse.equinox.internal.p2.engine.phases.Configure;
import org.eclipse.equinox.internal.p2.engine.phases.Install;
import org.eclipse.equinox.internal.p2.engine.phases.Property;
import org.eclipse.equinox.internal.p2.engine.phases.Uninstall;
import org.eclipse.equinox.internal.p2.garbagecollector.GarbageCollector;
import org.eclipse.equinox.internal.p2.repository.helpers.RepositoryHelper;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IPhaseSet;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.PhaseSetFactory;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.engine.query.IUProfilePropertyQuery;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.IRepositoryReference;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRequest;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.target.IUBundleContainer;
import org.eclipse.pde.internal.core.target.InstallableUnitGenerator;
import org.eclipse.pde.internal.core.target.LocalTargetHandle;
import org.eclipse.pde.internal.core.target.Messages;
import org.eclipse.pde.internal.core.target.TargetDefinition;
import org.eclipse.pde.internal.core.target.TargetPlatformService;
import org.eclipse.pde.internal.core.target.TargetReferenceBundleContainer;
import org.eclipse.pde.internal.core.target.VirtualArtifactRepository;
import org.eclipse.pde.internal.core.target.VirtualMetadataRepository;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class P2TargetUtils {
    private static final String BUNDLE_POOL_SUFFIX = ".bundle_pool";
    private static final String SOURCE_IU_ID = "org.eclipse.pde.core.target.source.bundles";
    private static final String BUNDLE_POOL_REPO_NAME = "PDE Target Bundle Pool";
    public static URI AGENT_LOCATION;
    public static final IPath BUNDLE_POOL;
    static final IPath INSTALL_FOLDERS;
    static final String PROFILE_ID_PREFIX = "TARGET_DEFINITION:";
    static final String PROP_INSTALLED_IU = "org.eclipse.pde.core.installed_iu";
    static final String PROP_IU_VERSION_DECLARATION = "org.eclipse.pde.core.iu_version_declaration";
    static final String PROP_PROVISION_MODE = "org.eclipse.pde.core.provision_mode";
    static final String PROP_ALL_ENVIRONMENTS = "org.eclipse.pde.core.all_environments";
    static final String PROP_AUTO_INCLUDE_SOURCE = "org.eclipse.pde.core.autoIncludeSource";
    static final String PROP_INCLUDE_CONFIGURE_PHASE = "org.eclipse.pde.core.includeConfigure";
    static final String PROP_FOLLOW_REPOSITORY_REFERENCES = "org.eclipse.pde.core.followRepositoryReferences";
    static final String PROP_DECLARED_REPOSITORIES = "org.eclipse.pde.core.repositories";
    private static final Map<ITargetDefinition, P2TargetUtils> SYNCHRONIZERS;
    static final Map<ITargetDefinition, IFileArtifactRepository> fgTargetArtifactRepo;
    static final Map<IArtifactKey, Map<IFileArtifactRepository, File>> fgArtifactKeyRepoFile;
    private IProfile fProfile;
    private boolean fIncludeAllRequired = true;
    private boolean fIncludeMultipleEnvironments = false;
    private boolean fIncludeSource = false;
    private boolean fIncludeConfigurePhase = false;
    private boolean fFollowRepositoryReferences = true;
    private static final String REPOSITORY_LIST_DELIMITER = ",";
    private static final String VERSION_DECLARATION_SEPARATOR = ";";
    private static final String NATIVE_ARTIFACTS = "nativeArtifacts";
    private static final String NATIVE_TYPE = "org.eclipse.equinox.p2.native";
    private static final String PARM_OPERAND = "operand";

    static {
        try {
            AGENT_LOCATION = PDECore.getDefault().getStateLocation().append(".p2").toPath().toUri();
        }
        catch (Exception exception) {
            // empty catch block
        }
        BUNDLE_POOL = PDECore.getDefault().getStateLocation().append(BUNDLE_POOL_SUFFIX);
        INSTALL_FOLDERS = PDECore.getDefault().getStateLocation().append(".install_folders");
        SYNCHRONIZERS = new WeakHashMap<ITargetDefinition, P2TargetUtils>();
        fgTargetArtifactRepo = new ConcurrentHashMap<ITargetDefinition, IFileArtifactRepository>();
        fgArtifactKeyRepoFile = new ConcurrentHashMap<IArtifactKey, Map<IFileArtifactRepository, File>>();
    }

    public static List<String> cleanOrphanedTargetDefinitionProfiles() throws CoreException {
        ArrayList<String> list = new ArrayList<String>();
        ITargetPlatformService tps = TargetPlatformService.getDefault();
        if (tps != null) {
            IProfile[] profiles;
            IProfile[] iProfileArray = profiles = P2TargetUtils.getProfileRegistry().getProfiles();
            int n = profiles.length;
            int n2 = 0;
            while (n2 < n) {
                block6: {
                    IProfile profile = iProfileArray[n2];
                    String id = profile.getProfileId();
                    if (id.startsWith(PROFILE_ID_PREFIX)) {
                        block5: {
                            String memento = id.substring(PROFILE_ID_PREFIX.length());
                            try {
                                ITargetHandle handle = tps.getTarget(memento);
                                if (!handle.exists()) break block5;
                                break block6;
                            }
                            catch (CoreException coreException) {
                                // empty catch block
                            }
                        }
                        P2TargetUtils.deleteProfileWithId(id);
                        list.add(id);
                    }
                }
                ++n2;
            }
        }
        return list;
    }

    public static void deleteProfile(ITargetHandle handle) throws CoreException {
        P2TargetUtils.deleteProfileWithId(P2TargetUtils.getProfileId(handle));
    }

    private static void deleteProfileWithId(String profileId) throws CoreException {
        IProfileRegistry registry = P2TargetUtils.getProfileRegistry();
        IProfile profile = registry.getProfile(profileId);
        if (profile != null) {
            String location = profile.getProperty("org.eclipse.equinox.p2.installFolder");
            registry.removeProfile(profileId);
            if (location != null && location.length() > 0) {
                File folder = new File(location);
                CoreUtility.deleteContent(folder);
            }
        }
    }

    public static void forceCheckTarget(ITargetDefinition target) {
        P2TargetUtils result = P2TargetUtils.getSynchronizer(target);
        result.resetProfile();
    }

    private synchronized void resetProfile() {
        this.fProfile = null;
    }

    public static void garbageCollect() {
        try {
            IProfile[] profiles;
            IProfile[] iProfileArray = profiles = P2TargetUtils.getProfileRegistry().getProfiles();
            int n = profiles.length;
            int n2 = 0;
            while (n2 < n) {
                IProfile profile = iProfileArray[n2];
                if (profile.getProfileId().startsWith(PROFILE_ID_PREFIX)) {
                    P2TargetUtils.getGarbageCollector().runGC(profile);
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private String generateEnvironmentProperties(ITargetDefinition target) {
        StringBuilder env = new StringBuilder();
        this.appendEnv(env, "osgi.ws", target.getWS(), Platform::getWS);
        env.append(REPOSITORY_LIST_DELIMITER);
        this.appendEnv(env, "osgi.os", target.getOS(), Platform::getOS);
        env.append(REPOSITORY_LIST_DELIMITER);
        this.appendEnv(env, "osgi.arch", target.getArch(), Platform::getOSArch);
        return env.toString();
    }

    private void appendEnv(StringBuilder env, String key, String value, Supplier<String> defaultValue) {
        env.append(key).append('=').append(value != null ? value : defaultValue.get());
    }

    private String generateNLProperty(ITargetDefinition target) {
        String nl = target.getNL();
        return nl != null ? nl : Platform.getNL();
    }

    /*
     * Loose catch block
     */
    public static IProvisioningAgent getAgent() throws CoreException {
        block14: {
            BundleContext context;
            ServiceReference reference;
            block12: {
                IProvisioningAgent iProvisioningAgent;
                block13: {
                    String filter = "(locationURI=" + String.valueOf(AGENT_LOCATION) + ")";
                    reference = null;
                    context = PDECore.getDefault().getBundleContext();
                    try {
                        Collection serviceReferences = context.getServiceReferences(IProvisioningAgent.class, filter);
                        if (serviceReferences.isEmpty()) break block12;
                        reference = (ServiceReference)serviceReferences.iterator().next();
                        iProvisioningAgent = (IProvisioningAgent)context.getService(reference);
                        if (reference == null) break block13;
                    }
                    catch (InvalidSyntaxException serviceReferences) {
                        if (reference != null) {
                            context.ungetService(reference);
                        }
                        break block14;
                        catch (Throwable throwable) {
                            if (reference != null) {
                                context.ungetService(reference);
                            }
                            throw throwable;
                        }
                    }
                    context.ungetService(reference);
                }
                return iProvisioningAgent;
            }
            if (reference != null) {
                context.ungetService(reference);
            }
        }
        IProvisioningAgentProvider provider = PDECore.getDefault().acquireService(IProvisioningAgentProvider.class);
        try {
            if (provider == null) {
                throw new CoreException(Status.error((String)Messages.IUBundleContainer_7));
            }
            IProvisioningAgent agent = provider.createAgent(AGENT_LOCATION);
            if (agent == null) {
                throw new CoreException(Status.error((String)Messages.IUBundleContainer_7));
            }
            GarbageCollector garbageCollector = (GarbageCollector)agent.getService(GarbageCollector.class);
            if (garbageCollector != null) {
                garbageCollector.stop();
            }
            return agent;
        }
        catch (ProvisionException e) {
            throw new CoreException(Status.error((String)Messages.IUBundleContainer_7, (Throwable)e));
        }
    }

    public static IProvisioningAgent getGlobalAgent() throws CoreException {
        IProvisioningAgent agent = PDECore.getDefault().acquireService(IProvisioningAgent.class);
        if (agent == null) {
            throw new CoreException(Status.error((String)Messages.IUBundleContainer_11));
        }
        return agent;
    }

    public static IAgentLocation getAgentLocation() throws CoreException {
        return P2TargetUtils.getP2Service(IAgentLocation.class, Messages.IUBundleContainer_10);
    }

    public static IArtifactRepositoryManager getArtifactRepositoryManager() throws CoreException {
        return P2TargetUtils.getP2Service(IArtifactRepositoryManager.class, Messages.IUBundleContainer_3);
    }

    public static IFileArtifactRepository getBundlePool() throws CoreException {
        URI uri = BUNDLE_POOL.toFile().toURI();
        IArtifactRepositoryManager manager = P2TargetUtils.getArtifactRepositoryManager();
        try {
            if (manager.contains(uri)) {
                return (IFileArtifactRepository)manager.loadRepository(uri, null);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        IArtifactRepository result = manager.createRepository(uri, BUNDLE_POOL_REPO_NAME, "org.eclipse.equinox.p2.artifact.repository.simpleRepository", null);
        return (IFileArtifactRepository)result;
    }

    public static boolean isBundlePool(IFileArtifactRepository repository) {
        if (repository == null) {
            return false;
        }
        URI location = repository.getLocation();
        if (location == null) {
            return false;
        }
        if (!"file".equals(location.getScheme())) {
            return false;
        }
        String path = location.getPath();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path.endsWith(BUNDLE_POOL_SUFFIX);
    }

    public static IEngine getEngine() throws CoreException {
        return P2TargetUtils.getP2Service(IEngine.class, Messages.IUBundleContainer_4);
    }

    public static GarbageCollector getGarbageCollector() throws CoreException {
        return P2TargetUtils.getP2Service(GarbageCollector.class, Messages.IUBundleContainer_9);
    }

    public static IPlanner getPlanner() throws CoreException {
        return P2TargetUtils.getP2Service(IPlanner.class, Messages.IUBundleContainer_5);
    }

    public static IPreferencesService getPreferences() {
        return PDECore.getDefault().acquireService(IPreferencesService.class);
    }

    private boolean checkProfile(ITargetDefinition target, IProfile profile) {
        if (profile == null) {
            return false;
        }
        boolean all = false;
        String value = profile.getProperty(PROP_ALL_ENVIRONMENTS);
        if (value != null) {
            all = Boolean.parseBoolean(value);
            if (!Boolean.toString(this.getIncludeAllEnvironments()).equals(value)) {
                return false;
            }
        }
        if (!all && !this.generateEnvironmentProperties(target).equals(profile.getProperty("org.eclipse.equinox.p2.environments"))) {
            return false;
        }
        if (!this.generateNLProperty(target).equals(profile.getProperty("org.eclipse.equinox.p2.nl"))) {
            return false;
        }
        if (!this.getProvisionMode().equals(profile.getProperty(PROP_PROVISION_MODE))) {
            return false;
        }
        if (this.getIncludeSource() != Boolean.parseBoolean(profile.getProperty(PROP_AUTO_INCLUDE_SOURCE))) {
            return false;
        }
        if (this.getIncludeConfigurePhase() != Boolean.parseBoolean(profile.getProperty(PROP_INCLUDE_CONFIGURE_PHASE))) {
            return false;
        }
        if (this.isFollowRepositoryReferences() != Boolean.parseBoolean(profile.getProperty(PROP_FOLLOW_REPOSITORY_REFERENCES))) {
            return false;
        }
        List<IUBundleContainer> iuContainers = this.iuBundleContainersOf(target).toList();
        String recordedRepositories = profile.getProperty(PROP_DECLARED_REPOSITORIES);
        Set declaredRepositories = iuContainers.stream().map(IUBundleContainer::getRepositories).flatMap(Collection::stream).collect(Collectors.toSet());
        if (recordedRepositories != null && !this.decodeURIs(recordedRepositories).equals(declaredRepositories)) {
            return false;
        }
        IUProfilePropertyQuery propertyQuery = new IUProfilePropertyQuery(PROP_INSTALLED_IU, Boolean.toString(true));
        IQueryResult queryResult = profile.query((IQuery)propertyQuery, null);
        HashMap<String, Set> installedIUs = new HashMap<String, Set>();
        for (IInstallableUnit unit : queryResult) {
            Set declarations = installedIUs.computeIfAbsent(unit.getId(), id -> new HashSet(1));
            String declaredVersions = profile.getInstallableUnitProperty(unit, PROP_IU_VERSION_DECLARATION);
            this.parseVersions(unit, declaredVersions).forEach(declarations::add);
        }
        Map declaredIUs = iuContainers.stream().map(IUBundleContainer::getDeclaredUnits).flatMap(Collection::stream).collect(Collectors.groupingBy(IUBundleContainer.UnitDeclaration::id, Collectors.mapping(IUBundleContainer.UnitDeclaration::version, Collectors.toSet())));
        return installedIUs.equals(declaredIUs);
    }

    private Stream<IUBundleContainer> iuBundleContainersOf(ITargetDefinition target) {
        ITargetLocation[] locations = target.getTargetLocations();
        return locations == null ? Stream.empty() : Arrays.stream(locations).filter(IUBundleContainer.class::isInstance).map(IUBundleContainer.class::cast);
    }

    public void setIncludeAllRequired(boolean value) {
        this.fIncludeAllRequired = value;
    }

    public boolean getIncludeAllRequired() {
        return this.fIncludeAllRequired;
    }

    public void setIncludeAllEnvironments(boolean value) {
        this.fIncludeMultipleEnvironments = value;
    }

    public boolean getIncludeAllEnvironments() {
        return this.fIncludeMultipleEnvironments;
    }

    public void setIncludeSource(boolean value) {
        this.fIncludeSource = value;
    }

    public boolean getIncludeSource() {
        return this.fIncludeSource;
    }

    public void setIncludeConfigurePhase(boolean value) {
        this.fIncludeConfigurePhase = value;
    }

    public boolean getIncludeConfigurePhase() {
        return this.fIncludeConfigurePhase;
    }

    public void setFollowRepositoryReferences(boolean value) {
        this.fFollowRepositoryReferences = value;
    }

    public boolean isFollowRepositoryReferences() {
        return this.fFollowRepositoryReferences;
    }

    public static boolean isResolved(ITargetDefinition target) {
        P2TargetUtils synchronizer = P2TargetUtils.getSynchronizer(target);
        if (synchronizer == null) {
            return false;
        }
        return synchronizer.checkProfile(target, synchronizer.getProfile()) && P2TargetUtils.allReferencedTargets(target).allMatch(P2TargetUtils::isResolved);
    }

    public static boolean isProfileValid(ITargetDefinition target) {
        P2TargetUtils synchronizer = P2TargetUtils.getSynchronizer(target);
        if (synchronizer == null) {
            return false;
        }
        return synchronizer.checkProfile(target, synchronizer.updateProfileFromRegistry(target)) && P2TargetUtils.allReferencedTargets(target).allMatch(P2TargetUtils::isProfileValid);
    }

    private static Stream<ITargetDefinition> allReferencedTargets(ITargetDefinition target) {
        return Arrays.stream(target.getTargetLocations()).filter(TargetReferenceBundleContainer.class::isInstance).map(TargetReferenceBundleContainer.class::cast).flatMap(referenceContainer -> {
            try {
                ITargetDefinition refTarget = referenceContainer.getTargetDefinition();
                return Stream.concat(Stream.of(refTarget), P2TargetUtils.allReferencedTargets(refTarget));
            }
            catch (CoreException e) {
                ILog.get().error("Failed to retrieve referenced target", (Throwable)e);
                return Stream.empty();
            }
        });
    }

    private synchronized IProfile updateProfileFromRegistry(ITargetDefinition target) {
        if (this.fProfile == null) {
            try {
                this.fProfile = P2TargetUtils.getProfileRegistry().getProfile(P2TargetUtils.getProfileId(target));
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return this.fProfile;
    }

    static synchronized P2TargetUtils getSynchronizer(ITargetDefinition target) {
        return SYNCHRONIZERS.computeIfAbsent(target, t -> new P2TargetUtils());
    }

    public static IQueryResult<IInstallableUnit> getIUs(ITargetDefinition target, IProgressMonitor monitor) throws CoreException {
        P2TargetUtils synchronizer = P2TargetUtils.getSynchronizer(target);
        if (synchronizer == null) {
            return null;
        }
        synchronizer.synchronize(target, monitor);
        return synchronizer.getProfile().query(QueryUtil.createIUAnyQuery(), null);
    }

    public synchronized void synchronize(ITargetDefinition target, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IProfile profile = this.getProfile();
        if (profile == null) {
            profile = P2TargetUtils.getProfileRegistry().getProfile(P2TargetUtils.getProfileId(target));
        }
        if (profile != null && this.checkProfile(target, profile)) {
            this.fProfile = profile;
            this.notify(target, (IProgressMonitor)progress.split(25));
            return;
        }
        P2TargetUtils.deleteProfile(target.getHandle());
        profile = this.createProfile(target);
        if (progress.isCanceled()) {
            return;
        }
        progress.setWorkRemaining(75);
        try {
            if (this.getIncludeAllRequired()) {
                this.resolveWithPlanner(target, profile, (IProgressMonitor)progress.split(60));
            } else {
                this.resolveWithSlicer(target, profile, (IProgressMonitor)progress.split(60));
            }
            this.fProfile = profile;
            this.notify(target, (IProgressMonitor)progress.split(15));
        }
        catch (CoreException e) {
            this.fProfile = null;
            try {
                P2TargetUtils.deleteProfile(target.getHandle());
            }
            catch (CoreException e2) {
                PDECore.log(e2.getStatus());
            }
            throw e;
        }
    }

    private IProfile createProfile(ITargetDefinition target) throws CoreException {
        IProfileRegistry registry = P2TargetUtils.getProfileRegistry();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("org.eclipse.equinox.p2.installFolder", INSTALL_FOLDERS.append(Long.toString(LocalTargetHandle.nextTimeStamp())).toOSString());
        properties.put("org.eclipse.equinox.p2.cache", BUNDLE_POOL.toOSString());
        properties.put("org.eclipse.update.install.features", Boolean.TRUE.toString());
        properties.put("org.eclipse.equinox.p2.environments", this.generateEnvironmentProperties(target));
        properties.put("org.eclipse.equinox.p2.nl", this.generateNLProperty(target));
        this.setProperties(properties::put, target, this.getProvisionMode());
        return registry.addProfile(P2TargetUtils.getProfileId(target), properties);
    }

    private void notify(ITargetDefinition target, IProgressMonitor monitor) {
        ((TargetDefinition)target).flushCaches(BUNDLE_POOL.toOSString());
        ITargetLocation[] containers = target.getTargetLocations();
        if (containers != null) {
            ITargetLocation[] iTargetLocationArray = containers;
            int n = containers.length;
            int n2 = 0;
            while (n2 < n) {
                ITargetLocation container = iTargetLocationArray[n2];
                if (container instanceof IUBundleContainer) {
                    IUBundleContainer iuContainer = (IUBundleContainer)container;
                    iuContainer.synchronizerChanged(target);
                }
                ++n2;
            }
        }
    }

    private static String getProfileId(ITargetHandle handle) throws CoreException {
        String memento = handle.getMemento();
        return PROFILE_ID_PREFIX + P2TargetUtils.getProfileSuffix(memento);
    }

    private static String getProfileSuffix(String memento) {
        int escapedLength = 0;
        int length = memento.length();
        if (length > 50) {
            int i = length - 1;
            while (i >= 0) {
                if ((escapedLength += (switch (memento.charAt(i)) {
                    case '\"', '%', '*', '/', ':', '<', '>', '?', '\\', '|' -> 4;
                    default -> 1;
                })) > 200) {
                    return memento.substring(i + 1) + memento.hashCode();
                }
                --i;
            }
        }
        return memento;
    }

    public static String getProfileId(ITargetDefinition definition) {
        try {
            return P2TargetUtils.getProfileId(definition.getHandle());
        }
        catch (CoreException e) {
            return null;
        }
    }

    public static IProfileRegistry getProfileRegistry() throws CoreException {
        return P2TargetUtils.getP2Service(IProfileRegistry.class, Messages.IUBundleContainer_8);
    }

    private String getProvisionMode() {
        return this.getIncludeAllRequired() ? "planner" : "slicer";
    }

    public static IMetadataRepositoryManager getRepoManager() throws CoreException {
        return P2TargetUtils.getP2Service(IMetadataRepositoryManager.class, Messages.IUBundleContainer_2);
    }

    private static <T> T getP2Service(Class<T> key, String absentErrorMessage) throws CoreException {
        Object service = P2TargetUtils.getAgent().getService(key);
        if (service == null) {
            throw new CoreException(Status.error((String)absentErrorMessage));
        }
        return (T)service;
    }

    static IQueryable<IInstallableUnit> getQueryableMetadata(Collection<URI> repos, boolean followRepositoryReferences, IProgressMonitor monitor) throws CoreException {
        return P2TargetUtils.getQueryableMetadata(repos, followRepositoryReferences, false, monitor);
    }

    static IQueryable<IInstallableUnit> getQueryableMetadata(Collection<URI> repos, boolean followRepositoryReferences, boolean forceReload, IProgressMonitor monitor) throws CoreException {
        IMetadataRepositoryManager metadataRepositoryManager = P2TargetUtils.getRepoManager();
        LinkedHashSet<URI> existing = new LinkedHashSet<URI>(Arrays.asList(metadataRepositoryManager.getKnownRepositories(0)));
        if (repos.isEmpty()) {
            repos = existing;
        }
        int work = repos.size() * (forceReload ? 4 : 2);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)work);
        HashSet<IRepositoryReference> seen = new HashSet<IRepositoryReference>();
        ArrayList<IMetadataRepository> result = new ArrayList<IMetadataRepository>(repos.size());
        ArrayList<IMetadataRepository> additional = new ArrayList<IMetadataRepository>();
        MultiStatus repoStatus = new MultiStatus("org.eclipse.pde.core", 0, Messages.IUBundleContainer_ProblemsLoadingRepositories);
        for (URI location : repos) {
            try {
                IMetadataRepository repository = metadataRepositoryManager.loadRepository(location, (IProgressMonitor)subMonitor.split(1));
                result.add(repository);
                if (!followRepositoryReferences) continue;
                P2TargetUtils.addReferences(repository, additional, seen, metadataRepositoryManager, (IProgressMonitor)subMonitor.split(1));
            }
            catch (ProvisionException e) {
                repoStatus.add(e.getStatus());
            }
        }
        if (result.size() != repos.size()) {
            throw new CoreException((IStatus)repoStatus);
        }
        result.addAll(additional);
        if (result.isEmpty()) {
            return QueryUtil.compoundQueryable(List.of());
        }
        AbstractCollection unique = new LinkedHashSet(result);
        if (forceReload) {
            ArrayList<IMetadataRepository> refreshed = new ArrayList<IMetadataRepository>();
            subMonitor.setWorkRemaining(2 * unique.size());
            IArtifactRepositoryManager artifactRepositoryManager = P2TargetUtils.getArtifactRepositoryManager();
            metadataRepositoryManager = P2TargetUtils.getRepoManager();
            LinkedHashSet<URI> existingArtifactRepositories = new LinkedHashSet<URI>(Arrays.asList(artifactRepositoryManager.getKnownRepositories(0)));
            for (IMetadataRepository metadataRepository : unique) {
                URI location = metadataRepository.getLocation();
                if (existing.contains(location)) {
                    try {
                        refreshed.add(metadataRepositoryManager.refreshRepository(location, (IProgressMonitor)subMonitor.split(1)));
                    }
                    catch (ProvisionException e) {
                        ILog.get().warn(NLS.bind((String)Messages.P2TargetUtils_cant_refresh_metadata, (Object)location), (Throwable)e);
                        refreshed.add(metadataRepository);
                    }
                    if (!existingArtifactRepositories.contains(location)) continue;
                    try {
                        artifactRepositoryManager.refreshRepository(location, (IProgressMonitor)subMonitor.split(1));
                    }
                    catch (ProvisionException e) {
                        ILog.get().warn(NLS.bind((String)Messages.P2TargetUtils_cant_refresh_artifacts, (Object)location), (Throwable)e);
                    }
                    continue;
                }
                refreshed.add(metadataRepository);
            }
            unique = refreshed;
        }
        if (unique.size() == 1) {
            return (IQueryable)unique.iterator().next();
        }
        return QueryUtil.compoundQueryable(unique);
    }

    private static void addReferences(IMetadataRepository repository, List<IMetadataRepository> result, Set<IRepositoryReference> seen, IMetadataRepositoryManager manager, IProgressMonitor monitor) {
        Collection references = repository.getReferences();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(references.size() * 2));
        for (IRepositoryReference reference : references) {
            if (reference.getType() != 0 || !reference.isEnabled() || !seen.add(reference)) continue;
            try {
                IMetadataRepository referencedRepository = manager.loadRepository(reference.getLocation(), (IProgressMonitor)subMonitor.split(1));
                result.add(referencedRepository);
                P2TargetUtils.addReferences(referencedRepository, result, seen, manager, (IProgressMonitor)subMonitor.split(1));
            }
            catch (ProvisionException e) {
                PDECore.log(e);
            }
        }
    }

    private void resolveWithPlanner(ITargetDefinition target, IProfile profile, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.IUBundleContainer_0, (int)220);
        Map<IInstallableUnit, String> units = this.getRootIUs(target, (IProgressMonitor)subMonitor.split(20));
        IPlanner planner = P2TargetUtils.getPlanner();
        IProfileChangeRequest request = planner.createChangeRequest(profile);
        this.computeRemovals(profile, request, this.getIncludeSource());
        request.addAll(units.keySet());
        units.forEach((unit, versionDeclarations) -> {
            request.setInstallableUnitProfileProperty(unit, PROP_INSTALLED_IU, Boolean.toString(true));
            request.setInstallableUnitProfileProperty(unit, PROP_IU_VERSION_DECLARATION, versionDeclarations);
        });
        final ArrayList<IArtifactRepository> extraArtifactRepositories = new ArrayList<IArtifactRepository>();
        final ArrayList<IMetadataRepository> extraMetadataRepositories = new ArrayList<IMetadataRepository>();
        this.addAdditionalProvisionIUs(target, extraArtifactRepositories, extraMetadataRepositories);
        ProvisioningContext context = new ProvisioningContext(P2TargetUtils.getAgent()){

            public IQueryable<IArtifactRepository> getArtifactRepositories(IProgressMonitor monitor) {
                return QueryUtil.compoundQueryable((IQueryable)super.getArtifactRepositories(monitor), (query, ignore) -> query.perform(extraArtifactRepositories.iterator()));
            }

            public IQueryable<IInstallableUnit> getMetadata(IProgressMonitor monitor) {
                return QueryUtil.compoundQueryable((IQueryable)super.getMetadata(monitor), (IQueryable)QueryUtil.compoundQueryable((Collection)extraMetadataRepositories));
            }
        };
        context.setProperty("org.eclipse.equinox.p2.director.followRepositoryReferences", Boolean.toString(this.isFollowRepositoryReferences()));
        context.setProperty("org.eclipse.equinox.p2.director.followArtifactRepositoryReferences", Boolean.toString(this.isFollowRepositoryReferences()));
        context.setMetadataRepositories((URI[])this.getMetadataRepositories(target).toArray(URI[]::new));
        context.setArtifactRepositories((URI[])this.getArtifactRepositories(target).toArray(URI[]::new));
        IProvisioningPlan plan = planner.getProvisioningPlan(request, context, (IProgressMonitor)subMonitor.split(20));
        IStatus status = plan.getStatus();
        if (!status.isOK()) {
            throw new CoreException(status);
        }
        this.setProperties((arg_0, arg_1) -> ((IProvisioningPlan)plan).setProfileProperty(arg_0, arg_1), target, "planner");
        IProvisioningPlan installerPlan = plan.getInstallerPlan();
        if (installerPlan != null) {
            PDECore.log(Status.info((String)Messages.IUBundleContainer_6));
        }
        subMonitor.split(10);
        IPhaseSet phases = this.createPhaseSet();
        IEngine engine = P2TargetUtils.getEngine();
        IStatus result = engine.perform(plan, phases, (IProgressMonitor)subMonitor.split(100));
        if (result.getSeverity() == 4 || result.getSeverity() == 8) {
            throw new CoreException(result);
        }
        try {
            this.planInSourceBundles(profile, context, (IProgressMonitor)subMonitor.split(60));
        }
        catch (CoreException e) {
            try {
                P2TargetUtils.getProfileRegistry().removeProfile(profile.getProfileId(), profile.getTimestamp());
            }
            catch (CoreException e2) {
                PDECore.log(e2.getStatus());
            }
            throw e;
        }
    }

    private void setProperties(BiConsumer<String, String> setter, ITargetDefinition target, String mode) {
        setter.accept(PROP_PROVISION_MODE, mode);
        setter.accept(PROP_ALL_ENVIRONMENTS, Boolean.toString(this.getIncludeAllEnvironments()));
        setter.accept(PROP_AUTO_INCLUDE_SOURCE, Boolean.toString(this.getIncludeSource()));
        setter.accept(PROP_INCLUDE_CONFIGURE_PHASE, Boolean.toString(this.getIncludeConfigurePhase()));
        setter.accept(PROP_FOLLOW_REPOSITORY_REFERENCES, Boolean.toString(this.isFollowRepositoryReferences()));
        setter.accept(PROP_DECLARED_REPOSITORIES, this.iuBundleContainersOf(target).map(IUBundleContainer::getRepositories).flatMap(Collection::stream).collect(P2TargetUtils.joiningEncodeURIs()));
    }

    private static Collector<URI, ?, String> joiningEncodeURIs() {
        return Collectors.mapping(u -> URLEncoder.encode(u.toASCIIString(), StandardCharsets.UTF_8), Collectors.joining(REPOSITORY_LIST_DELIMITER));
    }

    private Set<URI> decodeURIs(String encodedList) {
        return Arrays.stream(encodedList.split(REPOSITORY_LIST_DELIMITER)).map(t -> URLDecoder.decode(t, StandardCharsets.UTF_8)).map(URI::create).collect(Collectors.toSet());
    }

    private IPhaseSet createPhaseSet() {
        ArrayList<Object> phases = new ArrayList<Object>(4);
        phases.add(new Collect(100));
        phases.add(new Property(1));
        phases.add(new Uninstall(50, true));
        phases.add(new Install(50));
        phases.add((Object)new CollectNativesPhase(100));
        if (this.getIncludeConfigurePhase()) {
            phases.add(new Configure(100));
        }
        return new PhaseSet((Phase[])phases.toArray(Phase[]::new));
    }

    private void computeRemovals(IProfile profile, IProfileChangeRequest request, boolean includeSource) {
        IInstallableUnit sourceIU;
        if (!includeSource && (sourceIU = this.getCurrentSourceIU((IQueryable<IInstallableUnit>)profile)) != null) {
            request.remove(sourceIU);
        }
        IUProfilePropertyQuery query = new IUProfilePropertyQuery(PROP_INSTALLED_IU, Boolean.toString(true));
        IQueryResult installedIUs = profile.query((IQuery)query, null);
        installedIUs.forEach(arg_0 -> ((IProfileChangeRequest)request).remove(arg_0));
    }

    private void planInSourceBundles(IProfile fProfile, ProvisioningContext context, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.P2TargetUtils_ProvisioningSourceTask, (int)100);
        IInstallableUnit currentSourceIU = this.getCurrentSourceIU((IQueryable<IInstallableUnit>)fProfile);
        Version sourceVersion = Version.createOSGi((int)1, (int)0, (int)0);
        if (currentSourceIU != null) {
            Integer major = (Integer)currentSourceIU.getVersion().getSegment(0);
            sourceVersion = Version.createOSGi((int)(major + 1), (int)0, (int)0);
        }
        IInstallableUnit sourceIU = this.createSourceIU((IQueryable<IInstallableUnit>)fProfile, sourceVersion);
        IPlanner planner = P2TargetUtils.getPlanner();
        IProfileChangeRequest request = planner.createChangeRequest(fProfile);
        if (currentSourceIU != null) {
            request.remove(currentSourceIU);
        }
        request.add(sourceIU);
        IProvisioningPlan plan = planner.getProvisioningPlan(request, context, (IProgressMonitor)subMonitor.split(25));
        IStatus status = plan.getStatus();
        if (!status.isOK()) {
            throw new CoreException(status);
        }
        if (subMonitor.isCanceled()) {
            return;
        }
        long oldTimestamp = fProfile.getTimestamp();
        IPhaseSet phases = PhaseSetFactory.createDefaultPhaseSetExcluding((String[])new String[]{"checkTrust", "configure", "unconfigure", "uninstall"});
        IEngine engine = P2TargetUtils.getEngine();
        plan.setProfileProperty(PROP_PROVISION_MODE, "planner");
        plan.setProfileProperty(PROP_ALL_ENVIRONMENTS, Boolean.toString(false));
        IStatus result = engine.perform(plan, phases, (IProgressMonitor)subMonitor.split(75));
        if (subMonitor.isCanceled()) {
            return;
        }
        if (!result.isOK()) {
            throw new CoreException(result);
        }
        P2TargetUtils.getProfileRegistry().removeProfile(fProfile.getProfileId(), oldTimestamp);
    }

    private IInstallableUnit createSourceIU(IQueryable<IInstallableUnit> queryable, Version iuVersion) {
        IRequirement bundleRequirement = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.eclipse.type", (String)"bundle", null, null, (boolean)false, (boolean)false, (boolean)false);
        IQueryResult profileIUs = queryable.query(QueryUtil.createIUAnyQuery(), null);
        ArrayList<IRequirement> requirements = new ArrayList<IRequirement>();
        for (IInstallableUnit profileIU : profileIUs) {
            if (!profileIU.satisfies(bundleRequirement)) continue;
            String id = profileIU.getId() + ".source";
            Version version = profileIU.getVersion();
            VersionRange range = new VersionRange(version, true, version, true);
            IRequirement sourceRequirement = MetadataFactory.createRequirement((String)"osgi.bundle", (String)id, (VersionRange)range, null, (boolean)true, (boolean)false, (boolean)true);
            requirements.add(sourceRequirement);
        }
        MetadataFactory.InstallableUnitDescription sourceDescription = new MetadataFactory.InstallableUnitDescription();
        sourceDescription.setSingleton(true);
        sourceDescription.setId(SOURCE_IU_ID);
        sourceDescription.setVersion(iuVersion);
        sourceDescription.addRequirements(requirements);
        IProvidedCapability capability = MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)SOURCE_IU_ID, (Version)iuVersion);
        sourceDescription.setCapabilities(new IProvidedCapability[]{capability});
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)sourceDescription);
    }

    private IInstallableUnit getCurrentSourceIU(IQueryable<IInstallableUnit> queryable) {
        IQuery query = QueryUtil.createIUQuery((String)SOURCE_IU_ID);
        return IUBundleContainer.queryFirst(queryable, query, null).orElse(null);
    }

    private void resolveWithSlicer(ITargetDefinition target, IProfile profile, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.IUBundleContainer_0, (int)110);
        Map<IInstallableUnit, String> units = this.getRootIUs(target, (IProgressMonitor)subMonitor.split(40));
        Collection<URI> repositories = this.getMetadataRepositories(target);
        if (repositories.isEmpty()) {
            return;
        }
        IQueryable<IInstallableUnit> allMetadata = P2TargetUtils.getQueryableMetadata(repositories, this.isFollowRepositoryReferences(), (IProgressMonitor)subMonitor.split(5));
        IQueryResult<IInstallableUnit> queryResult = this.slice(units.keySet(), allMetadata, target, (IProgressMonitor)subMonitor.split(5));
        if (queryResult == null || queryResult.isEmpty()) {
            return;
        }
        if (this.getIncludeSource()) {
            IInstallableUnit sourceIU = this.createSourceIU((IQueryable<IInstallableUnit>)queryResult, Version.createOSGi((int)1, (int)0, (int)0));
            ArrayList<IInstallableUnit> units2 = new ArrayList<IInstallableUnit>(units.keySet());
            units2.add(sourceIU);
            queryResult = this.slice(units2, allMetadata, target, (IProgressMonitor)subMonitor.split(5));
            if (queryResult == null || queryResult.isEmpty()) {
                return;
            }
        }
        IEngine engine = P2TargetUtils.getEngine();
        ProvisioningContext context = new ProvisioningContext(P2TargetUtils.getAgent());
        context.setMetadataRepositories((URI[])repositories.toArray(URI[]::new));
        context.setArtifactRepositories((URI[])this.getArtifactRepositories(target).toArray(URI[]::new));
        context.setProperty("org.eclipse.equinox.p2.director.followRepositoryReferences", Boolean.toString(this.isFollowRepositoryReferences()));
        context.setProperty("org.eclipse.equinox.p2.director.followArtifactRepositoryReferences", Boolean.toString(this.isFollowRepositoryReferences()));
        IProvisioningPlan plan = engine.createPlan(profile, context);
        this.setProperties((arg_0, arg_1) -> ((IProvisioningPlan)plan).setProfileProperty(arg_0, arg_1), target, "slicer");
        Set newSet = queryResult.toUnmodifiableSet();
        for (IInstallableUnit unit2 : newSet) {
            plan.addInstallableUnit(unit2);
        }
        units.forEach((unit, versionDeclarations) -> {
            plan.setInstallableUnitProfileProperty(unit, PROP_INSTALLED_IU, Boolean.toString(true));
            plan.setInstallableUnitProfileProperty(unit, PROP_IU_VERSION_DECLARATION, versionDeclarations);
        });
        Set toRemove = profile.query(QueryUtil.ALL_UNITS, null).toSet();
        toRemove.removeAll(newSet);
        for (IInstallableUnit name : toRemove) {
            plan.removeInstallableUnit(name);
        }
        subMonitor.split(5);
        IPhaseSet phases = this.createPhaseSet();
        IStatus result = engine.perform(plan, phases, (IProgressMonitor)subMonitor.split(50));
        if (result.getSeverity() == 4 || result.getSeverity() == 8) {
            throw new CoreException(result);
        }
    }

    private IQueryResult<IInstallableUnit> slice(Collection<IInstallableUnit> units, IQueryable<IInstallableUnit> allMetadata, ITargetDefinition definition, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        PermissiveSlicer slicer = null;
        if (this.getIncludeAllEnvironments()) {
            slicer = new PermissiveSlicer(allMetadata, new HashMap(), true, false, true, true, false);
        } else {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("osgi.os", definition.getOS() != null ? definition.getOS() : Platform.getOS());
            props.put("osgi.ws", definition.getWS() != null ? definition.getWS() : Platform.getWS());
            props.put("osgi.arch", definition.getArch() != null ? definition.getArch() : Platform.getOSArch());
            props.put("osgi.nl", definition.getNL() != null ? definition.getNL() : Platform.getNL());
            props.put("org.eclipse.update.install.features", Boolean.TRUE.toString());
            slicer = new PermissiveSlicer(allMetadata, props, true, false, false, true, false);
        }
        IQueryable slice = slicer.slice(units, (IProgressMonitor)subMonitor.split(50));
        MultiStatus sliceStatus = slicer.getStatus();
        if (sliceStatus.getSeverity() == 4) {
            throw new CoreException((IStatus)sliceStatus);
        }
        IQueryResult queryResult = null;
        if (slice != null) {
            queryResult = slice.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)subMonitor.split(50));
        }
        if (!sliceStatus.isOK() && queryResult != null && queryResult.isEmpty()) {
            throw new CoreException((IStatus)sliceStatus);
        }
        return queryResult;
    }

    private Collection<URI> getArtifactRepositories(ITargetDefinition target) throws CoreException {
        LinkedHashSet<URI> result = new LinkedHashSet<URI>();
        ITargetLocation[] containers = target.getTargetLocations();
        if (containers == null) {
            containers = new ITargetLocation[]{};
        }
        IArtifactRepositoryManager manager = P2TargetUtils.getArtifactRepositoryManager();
        ITargetLocation[] iTargetLocationArray = containers;
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            ITargetLocation container = iTargetLocationArray[n2];
            if (container instanceof IUBundleContainer) {
                IUBundleContainer iuContainer = (IUBundleContainer)container;
                List<URI> repos = iuContainer.getRepositories();
                if (repos.isEmpty()) {
                    repos = Arrays.asList(manager.getKnownRepositories(0));
                }
                result.addAll(repos);
            } else if (container instanceof TargetReferenceBundleContainer) {
                TargetReferenceBundleContainer targetRefContainer = (TargetReferenceBundleContainer)container;
                ITargetDefinition referencedTargetDefinition = targetRefContainer.getTargetDefinition();
                result.addAll(this.getArtifactRepositories(referencedTargetDefinition));
            }
            ++n2;
        }
        result.addAll(Arrays.asList(manager.getKnownRepositories(4)));
        if (Boolean.parseBoolean(System.getProperty("pde.usePoolsInfo", "true"))) {
            try {
                result.addAll(RepositoryHelper.getSharedBundlePools().stream().map(Path::toUri).toList());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.findProfileRepos(result);
        this.findWorkspaceRepos(result);
        return result;
    }

    private void findWorkspaceRepos(Set<URI> additionalRepos) {
        String[] recents;
        IPreferencesService prefs;
        if (Boolean.parseBoolean(System.getProperty("pde.usePoolsInfo", "true"))) {
            try {
                additionalRepos.addAll(RepositoryHelper.getWorkspaceBundlePools().stream().map(Path::toUri).toList());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((prefs = P2TargetUtils.getPreferences()) == null) {
            return;
        }
        String recent = prefs.getString("org.eclipse.ui.ide", "RECENT_WORKSPACES", null, null);
        if (recent == null) {
            return;
        }
        String[] stringArray = recents = recent.split("\n");
        int n = recents.length;
        int n2 = 0;
        while (n2 < n) {
            String recentWorkspace = stringArray[n2];
            File bundlePool = new File(recentWorkspace + "/.metadata/.plugins/org.eclipse.pde.core/.bundle_pool");
            if (bundlePool.exists()) {
                additionalRepos.add(bundlePool.toURI().normalize());
            }
            ++n2;
        }
    }

    private void findProfileRepos(Set<URI> additionalRepos) {
        try {
            IProfileRegistry profileRegistry = (IProfileRegistry)P2TargetUtils.getGlobalAgent().getService(IProfileRegistry.class);
            if (profileRegistry == null) {
                return;
            }
            IProfile self = profileRegistry.getProfile("_SELF_");
            if (self == null) {
                return;
            }
            IAgentLocation location = (IAgentLocation)P2TargetUtils.getGlobalAgent().getService(IAgentLocation.class);
            URI dataArea = location.getDataArea("org.eclipse.equinox.p2.engine");
            dataArea = URIUtil.append((URI)dataArea, (String)("profileRegistry/" + self.getProfileId() + ".profile"));
            Collection repos = new ProfileMetadataRepository(P2TargetUtils.getGlobalAgent(), dataArea, null).getReferences();
            for (IRepositoryReference reference : repos) {
                if (reference == null || reference.getType() != 1 || reference.getLocation() == null) continue;
                additionalRepos.add(reference.getLocation());
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private Map<IInstallableUnit, String> getRootIUs(ITargetDefinition definition, IProgressMonitor monitor) throws CoreException {
        ITargetLocation[] containers = definition.getTargetLocations();
        if (containers == null) {
            return Map.of();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.IUBundleContainer_0, (int)containers.length);
        MultiStatus status = new MultiStatus("org.eclipse.pde.core", 0, Messages.IUBundleContainer_ProblemsLoadingRepositories);
        HashMap<IInstallableUnit, String> result = new HashMap<IInstallableUnit, String>();
        ITargetLocation[] iTargetLocationArray = containers;
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            ITargetLocation container = iTargetLocationArray[n2];
            if (container instanceof IUBundleContainer) {
                IUBundleContainer iuContainer = (IUBundleContainer)container;
                try {
                    iuContainer.getRootIUs((IProgressMonitor)subMonitor.split(1)).forEach((iu, versionDeclarations) -> this.addDeclaredVersions((Map<IInstallableUnit, String>)result, (IInstallableUnit)iu, (Set<VersionRange>)versionDeclarations));
                }
                catch (CoreException e) {
                    status.add(e.getStatus());
                }
            }
            ++n2;
        }
        if (!status.isOK()) {
            throw new CoreException((IStatus)status);
        }
        return result;
    }

    private void addDeclaredVersions(Map<IInstallableUnit, String> result, IInstallableUnit iu, Set<VersionRange> versionDeclarations) {
        String joindVersions = versionDeclarations.stream().map(VersionRange::toString).collect(Collectors.joining(VERSION_DECLARATION_SEPARATOR));
        result.merge(iu, joindVersions, (v1, v2) -> v1 + VERSION_DECLARATION_SEPARATOR + v2);
    }

    private Stream<VersionRange> parseVersions(IInstallableUnit unit, String versionList) {
        return versionList == null ? Stream.of(new VersionRange(unit.getVersion(), true, unit.getVersion(), true)) : Arrays.stream(versionList.split(VERSION_DECLARATION_SEPARATOR)).map(VersionRange::create);
    }

    private Collection<URI> getMetadataRepositories(ITargetDefinition target) throws CoreException {
        HashSet<URI> result = new HashSet<URI>();
        ITargetLocation[] containers = target.getTargetLocations();
        if (containers == null) {
            containers = new ITargetLocation[]{};
        }
        IMetadataRepositoryManager manager = P2TargetUtils.getRepoManager();
        ITargetLocation[] iTargetLocationArray = containers;
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            ITargetLocation container = iTargetLocationArray[n2];
            if (container instanceof IUBundleContainer) {
                IUBundleContainer iuContainer = (IUBundleContainer)container;
                List<URI> repos = iuContainer.getRepositories();
                if (repos.isEmpty()) {
                    repos = Arrays.asList(manager.getKnownRepositories(0));
                }
                result.addAll(repos);
            }
            if (container instanceof TargetReferenceBundleContainer) {
                TargetReferenceBundleContainer targetRefContainer = (TargetReferenceBundleContainer)container;
                ITargetDefinition referencedTargetDefinition = targetRefContainer.getTargetDefinition();
                result.addAll(this.getMetadataRepositories(referencedTargetDefinition));
            }
            ++n2;
        }
        return result;
    }

    private void addAdditionalProvisionIUs(ITargetDefinition target, Collection<IArtifactRepository> extraArtifactRepositories, Collection<IMetadataRepository> extraMetadataRepositories) throws CoreException {
        ITargetLocation[] containers = target.getTargetLocations();
        if (containers != null) {
            ITargetLocation[] iTargetLocationArray = containers;
            int n = containers.length;
            int n2 = 0;
            while (n2 < n) {
                ITargetLocation container = iTargetLocationArray[n2];
                if (!(container instanceof IUBundleContainer)) {
                    if (container instanceof TargetReferenceBundleContainer) {
                        TargetReferenceBundleContainer targetRefContainer = (TargetReferenceBundleContainer)container;
                        ITargetDefinition referencedTargetDefinition = targetRefContainer.getTargetDefinition();
                        this.addAdditionalProvisionIUs(referencedTargetDefinition, extraArtifactRepositories, extraMetadataRepositories);
                    } else {
                        if (!container.isResolved()) {
                            container.resolve(target, (IProgressMonitor)new NullProgressMonitor());
                        }
                        extraArtifactRepositories.add((IArtifactRepository)new VirtualArtifactRepository(P2TargetUtils.getAgent(), container));
                        List<IInstallableUnit> installableUnits = InstallableUnitGenerator.generateInstallableUnits(container.getBundles(), container.getFeatures()).toList();
                        extraMetadataRepositories.add((IMetadataRepository)new VirtualMetadataRepository(P2TargetUtils.getAgent(), installableUnits));
                    }
                }
                ++n2;
            }
        }
    }

    synchronized IProfile getProfile() {
        return this.fProfile;
    }

    protected static class CollectNativesAction
    extends ProvisioningAction {
        protected CollectNativesAction() {
        }

        public IStatus execute(Map<String, Object> parameters) {
            IInstallableUnit installableUnit = ((InstallableUnitOperand)parameters.get(P2TargetUtils.PARM_OPERAND)).second();
            if (installableUnit == null) {
                return Status.OK_STATUS;
            }
            try {
                Collection toDownload = installableUnit.getArtifacts();
                if (toDownload == null) {
                    return Status.OK_STATUS;
                }
                List artifactRequests = (List)parameters.get(P2TargetUtils.NATIVE_ARTIFACTS);
                IFileArtifactRepository destinationArtifactRepository = P2TargetUtils.getBundlePool();
                IArtifactRepositoryManager manager = P2TargetUtils.getArtifactRepositoryManager();
                for (IArtifactKey keyToDownload : toDownload) {
                    IArtifactRequest request = manager.createMirrorRequest(keyToDownload, (IArtifactRepository)destinationArtifactRepository, null, null);
                    artifactRequests.add(request);
                }
            }
            catch (CoreException e) {
                return e.getStatus();
            }
            return Status.OK_STATUS;
        }

        public IStatus undo(Map<String, Object> parameters) {
            return Status.OK_STATUS;
        }
    }

    protected static class CollectNativesPhase
    extends InstallableUnitPhase {
        public CollectNativesPhase(int weight) {
            super(P2TargetUtils.NATIVE_ARTIFACTS, weight);
        }

        protected List<ProvisioningAction> getActions(InstallableUnitOperand operand) {
            IInstallableUnit unit = operand.second();
            if (unit != null && unit.getTouchpointType().getId().equals(P2TargetUtils.NATIVE_TYPE)) {
                return List.of(new CollectNativesAction());
            }
            return null;
        }

        protected IStatus initializePhase(IProgressMonitor monitor, IProfile profile, Map<String, Object> parameters) {
            parameters.put(P2TargetUtils.NATIVE_ARTIFACTS, new ArrayList());
            parameters.put("profile", profile);
            return null;
        }

        protected IStatus completePhase(IProgressMonitor monitor, IProfile profile, Map<String, Object> parameters) {
            List artifactRequests = (List)parameters.get(P2TargetUtils.NATIVE_ARTIFACTS);
            ProvisioningContext context = (ProvisioningContext)parameters.get("context");
            IProvisioningAgent agent = (IProvisioningAgent)parameters.get("agent");
            DownloadManager dm = new DownloadManager(context, agent);
            for (IArtifactRequest iArtifactRequest : artifactRequests) {
                dm.add(iArtifactRequest);
            }
            return dm.start(monitor);
        }
    }
}

