/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.orm;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.core.context.DiscriminatorType;
import org.eclipse.jpt.jpa.core.context.NamedDiscriminatorColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedNamedDiscriminatorColumn;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmNamedColumn;
import org.eclipse.jpt.jpa.core.resource.orm.XmlBaseDiscriminatorColumn;

public abstract class AbstractOrmNamedDiscriminatorColumn<PA extends NamedDiscriminatorColumn.ParentAdapter, X extends XmlBaseDiscriminatorColumn>
extends AbstractOrmNamedColumn<PA, X>
implements SpecifiedNamedDiscriminatorColumn {
    protected DiscriminatorType specifiedDiscriminatorType = this.buildSpecifiedDiscriminatorType();
    protected DiscriminatorType defaultDiscriminatorType;
    protected Integer specifiedLength = this.buildSpecifiedLength();
    protected int defaultLength = 31;

    protected AbstractOrmNamedDiscriminatorColumn(PA parentAdapter) {
        this(parentAdapter, null);
    }

    protected AbstractOrmNamedDiscriminatorColumn(PA parentAdapter, X xmlColumn) {
        super(parentAdapter, xmlColumn);
    }

    @Override
    public void synchronizeWithResourceModel(IProgressMonitor monitor) {
        super.synchronizeWithResourceModel(monitor);
        this.setSpecifiedDiscriminatorType_(this.buildSpecifiedDiscriminatorType());
        this.setSpecifiedLength_(this.buildSpecifiedLength());
    }

    @Override
    public void update(IProgressMonitor monitor) {
        super.update(monitor);
        this.setDefaultDiscriminatorType(this.buildDefaultDiscriminatorType());
        this.setDefaultLength(this.buildDefaultLength());
    }

    @Override
    public DiscriminatorType getDiscriminatorType() {
        return this.specifiedDiscriminatorType != null ? this.specifiedDiscriminatorType : this.defaultDiscriminatorType;
    }

    @Override
    public DiscriminatorType getSpecifiedDiscriminatorType() {
        return this.specifiedDiscriminatorType;
    }

    @Override
    public void setSpecifiedDiscriminatorType(DiscriminatorType discriminatorType) {
        if (ObjectTools.notEquals((Object)((Object)this.specifiedDiscriminatorType), (Object)((Object)discriminatorType))) {
            XmlBaseDiscriminatorColumn xmlColumn = (XmlBaseDiscriminatorColumn)this.getXmlColumnForUpdate();
            this.setSpecifiedDiscriminatorType_(discriminatorType);
            xmlColumn.setDiscriminatorType(DiscriminatorType.toOrmResourceModel(discriminatorType));
            this.removeXmlColumnIfUnset();
        }
    }

    protected void setSpecifiedDiscriminatorType_(DiscriminatorType discriminatorType) {
        DiscriminatorType old = this.specifiedDiscriminatorType;
        this.specifiedDiscriminatorType = discriminatorType;
        this.firePropertyChanged("specifiedDiscriminatorType", (Object)old, (Object)discriminatorType);
    }

    protected DiscriminatorType buildSpecifiedDiscriminatorType() {
        XmlBaseDiscriminatorColumn xmlColumn = (XmlBaseDiscriminatorColumn)this.getXmlColumn();
        return xmlColumn == null ? null : DiscriminatorType.fromOrmResourceModel(xmlColumn.getDiscriminatorType());
    }

    @Override
    public DiscriminatorType getDefaultDiscriminatorType() {
        return this.defaultDiscriminatorType;
    }

    protected void setDefaultDiscriminatorType(DiscriminatorType discriminatorType) {
        DiscriminatorType old = this.defaultDiscriminatorType;
        this.defaultDiscriminatorType = discriminatorType;
        this.firePropertyChanged("defaultDiscriminatorType", (Object)old, (Object)discriminatorType);
    }

    protected DiscriminatorType buildDefaultDiscriminatorType() {
        return ((NamedDiscriminatorColumn.ParentAdapter)this.parentAdapter).getDefaultDiscriminatorType();
    }

    @Override
    public int getLength() {
        return this.specifiedLength != null ? this.specifiedLength : this.defaultLength;
    }

    @Override
    public Integer getSpecifiedLength() {
        return this.specifiedLength;
    }

    @Override
    public void setSpecifiedLength(Integer length) {
        if (ObjectTools.notEquals((Object)this.specifiedLength, (Object)length)) {
            XmlBaseDiscriminatorColumn xmlColumn = (XmlBaseDiscriminatorColumn)this.getXmlColumnForUpdate();
            this.setSpecifiedLength_(length);
            xmlColumn.setLength(length);
            this.removeXmlColumnIfUnset();
        }
    }

    protected void setSpecifiedLength_(Integer length) {
        Integer old = this.specifiedLength;
        this.specifiedLength = length;
        this.firePropertyChanged("specifiedLength", old, length);
    }

    protected Integer buildSpecifiedLength() {
        XmlBaseDiscriminatorColumn xmlColumn = (XmlBaseDiscriminatorColumn)this.getXmlColumn();
        return xmlColumn == null ? null : xmlColumn.getLength();
    }

    @Override
    public int getDefaultLength() {
        return this.defaultLength;
    }

    protected void setDefaultLength(int defaultLength) {
        int old = this.defaultLength;
        this.defaultLength = defaultLength;
        this.firePropertyChanged("defaultLength", old, defaultLength);
    }

    protected int buildDefaultLength() {
        return ((NamedDiscriminatorColumn.ParentAdapter)this.parentAdapter).getDefaultLength();
    }
}

