/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.annotations;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.annotations.CustomHeaderAnnotationProcessor;
import org.eclipse.pde.internal.core.annotations.ExportPackageAnnotationProcessor;
import org.eclipse.pde.internal.core.annotations.OSGiAnnotationProcessor;
import org.eclipse.pde.internal.core.natures.PluginProject;
import org.eclipse.pde.internal.ui.util.ModelModification;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;

public class OSGiAnnotationsASTVisitor
extends ASTVisitor {
    private final CompilationUnit unit;

    public OSGiAnnotationsASTVisitor(CompilationUnit compilationUnit) {
        this.unit = compilationUnit;
    }

    public boolean visit(PackageDeclaration packageDeclaration) {
        ITypeRoot typeRoot = this.unit.getTypeRoot();
        if (typeRoot == null || !"package-info.java".equals(typeRoot.getElementName())) {
            return true;
        }
        IJavaProject javaProject = typeRoot.getJavaProject();
        if (javaProject == null) {
            return true;
        }
        IProject project = javaProject.getProject();
        if (!PluginProject.isPluginProject((IProject)project) || WorkspaceModelManager.isBinaryProject((IProject)project)) {
            return true;
        }
        final List<OSGiAnnotationProcessor> processors = OSGiAnnotationsASTVisitor.getPackageProcessors(packageDeclaration.getName().toString());
        for (Object item : packageDeclaration.annotations()) {
            Annotation annotation;
            IAnnotationBinding annotationBinding;
            if (!(item instanceof Annotation) || (annotationBinding = (annotation = (Annotation)item).resolveAnnotationBinding()) == null) continue;
            String name = annotationBinding.getAnnotationType().getQualifiedName();
            for (OSGiAnnotationProcessor processor : processors) {
                processor.processAnnotation(annotation, name);
            }
        }
        PDEModelUtility.modifyModel(new ModelModification(project){

            @Override
            protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                if (model instanceof IModel && OSGiAnnotationsASTVisitor.isDerived(((IModel)model).getUnderlyingResource())) {
                    return;
                }
                for (OSGiAnnotationProcessor processor : processors) {
                    processor.apply(model);
                }
            }
        }, null);
        return true;
    }

    private static boolean isDerived(IResource resource) {
        if (resource != null) {
            if (resource.isDerived()) {
                return true;
            }
            return OSGiAnnotationsASTVisitor.isDerived((IResource)resource.getParent());
        }
        return false;
    }

    private static List<OSGiAnnotationProcessor> getPackageProcessors(String packageName) {
        return List.of(new ExportPackageAnnotationProcessor(packageName), new CustomHeaderAnnotationProcessor());
    }
}

