/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.launcher;

import java.util.ArrayList;
import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.ILaunchShortcut2;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp.PathEditorInput;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.launcher.Messages;
import org.eclipse.linuxtools.profiling.launch.ProfileLaunchShortcut;
import org.eclipse.linuxtools.systemtap.graphing.ui.widgets.ExceptionErrorDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ide.ResourceUtil;

public class SystemTapScriptLaunchShortcut
extends ProfileLaunchShortcut
implements ILaunchShortcut2 {
    public void launch(IEditorPart editor, String mode) {
        String path;
        String project = null;
        if (editor.getEditorInput() instanceof PathEditorInput) {
            path = ((PathEditorInput)editor.getEditorInput()).getPath().toString();
        } else {
            IFile file = ResourceUtil.getFile((IEditorInput)editor.getEditorInput());
            path = file.getLocation().toString();
            project = file.getProject().getName();
        }
        this.searchAndLaunch(path, project);
    }

    public void launch(ISelection selection, String mode) {
        IFile file = (IFile)((TreeSelection)selection).getFirstElement();
        String path = file.getLocation().toOSString();
        String project = file.getProject().getName();
        this.searchAndLaunch(path, project);
    }

    private void searchAndLaunch(String path, String project) {
        ILaunchConfiguration configuration = this.findLaunchConfiguration(path, project);
        if (configuration == null) {
            return;
        }
        try {
            configuration.launch("run", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            ExceptionErrorDialog.openError((String)Messages.SystemTapScriptLaunchShortcut_couldNotLaunchScript, (Exception)((Object)e));
        }
    }

    private ILaunchConfiguration findLaunchConfiguration(String scriptPath, String scriptProject) {
        ILaunchConfiguration configuration = null;
        ArrayList<ILaunchConfiguration> candidateConfigurations = new ArrayList<ILaunchConfiguration>();
        try {
            ILaunchConfiguration[] configs;
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            for (ILaunchConfiguration config : configs = launchManager.getLaunchConfigurations(this.getLaunchConfigType())) {
                if (!config.getAttribute("ScriptPath", "").equals(scriptPath)) continue;
                candidateConfigurations.add(config);
            }
            int candidateCount = candidateConfigurations.size();
            if (candidateCount == 0) {
                int conflict_index;
                LinkedList<String> configNames = new LinkedList<String>();
                for (ILaunchConfiguration config : configs = launchManager.getLaunchConfigurations()) {
                    configNames.add(config.getName());
                }
                String configName = (String)(scriptProject == null ? "" : scriptProject + " ") + Path.fromOSString((String)scriptPath).lastSegment();
                Object wcName = configName;
                int conflict_count = 0;
                while ((conflict_index = configNames.indexOf(wcName)) != -1) {
                    wcName = configName.concat(String.format(" (%d)", ++conflict_count));
                    configNames.remove(conflict_index);
                }
                ILaunchConfigurationType type = this.getLaunchConfigType();
                ILaunchConfigurationWorkingCopy wc = type.newInstance(null, (String)wcName);
                wc.setAttribute("ScriptPath", scriptPath);
                configuration = wc.doSave();
            } else {
                configuration = candidateCount == 1 ? (ILaunchConfiguration)candidateConfigurations.get(0) : this.chooseConfiguration(candidateConfigurations, "run");
            }
        }
        catch (CoreException e) {
            ExceptionErrorDialog.openError((String)Messages.SystemTapScriptLaunchShortcut_couldNotFindConfig, (Exception)((Object)e));
        }
        return configuration;
    }

    protected ILaunchConfigurationType getLaunchConfigType() {
        return this.getLaunchManager().getLaunchConfigurationType("org.eclipse.linuxtools.systemtap.ui.ide.SystemTapLaunchConfigurationType");
    }

    protected void setDefaultProfileAttributes(ILaunchConfigurationWorkingCopy wc) {
    }

    public ILaunchConfiguration[] getLaunchConfigurations(ISelection selection) {
        return null;
    }

    public ILaunchConfiguration[] getLaunchConfigurations(IEditorPart editorpart) {
        return null;
    }

    public IResource getLaunchableResource(ISelection selection) {
        return null;
    }

    public IResource getLaunchableResource(IEditorPart editorpart) {
        return null;
    }
}

