/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.propertytesters;

import java.util.List;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.docker.core.IDockerImageHierarchyImageNode;

public class ImagePropertyTester
extends PropertyTester {
    public static final String CAN_BE_TAGGED = "canBeTagged";
    public static final String HAS_MULTIPLE_TAGS = "hasMultipleTags";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof IDockerImage) {
            IDockerImage image = (IDockerImage)receiver;
            switch (property) {
                case "canBeTagged": {
                    return !image.isDangling() && !image.isIntermediateImage();
                }
                case "hasMultipleTags": {
                    List repoTags = image.repoTags();
                    return repoTags != null && repoTags.size() > 1;
                }
            }
        } else if (receiver instanceof IDockerImageHierarchyImageNode) {
            IDockerImage image = ((IDockerImageHierarchyImageNode)receiver).getElement();
            return this.test(image, property, args, expectedValue);
        }
        return false;
    }
}

