/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.wizards.settingswizards;

import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.core.resources.ResourcesUtil;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICFolderDescription;
import org.eclipse.cdt.internal.core.XmlProcessorFactoryCdt;
import org.eclipse.cdt.internal.ui.wizards.settingswizards.IProjectSettingsWizardPage;
import org.eclipse.cdt.internal.ui.wizards.settingswizards.IProjectSettingsWizardPageStrategy;
import org.eclipse.cdt.internal.ui.wizards.settingswizards.ISettingsProcessor;
import org.eclipse.cdt.internal.ui.wizards.settingswizards.Messages;
import org.eclipse.cdt.internal.ui.wizards.settingswizards.SettingsImportExportException;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.Path;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ProjectSettingsExportStrategy
implements IProjectSettingsWizardPageStrategy {
    public static final String ROOT_ELEMENT = "cdtprojectproperties";
    public static final String SECTION_ELEMENT = "section";
    public static final String SECTION_NAME_ATTRIBUTE = "name";
    private static final String NONE = "";
    private static final String CDATA = "CDATA";

    @Override
    public String getMessage(IProjectSettingsWizardPageStrategy.MessageType type) {
        switch (type) {
            case TITLE: {
                return Messages.ProjectSettingsWizardPage_Export_title;
            }
            case MESSAGE: {
                return Messages.ProjectSettingsWizardPage_Export_message;
            }
            case CHECKBOX: {
                return Messages.ProjectSettingsWizardPage_Export_checkBox;
            }
            case FILE: {
                return Messages.ProjectSettingsWizardPage_Export_file;
            }
            case SETTINGS: {
                return Messages.ProjectSettingsWizardPage_Export_selectSettings;
            }
        }
        return null;
    }

    @Override
    public void pageCreated(IProjectSettingsWizardPage page) {
    }

    @Override
    public void fileSelected(IProjectSettingsWizardPage page) {
    }

    private FileOutputStream getFileOutputStream(IProjectSettingsWizardPage page) throws IOException {
        Path path = new Path(page.getDestinationFilePath());
        if (!"xml".equals(path.getFileExtension())) {
            path.addFileExtension("xml");
        }
        return new FileOutputStream(path.toFile());
    }

    @Override
    public boolean finish(IProjectSettingsWizardPage page) {
        FileOutputStream outputStream;
        SAXTransformerFactory factory = (SAXTransformerFactory)XmlProcessorFactoryCdt.createTransformerFactoryWithErrorOnDOCTYPE();
        TransformerHandler handler = null;
        try {
            handler = factory.newTransformerHandler();
        }
        catch (TransformerConfigurationException e) {
            CUIPlugin.log(e);
            page.showErrorDialog(Messages.ProjectSettingsExportStrategy_exportError, Messages.ProjectSettingsExportStrategy_exportFailed);
            return false;
        }
        try {
            outputStream = this.getFileOutputStream(page);
        }
        catch (IOException e) {
            page.showErrorDialog(Messages.ProjectSettingsExportStrategy_fileOpenError, Messages.ProjectSettingsExportStrategy_couldNotOpen);
            return false;
        }
        Transformer transformer = handler.getTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.setOutputProperty("doctype-public", "yes");
        handler.setResult(new StreamResult(outputStream));
        List<ISettingsProcessor> exporters = page.getSelectedSettingsProcessors();
        ICConfigurationDescription config = page.getSelectedConfiguration();
        ICFolderDescription projectRoot = config.getRootFolderDescription();
        boolean result = false;
        try {
            AttributesImpl attributes = new AttributesImpl();
            handler.startDocument();
            handler.startElement(NONE, NONE, ROOT_ELEMENT, null);
            for (ISettingsProcessor exporter : exporters) {
                attributes.clear();
                attributes.addAttribute(NONE, NONE, SECTION_NAME_ATTRIBUTE, CDATA, exporter.getSectionName());
                handler.startElement(NONE, NONE, SECTION_ELEMENT, attributes);
                exporter.writeSectionXML(projectRoot, handler);
                handler.endElement(NONE, NONE, SECTION_ELEMENT);
            }
            handler.endElement(NONE, NONE, ROOT_ELEMENT);
            handler.endDocument();
            result = true;
        }
        catch (SAXException e) {
            CUIPlugin.log(e);
            page.showErrorDialog(Messages.ProjectSettingsExportStrategy_exportError, Messages.ProjectSettingsExportStrategy_xmlError);
            result = false;
        }
        catch (SettingsImportExportException e) {
            CUIPlugin.log(e);
            page.showErrorDialog(Messages.ProjectSettingsExportStrategy_fileOpenError, Messages.ProjectSettingsExportStrategy_couldNotOpen);
            result = false;
        }
        URI uri = URIUtil.toURI((String)page.getDestinationFilePath());
        ResourcesUtil.refreshWorkspaceFiles((URI)uri);
        return result;
    }
}

