/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.cdt.doxygen.DoxygenMetadata;
import org.eclipse.cdt.internal.ui.dialogs.Messages;
import org.eclipse.cdt.internal.ui.text.doctools.DocCommentOwnerManager;
import org.eclipse.cdt.internal.ui.text.doctools.NullDocCommentOwner;
import org.eclipse.cdt.ui.text.doctools.IDocCommentOwner;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.runtime.preferences.IPreferenceMetadataStore;
import org.eclipse.core.runtime.preferences.PreferenceMetadata;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;

public class DocCommentOwnerArea {
    private final Label desc;
    private final Label comboLabel;
    private final Group group;
    private final Combo combo;
    private final IDocCommentOwner[] owners = this.getNontestOwners();
    private final Map<PreferenceMetadata<Boolean>, Button> buttons = new LinkedHashMap<PreferenceMetadata<Boolean>, Button>();

    public DocCommentOwnerArea(Composite pane, DoxygenMetadata metadata, String descriptionText, String comboLabelText) {
        this.group = ControlFactory.createGroup(pane, Messages.DocCommentOwnerArea_group_doctool, 2);
        this.group.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.desc = new Label((Composite)this.group, 64);
        this.desc.setText(descriptionText);
        this.desc.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, false).span(2, 1).hint(150, -1).create());
        this.comboLabel = new Label((Composite)this.group, 0);
        this.comboLabel.setText(comboLabelText);
        this.combo = this.createCombo((Composite)this.group);
        this.combo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.recheckButtons()));
        metadata.booleanOptions().forEach(o -> {
            Button button = this.createCheckBox((Composite)this.group, (PreferenceMetadata<Boolean>)o);
        });
    }

    private Combo createCombo(Composite parent) {
        String[] items = new String[this.owners.length + 1];
        items[0] = Messages.DocCommentOwnerArea_doctool_none;
        int i = 0;
        while (i < this.owners.length) {
            items[i + 1] = this.owners[i].getName();
            ++i;
        }
        Combo created = ControlFactory.createSelectCombo(parent, items, Messages.DocCommentOwnerArea_doctool_none);
        return created;
    }

    private Button createCheckBox(Composite parent, PreferenceMetadata<Boolean> option) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(option.name());
        checkBox.setToolTipText(option.description());
        GridData gd = new GridData(768);
        gd.horizontalIndent = 0;
        gd.horizontalSpan = 2;
        checkBox.setLayoutData((Object)gd);
        this.buttons.put(option, checkBox);
        return checkBox;
    }

    private IDocCommentOwner[] getNontestOwners() {
        ArrayList<IDocCommentOwner> result = new ArrayList<IDocCommentOwner>();
        IDocCommentOwner[] iDocCommentOwnerArray = DocCommentOwnerManager.getInstance().getRegisteredOwners();
        int n = iDocCommentOwnerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDocCommentOwner owner = iDocCommentOwnerArray[n2];
            if (owner.getID().indexOf(".test.") == -1) {
                result.add(owner);
            }
            ++n2;
        }
        return result.toArray(new IDocCommentOwner[result.size()]);
    }

    public void initialize(IDocCommentOwner initial, IPreferenceMetadataStore storage) {
        this.selectDocumentOwner(initial, this.combo);
        this.buttons.entrySet().stream().forEach(e -> ((Button)e.getValue()).setSelection(((Boolean)storage.load((PreferenceMetadata)e.getKey())).booleanValue()));
    }

    private void selectDocumentOwner(IDocCommentOwner owner, Combo created) {
        int i = 0;
        while (i < this.owners.length) {
            if (this.owners[i].getID().equals(owner.getID())) {
                created.select(i + 1);
                return;
            }
            ++i;
        }
        created.select(0);
        this.recheckButtons();
    }

    public void setEnabled(boolean enabled) {
        this.desc.setEnabled(enabled);
        this.comboLabel.setEnabled(enabled);
        this.combo.setEnabled(enabled);
        this.group.setEnabled(enabled);
        this.recheckButtons();
    }

    void recheckButtons() {
        boolean doxygenEnabled = this.combo.isEnabled() && "org.eclipse.cdt.ui.doxygen".equals(this.getSelectedDocCommentOwner().getID());
        this.buttons.values().forEach(b -> b.setEnabled(doxygenEnabled));
    }

    public IDocCommentOwner getSelectedDocCommentOwner() {
        int index = this.combo.getSelectionIndex();
        return index == 0 ? NullDocCommentOwner.INSTANCE : this.owners[index - 1];
    }

    public void apply(IPreferenceMetadataStore storage) {
        this.buttons.entrySet().stream().forEach(e -> storage.save((Object)((Button)e.getValue()).getSelection(), (PreferenceMetadata)e.getKey()));
    }
}

