/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.output;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConsoleStreamOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOOBRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.core.runtime.ILog;

public class CLIAddressSizeInfo
extends MIInfo {
    private static final Pattern HEX_LITERAL_PATTERN = Pattern.compile("0x[0-9a-fA-F]+");
    private int fAddressSize = 0;

    public CLIAddressSizeInfo(MIOutput record) {
        super(record);
        this.parse();
    }

    protected void parse() {
        if (this.isDone()) {
            MIOutput out = this.getMIOutput();
            MIOOBRecord[] mIOOBRecordArray = out.getMIOOBRecords();
            int n = mIOOBRecordArray.length;
            int n2 = 0;
            while (n2 < n) {
                MIOOBRecord oob = mIOOBRecordArray[n2];
                if (oob instanceof MIConsoleStreamOutput) {
                    String line = ((MIConsoleStreamOutput)oob).getString().trim();
                    this.fAddressSize = this.hexToValue(line);
                }
                ++n2;
            }
        }
    }

    public int getAddressSize() {
        return this.fAddressSize;
    }

    private int hexToValue(String hexString) {
        Matcher matcher = HEX_LITERAL_PATTERN.matcher(hexString);
        if (matcher.find()) {
            return Integer.decode(matcher.group());
        }
        ILog.get().error("CLIAddressSizeInfo response not handled: " + hexString);
        return 0;
    }
}

