/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.ui.internal;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationPresentationManager;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTab2;
import org.eclipse.debug.ui.ILaunchConfigurationTabGroup;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.launchbar.core.DefaultLaunchDescriptorType;
import org.eclipse.launchbar.core.ILaunchDescriptor;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.ui.ILaunchBarLaunchConfigDialog;
import org.eclipse.launchbar.ui.ILaunchBarUIManager;
import org.eclipse.launchbar.ui.internal.Activator;
import org.eclipse.launchbar.ui.internal.Messages;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class LaunchBarLaunchConfigDialog
extends TitleAreaDialog
implements ILaunchBarLaunchConfigDialog {
    private final ILaunchConfigurationWorkingCopy workingCopy;
    private final ILaunchDescriptor descriptor;
    private final ILaunchMode mode;
    private final ILaunchTarget target;
    private final ILaunchConfigurationTabGroup buildTabGroup;
    private final String originalName;
    private ILaunchConfigurationTabGroup group;
    private Text nameText;
    private CTabFolder tabFolder;
    private CTabItem lastSelection;
    private ProgressMonitorPart pmPart;
    private boolean initing;
    public static final int ID_DUPLICATE = 1025;
    public static final int ID_DELETE = 1026;

    public LaunchBarLaunchConfigDialog(Shell shell, ILaunchConfigurationWorkingCopy workingCopy, ILaunchDescriptor descriptor, ILaunchMode mode, ILaunchTarget target, ILaunchConfigurationTabGroup buildTabGroup) {
        super(shell);
        this.workingCopy = workingCopy;
        this.descriptor = descriptor;
        this.mode = mode;
        this.target = target;
        this.buildTabGroup = buildTabGroup;
        this.originalName = workingCopy.getName();
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected int getDialogBoundsStrategy() {
        return 1;
    }

    protected Control createDialogArea(Composite parent) {
        this.initing = true;
        this.getShell().setText(Messages.LaunchBarLaunchConfigDialog_EditConfiguration);
        boolean supportsTargets = true;
        try {
            supportsTargets = this.descriptor.getType().supportsTargets();
        }
        catch (CoreException e2) {
            Activator.log((Exception)((Object)e2));
        }
        try {
            ILaunchBarUIManager uiManager = Activator.getService(ILaunchBarUIManager.class);
            ILabelProvider labelProvider = uiManager.getLabelProvider(this.descriptor);
            String descName = labelProvider != null ? labelProvider.getText((Object)this.descriptor) : this.descriptor.getName();
            String typeName = this.workingCopy.getType().getName();
            if (supportsTargets) {
                this.setTitle(String.format(Messages.LaunchBarLaunchConfigDialog_Edit2, typeName, descName, this.mode.getLabel(), this.target.getId()));
            } else {
                this.setTitle(String.format(Messages.LaunchBarLaunchConfigDialog_Edit1, typeName, descName, this.mode.getLabel()));
            }
        }
        catch (CoreException e3) {
            Activator.log((Exception)((Object)e3));
        }
        this.setMessage(Messages.LaunchBarLaunchConfigDialog_SetParameters);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        Composite nameComp = new Composite(composite, 0);
        nameComp.setLayoutData((Object)new GridData(4, 4, true, false));
        nameComp.setLayout((Layout)new GridLayout(2, false));
        Label nameLabel = new Label(nameComp, 0);
        nameLabel.setText(Messages.LaunchBarLaunchConfigDialog_LaunchConfigName);
        this.nameText = new Text(nameComp, 2048);
        this.nameText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.nameText.setText(this.workingCopy.getName());
        this.nameText.addModifyListener(e -> this.updateMessage());
        this.tabFolder = new CTabFolder(composite, 2048);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tabFolder.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                CTabItem selItem = LaunchBarLaunchConfigDialog.this.tabFolder.getSelection();
                if (selItem != null) {
                    selItem.getControl().setFocus();
                }
            }
        });
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ILaunchConfigurationTab oldTab = (ILaunchConfigurationTab)LaunchBarLaunchConfigDialog.this.lastSelection.getData();
                oldTab.deactivated(LaunchBarLaunchConfigDialog.this.workingCopy);
                CTabItem selItem = LaunchBarLaunchConfigDialog.this.tabFolder.getSelection();
                ILaunchConfigurationTab newTab = (ILaunchConfigurationTab)selItem.getData();
                newTab.activated(LaunchBarLaunchConfigDialog.this.workingCopy);
                selItem.getControl().setFocus();
                LaunchBarLaunchConfigDialog.this.updateMessage();
            }
        });
        try {
            ILaunchConfigurationTab configTab;
            int n;
            int n2;
            ILaunchConfigurationTab[] iLaunchConfigurationTabArray;
            if (this.buildTabGroup != null) {
                this.buildTabGroup.createTabs((ILaunchConfigurationDialog)this, this.mode.getIdentifier());
                iLaunchConfigurationTabArray = this.buildTabGroup.getTabs();
                n2 = iLaunchConfigurationTabArray.length;
                n = 0;
                while (n < n2) {
                    configTab = iLaunchConfigurationTabArray[n];
                    this.installTab(configTab, this.tabFolder);
                    ++n;
                }
                this.buildTabGroup.initializeFrom((ILaunchConfiguration)this.workingCopy);
            }
            this.group = LaunchConfigurationPresentationManager.getDefault().getTabGroup((ILaunchConfiguration)this.workingCopy, this.mode.getIdentifier());
            this.group.createTabs((ILaunchConfigurationDialog)this, this.mode.getIdentifier());
            iLaunchConfigurationTabArray = this.group.getTabs();
            n2 = iLaunchConfigurationTabArray.length;
            n = 0;
            while (n < n2) {
                configTab = iLaunchConfigurationTabArray[n];
                CTabItem tabItem = this.installTab(configTab, this.tabFolder);
                if (this.lastSelection == null) {
                    this.tabFolder.setSelection(tabItem);
                    this.lastSelection = tabItem;
                }
                ++n;
            }
            this.group.initializeFrom((ILaunchConfiguration)this.workingCopy);
        }
        catch (CoreException e4) {
            Activator.log(e4.getStatus());
        }
        this.pmPart = new ProgressMonitorPart(composite, (Layout)new GridLayout(), true);
        this.pmPart.setLayoutData((Object)new GridData(4, 4, true, false));
        this.pmPart.setVisible(false);
        this.initing = false;
        return composite;
    }

    private CTabItem installTab(ILaunchConfigurationTab tab, CTabFolder tabFolder) {
        tab.setLaunchConfigurationDialog((ILaunchConfigurationDialog)this);
        CTabItem tabItem = new CTabItem(tabFolder, 0);
        tabItem.setData((Object)tab);
        tabItem.setText(tab.getName());
        tabItem.setImage(tab.getImage());
        ScrolledComposite sc = new ScrolledComposite((Composite)tabItem.getParent(), 768);
        sc.setFont(tabItem.getParent().getFont());
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setShowFocusedControl(true);
        tab.createControl((Composite)sc);
        Control control = tab.getControl();
        if (control != null) {
            sc.setContent(control);
            sc.setMinSize(control.computeSize(-1, -1));
            tabItem.setControl((Control)control.getParent());
        }
        return tabItem;
    }

    protected Control createButtonBar(Composite parent) {
        Composite buttonBar = (Composite)super.createButtonBar(parent);
        Control[] children = buttonBar.getChildren();
        Control okCancelButtons = children[children.length - 1];
        Control configButtons = this.createConfigButtons(buttonBar);
        configButtons.moveAbove(okCancelButtons);
        return buttonBar;
    }

    protected Control createConfigButtons(Composite parent) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(68);
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        try {
            if (DefaultLaunchDescriptorType.isPublic((ILaunchConfiguration)this.workingCopy.getOriginal())) {
                this.createButton(composite, 1025, Messages.LaunchBarLaunchConfigDialog_Duplicate, false);
            }
        }
        catch (CoreException e) {
            Activator.log(e.getStatus());
        }
        String deleteText = this.descriptor.getType().canDelete() ? Messages.LaunchBarLaunchConfigDialog_Delete : Messages.LaunchBarLaunchConfigDialog_Reset;
        this.createButton(composite, 1026, deleteText, false);
        return composite;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            this.duplicatePressed();
        } else if (buttonId == 1026) {
            this.deletePressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void deletePressed() {
        String message;
        String title;
        if (this.descriptor.getType().canDelete()) {
            title = Messages.LaunchBarLaunchConfigDialog_DeleteTitle;
            message = Messages.LaunchBarLaunchConfigDialog_DeleteConfirm;
        } else {
            title = Messages.LaunchBarLaunchConfigDialog_ResetTitle;
            message = Messages.LaunchBarLaunchConfigDialog_ResetConfirm;
        }
        if (MessageDialog.openConfirm((Shell)this.getShell(), (String)title, (String)String.format(message, this.workingCopy.getName()))) {
            this.setReturnCode(1026);
            this.close();
        }
    }

    protected void duplicatePressed() {
        this.setReturnCode(1025);
        this.close();
    }

    protected void okPressed() {
        String newName = this.nameText.getText().trim();
        if (!newName.equals(this.originalName)) {
            this.workingCopy.rename(newName);
        }
        if (this.buildTabGroup != null) {
            this.buildTabGroup.performApply(this.workingCopy);
        }
        this.group.performApply(this.workingCopy);
        super.okPressed();
    }

    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        if (this.getShell() == null || !this.getShell().isVisible()) {
            PlatformUI.getWorkbench().getProgressService().run(fork, cancelable, runnable);
            return;
        }
        Control lastControl = this.getShell().getDisplay().getFocusControl();
        if (lastControl != null && lastControl.getShell() != this.getShell()) {
            lastControl = null;
        }
        this.getButton(0).setEnabled(false);
        this.getButton(1).setEnabled(false);
        this.pmPart.attachToCancelComponent(null);
        try {
            ModalContext.run((IRunnableWithProgress)runnable, (boolean)fork, (IProgressMonitor)this.pmPart, (Display)this.getShell().getDisplay());
        }
        finally {
            this.pmPart.removeFromCancelComponent(null);
            this.getButton(0).setEnabled(true);
            this.getButton(1).setEnabled(true);
            if (lastControl != null) {
                lastControl.setFocus();
            }
            this.updateButtons();
        }
    }

    public void updateButtons() {
        if (!this.initing) {
            int pageIndex;
            ILaunchConfigurationTab[] tabs = this.getTabs();
            if (this.tabFolder != null && tabs != null && (pageIndex = this.tabFolder.getSelectionIndex()) >= 0) {
                tabs[pageIndex].performApply(this.workingCopy);
            }
        }
    }

    private String getTabsErrorMessage() {
        String message;
        ILaunchConfigurationTab activeTab = this.getActiveTab();
        if (activeTab != null && (message = activeTab.getErrorMessage()) != null) {
            return message;
        }
        ILaunchConfigurationTab[] iLaunchConfigurationTabArray = this.getTabs();
        int n = iLaunchConfigurationTabArray.length;
        int n2 = 0;
        while (n2 < n) {
            String message2;
            ILaunchConfigurationTab tab = iLaunchConfigurationTabArray[n2];
            if (tab != activeTab && (message2 = tab.getErrorMessage()) != null) {
                return message2;
            }
            ++n2;
        }
        return null;
    }

    private String getWarningMessage() {
        ILaunchConfigurationTab2 confTab;
        String tabMessage;
        if (this.initing) {
            return null;
        }
        String message = null;
        ILaunchConfigurationTab tab = this.getActiveTab();
        if (tab instanceof ILaunchConfigurationTab2 && (tabMessage = (confTab = (ILaunchConfigurationTab2)tab).getWarningMessage()) != null) {
            message = tabMessage;
        }
        return message;
    }

    private String getTabsMessage() {
        String message;
        ILaunchConfigurationTab activeTab = this.getActiveTab();
        if (activeTab != null && (message = activeTab.getMessage()) != null) {
            return message;
        }
        ILaunchConfigurationTab[] iLaunchConfigurationTabArray = this.getTabs();
        int n = iLaunchConfigurationTabArray.length;
        int n2 = 0;
        while (n2 < n) {
            String message2;
            ILaunchConfigurationTab tab = iLaunchConfigurationTabArray[n2];
            if (tab != activeTab && (message2 = tab.getMessage()) != null) {
                return message2;
            }
            ++n2;
        }
        return null;
    }

    public void updateMessage() {
        if (this.initing) {
            return;
        }
        String newName = this.nameText.getText().trim();
        if (newName.isEmpty()) {
            this.setMessage(Messages.LaunchBarLaunchConfigDialog_LCMustHaveName, 3);
            return;
        }
        if (!newName.equals(this.originalName)) {
            try {
                ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
                if (manager.isExistingLaunchConfigurationName(newName)) {
                    this.setMessage(Messages.LaunchBarLaunchConfigDialog_LCNameExists, 3);
                    return;
                }
                if (!manager.isValidLaunchConfigurationName(newName)) {
                    this.setMessage(Messages.LaunchBarLaunchConfigDialog_LCNameNotValid, 3);
                    return;
                }
            }
            catch (CoreException e1) {
                Activator.log(e1.getStatus());
            }
        }
        ILaunchConfigurationTab[] iLaunchConfigurationTabArray = this.getTabs();
        int n = iLaunchConfigurationTabArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfigurationTab tab = iLaunchConfigurationTabArray[n2];
            tab.isValid((ILaunchConfiguration)this.workingCopy);
            ++n2;
        }
        Button okButton = this.getButton(0);
        String message = this.getTabsErrorMessage();
        if (message != null) {
            this.setMessage(message, 3);
            okButton.setEnabled(false);
            return;
        }
        message = this.getWarningMessage();
        if (message != null) {
            this.setMessage(message, 2);
            return;
        }
        message = this.getTabsMessage();
        this.setMessage(message);
        okButton.setEnabled(true);
    }

    public void setName(String name) {
        if (this.nameText != null && !this.nameText.isDisposed()) {
            this.nameText.setText(name);
        }
    }

    public String generateName(String name) {
        return DebugPlugin.getDefault().getLaunchManager().generateLaunchConfigurationName(name);
    }

    public ILaunchConfigurationTab[] getTabs() {
        if (this.buildTabGroup != null) {
            ILaunchConfigurationTab[] buildTabs = this.buildTabGroup.getTabs();
            ILaunchConfigurationTab[] mainTabs = this.group.getTabs();
            ILaunchConfigurationTab[] tabs = new ILaunchConfigurationTab[buildTabs.length + mainTabs.length];
            System.arraycopy(buildTabs, 0, tabs, 0, buildTabs.length);
            System.arraycopy(mainTabs, 0, tabs, buildTabs.length, mainTabs.length);
            return tabs;
        }
        return this.group.getTabs();
    }

    public ILaunchConfigurationTab getActiveTab() {
        CTabItem selItem = this.tabFolder.getSelection();
        if (selItem != null) {
            return (ILaunchConfigurationTab)selItem.getData();
        }
        return null;
    }

    public String getMode() {
        return this.mode.getIdentifier();
    }

    @Override
    public ILaunchTarget getLaunchTarget() {
        return this.target;
    }

    public void setActiveTab(ILaunchConfigurationTab tab) {
        CTabItem[] cTabItemArray = this.tabFolder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            if (tab.equals(item.getData())) {
                this.tabFolder.setSelection(item);
                return;
            }
            ++n2;
        }
    }

    public void setActiveTab(int index) {
        this.tabFolder.setSelection(index);
    }
}

