/*
 * This file is part of the µOS++ distribution.
 *   (https://github.com/micro-os-plus)
 * Copyright (c) 2017 Liviu Ionescu.
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom
 * the Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

#include <micro-os-plus/device.h>
#include <micro-os-plus/startup/initialize-hooks.h>

#include <cstddef>

// ----------------------------------------------------------------------------

namespace riscv
{
  namespace device
  {
  // ------------------------------------------------------------------------
  // Device functions definitions.

  // TODO: add C++ functions.

  // --------------------------------------------------------------------------
  } /* namespace device */
} /* namespace riscv */

// ----------------------------------------------------------------------------
// C aliases to the C++ functions.

// TODO: add aliases.

// ----------------------------------------------------------------------------

#if !defined(OS_USE_SEMIHOSTING_SYSCALLS)

/**
 * @details
 * This function resets the MCU core.
 */
void
__attribute__ ((noreturn,weak))
os_terminate (int code __attribute__((unused)))
{
#if defined(SIFIVE_FE310)
  // The Watchdog or PMU+RTC can be used to trigger a system reset.
  // TODO: find the best solution.
#elif defined(SIFIVE_E31ARTY) || defined(SIFIVE_E51ARTY)
  // There isn't a way to soft reset the E31/E51 images through the core.
#else
#error "Unsupported device."
#endif

#if defined(DEBUG)
  riscv::arch::ebreak ();
#endif /* DEBUG */

  while (true)
    {
      riscv::arch::wfi ();
    }
  /* NOTREACHED */
}

#endif /* !defined(OS_USE_SEMIHOSTING_SYSCALLS) */

// ----------------------------------------------------------------------------
