/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.bugs;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.mylyn.internal.tasks.bugs.AbstractSupportElement;
import org.eclipse.mylyn.internal.tasks.bugs.ProductRepositoryMapping;
import org.eclipse.mylyn.tasks.bugs.IProduct;
import org.eclipse.mylyn.tasks.bugs.IProvider;

public class SupportProduct
extends AbstractSupportElement
implements IProduct {
    private IBundleGroup bundleGroup;
    private boolean installed;
    TreeMap<String, ProductRepositoryMapping> mappingByNamespace = new TreeMap();
    private String pluginId;
    private IProvider provider;
    private IBundleGroup versioningBundleGroup;

    public void addRepositoryMapping(ProductRepositoryMapping mapping) {
        ProductRepositoryMapping existingMapping = this.mappingByNamespace.get(mapping.getNamespace());
        if (existingMapping != null) {
            existingMapping.getAttributes().putAll(mapping.getAttributes());
        } else {
            this.mappingByNamespace.put(mapping.getNamespace(), mapping);
        }
    }

    public Map<String, String> getAllAttributes(String prefix) {
        HashMap<String, String> attributes = null;
        int i = 0;
        while (i <= prefix.length()) {
            ProductRepositoryMapping mapping = this.getMapping(prefix.substring(0, i));
            if (mapping != null) {
                if (attributes == null) {
                    attributes = new HashMap<String, String>();
                }
                attributes.putAll(mapping.getAttributes());
            }
            ++i;
        }
        if (attributes != null) {
            return attributes;
        }
        return new HashMap<String, String>();
    }

    public String getAttribute(String prefix, String key) {
        int i = prefix.length() - 1;
        while (i >= 0) {
            String value;
            ProductRepositoryMapping mapping = this.getMapping(prefix.substring(0, i));
            if (mapping != null && (value = mapping.getAttributes().get(key)) != null) {
                return value;
            }
            --i;
        }
        return null;
    }

    public IBundleGroup getBundleGroup() {
        return this.bundleGroup;
    }

    public ProductRepositoryMapping getMapping(String prefix) {
        return this.mappingByNamespace.get(prefix);
    }

    public String getPluginId() {
        return this.pluginId;
    }

    @Override
    public IProvider getProvider() {
        return this.provider;
    }

    public boolean hasMappings() {
        return !this.mappingByNamespace.isEmpty();
    }

    public IBundleGroup getVersioningBundleGroup() {
        return this.versioningBundleGroup;
    }

    @Deprecated
    public boolean isEnabled() {
        return this.isInstalled();
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public void setBundleGroup(IBundleGroup bundleGroup) {
        this.bundleGroup = bundleGroup;
    }

    public void setVersioningBundleGroup(IBundleGroup versioningBundleGroup) {
        this.versioningBundleGroup = versioningBundleGroup;
    }

    @Deprecated
    public void setEnabled(boolean enabled) {
        this.setInstalled(enabled);
    }

    public void setInstalled(boolean enabled) {
        this.installed = enabled;
    }

    public void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    public void setProvider(IProvider provider) {
        this.provider = provider;
    }
}

