/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.ui.concurrent;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.cdt.dsf.concurrent.DefaultDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutable;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;

public class DisplayDsfExecutor
extends DefaultDsfExecutor {
    private static Map<Display, DisplayDsfExecutor> fExecutors = Collections.synchronizedMap(new HashMap());
    private final Display fDisplay;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DisplayDsfExecutor getDisplayDsfExecutor(Display display) {
        Map<Display, DisplayDsfExecutor> map = fExecutors;
        synchronized (map) {
            DisplayDsfExecutor executor = fExecutors.get(display);
            if (executor == null) {
                executor = new DisplayDsfExecutor(display);
                fExecutors.put(display, executor);
            }
            return executor;
        }
    }

    private DisplayDsfExecutor(Display display) {
        super("Display DSF Executor");
        this.fDisplay = display;
        this.fDisplay.addListener(12, event -> {
            if (event.type == 12) {
                DisplayDsfExecutor.super.shutdownNow();
            }
        });
    }

    public boolean isInExecutorThread() {
        return Thread.currentThread().equals(this.fDisplay.getThread());
    }

    private <V> Callable<V> createSWTDispatchCallable(final Callable<V> callable) {
        if (DEBUG_EXECUTOR && callable instanceof DsfExecutable) {
            assert (!((DsfExecutable)callable).getSubmitted()) : "Executable was previously executed.";
            ((DsfExecutable)callable).setSubmitted();
        }
        return new Callable<V>(){

            @Override
            public V call() throws Exception {
                Throwable[] e;
                Object[] v;
                block5: {
                    v = new Object[1];
                    e = new Throwable[1];
                    try {
                        DisplayDsfExecutor.this.fDisplay.syncExec(() -> {
                            try {
                                objectArray[0] = callable.call();
                            }
                            catch (Throwable exception) {
                                throwableArray[0] = exception;
                            }
                        });
                    }
                    catch (SWTException swtException) {
                        if (swtException.code != 45) break block5;
                        DisplayDsfExecutor.super.shutdown();
                    }
                }
                if (e[0] instanceof RuntimeException) {
                    throw (RuntimeException)e[0];
                }
                if (e[0] instanceof Error) {
                    throw (Error)e[0];
                }
                if (e[0] instanceof Exception) {
                    throw (Exception)e[0];
                }
                return v[0];
            }
        };
    }

    private Runnable createSWTDispatchRunnable(Runnable runnable) {
        if (DEBUG_EXECUTOR && runnable instanceof DsfExecutable) {
            assert (!((DsfExecutable)runnable).getSubmitted()) : "Executable was previously executed.";
            ((DsfExecutable)runnable).setSubmitted();
        }
        return () -> {
            block2: {
                try {
                    this.fDisplay.syncExec(() -> runnable.run());
                }
                catch (SWTException swtException) {
                    if (swtException.code != 45) break block2;
                    DisplayDsfExecutor.super.shutdownNow();
                }
            }
        };
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        if (this.fDisplay.isDisposed()) {
            if (!super.isShutdown()) {
                super.shutdown();
            }
            throw new RejectedExecutionException("Display " + String.valueOf(this.fDisplay) + " is disposed.");
        }
        return super.schedule(this.createSWTDispatchCallable(callable), delay, unit);
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        if (this.fDisplay.isDisposed()) {
            if (!super.isShutdown()) {
                super.shutdown();
            }
            throw new RejectedExecutionException("Display " + String.valueOf(this.fDisplay) + " is disposed.");
        }
        return super.schedule(this.createSWTDispatchRunnable(command), delay, unit);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        if (this.fDisplay.isDisposed()) {
            if (!super.isShutdown()) {
                super.shutdown();
            }
            throw new RejectedExecutionException("Display " + String.valueOf(this.fDisplay) + " is disposed.");
        }
        return super.scheduleAtFixedRate(this.createSWTDispatchRunnable(command), initialDelay, period, unit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        if (this.fDisplay.isDisposed()) {
            if (!super.isShutdown()) {
                super.shutdown();
            }
            throw new RejectedExecutionException("Display " + String.valueOf(this.fDisplay) + " is disposed.");
        }
        return super.scheduleWithFixedDelay(this.createSWTDispatchRunnable(command), initialDelay, delay, unit);
    }

    public void execute(Runnable command) {
        if (this.fDisplay.isDisposed()) {
            if (!super.isShutdown()) {
                super.shutdown();
            }
            throw new RejectedExecutionException("Display " + String.valueOf(this.fDisplay) + " is disposed.");
        }
        super.execute(this.createSWTDispatchRunnable(command));
    }

    public <T> Future<T> submit(Callable<T> callable) {
        if (this.fDisplay.isDisposed()) {
            if (!super.isShutdown()) {
                super.shutdown();
            }
            throw new RejectedExecutionException("Display " + String.valueOf(this.fDisplay) + " is disposed.");
        }
        return super.submit(this.createSWTDispatchCallable(callable));
    }

    public <T> Future<T> submit(Runnable command, T result) {
        if (this.fDisplay.isDisposed()) {
            if (!super.isShutdown()) {
                super.shutdown();
            }
            throw new RejectedExecutionException("Display " + String.valueOf(this.fDisplay) + " is disposed.");
        }
        return super.submit(this.createSWTDispatchRunnable(command), result);
    }

    public Future<?> submit(Runnable command) {
        if (this.fDisplay.isDisposed()) {
            if (!super.isShutdown()) {
                super.shutdown();
            }
            throw new RejectedExecutionException("Display " + String.valueOf(this.fDisplay) + " is disposed.");
        }
        return super.submit(this.createSWTDispatchRunnable(command));
    }

    public void shutdown() {
    }

    public List<Runnable> shutdownNow() {
        return Collections.emptyList();
    }
}

