"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
exports.inlineCode = inlineCode;
exports.link = link;
exports.codeLink = codeLink;
exports.image = image;
exports.imageLink = imageLink;
exports.video = video;
const mdLinks_1 = require("./mdLinks");
function inlineCode(text) {
    text = text.replace(/\n/, '');
    const longestBacktickSequence = Math.max(0, ...Array.from(text.matchAll(/`+/g), ([match]) => match.length));
    const backticks = '`'.repeat(longestBacktickSequence + 1);
    return `${backticks}${text}${backticks}`;
}
function link(text, uri) {
    const path = uri.toString();
    return `[${escapeMarkdownSyntaxTokens(text.replace(/\n/, ''))}](${bracketPathIfNeeded(path)})`;
}
function codeLink(text, uri) {
    const path = uri.toString();
    return `[${inlineCode(text)}](${bracketPathIfNeeded(path)})`;
}
function image(uri, alt, width) {
    const path = uri.toString();
    return `![${alt}](${bracketPathIfNeeded(path + (width ? `|width=${width}` : ''))})`;
}
function imageLink(uri, alt, width) {
    const path = uri.toString();
    return `[${image(uri, alt, width)}](${bracketPathIfNeeded(path)})`;
}
function video(uri, width) {
    const path = uri.toString();
    return `<video width="${width ?? ''}" src="${escapeHtmlAttribute(path)}" autoplay loop controls muted></video>`;
}
function escapeHtmlAttribute(value) {
    return value.replace(/"/g, '&quot;');
}
function bracketPathIfNeeded(path) {
    return (0, mdLinks_1.needsAngleBracketLink)(path) ? (0, mdLinks_1.escapeForAngleBracketLink)(path) : path;
}
/**
 * Escape markdown syntax tokens: http://daringfireball.net/projects/markdown/syntax#backslash
 */
function escapeMarkdownSyntaxTokens(text) {
    return text.replace(/[\\`*_{}[\]()#+\-!~]/g, '\\$&'); // CodeQL [SM02383] Backslash is escaped in the character class
}
//# sourceMappingURL=mdBuilder.js.map