/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclemma.internal.core;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.eclemma.core.EclEmmaStatus;
import org.eclipse.eclemma.core.ICoverageSession;
import org.eclipse.eclemma.core.ISessionExporter;
import org.eclipse.eclemma.core.analysis.IJavaModelCoverage;
import org.eclipse.eclemma.internal.core.CoreMessages;
import org.eclipse.eclemma.internal.core.analysis.SessionAnalyzer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.formatter.IndentManipulation;
import org.eclipse.osgi.util.NLS;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.data.ExecutionDataWriter;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.report.FileMultiReportOutput;
import org.jacoco.report.IMultiReportOutput;
import org.jacoco.report.IReportGroupVisitor;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.ISourceFileLocator;
import org.jacoco.report.ZipMultiReportOutput;
import org.jacoco.report.csv.CSVFormatter;
import org.jacoco.report.html.HTMLFormatter;
import org.jacoco.report.xml.XMLFormatter;

public class SessionExporter
implements ISessionExporter {
    private final ICoverageSession session;
    private ISessionExporter.ExportFormat format;
    private String destination;

    public SessionExporter(ICoverageSession session) {
        this.session = session;
    }

    public void setFormat(ISessionExporter.ExportFormat format) {
        this.format = format;
    }

    public void setDestination(String filename) {
        this.destination = filename;
    }

    public void export(IProgressMonitor monitor) throws CoreException {
        try {
            if (ISessionExporter.ExportFormat.EXEC.equals((Object)this.format)) {
                this.createExecFile(monitor);
            } else {
                this.createReport(monitor);
            }
        }
        catch (IOException e) {
            throw new CoreException(EclEmmaStatus.EXPORT_ERROR.getStatus(e));
        }
    }

    private void createExecFile(IProgressMonitor monitor) throws IOException, CoreException {
        monitor.beginTask(NLS.bind((String)CoreMessages.ExportingSession_task, (Object)this.session.getDescription()), 1);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.destination));
        ExecutionDataWriter writer = new ExecutionDataWriter((OutputStream)out);
        this.session.accept((IExecutionDataVisitor)writer, (ISessionInfoVisitor)writer);
        ((OutputStream)out).close();
        monitor.done();
    }

    private void createReport(IProgressMonitor monitor) throws CoreException, IOException {
        int work = this.session.getScope().size();
        monitor.beginTask(NLS.bind((String)CoreMessages.ExportingSession_task, (Object)this.session.getDescription()), work * 2);
        SessionAnalyzer analyzer = new SessionAnalyzer();
        IJavaModelCoverage modelCoverage = analyzer.processSession(this.session, (IProgressMonitor)new SubProgressMonitor(monitor, work));
        IReportVisitor formatter = this.createFormatter();
        formatter.visitInfo(analyzer.getSessionInfos(), analyzer.getExecutionData());
        IReportGroupVisitor modelgroup = formatter.visitGroup(this.session.getDescription());
        IJavaProject[] iJavaProjectArray = modelCoverage.getProjects();
        int n = iJavaProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject project = iJavaProjectArray[n2];
            IReportGroupVisitor projectgroup = modelgroup.visitGroup(project.getElementName());
            IPackageFragmentRoot[] iPackageFragmentRootArray = project.getPackageFragmentRoots();
            int n3 = iPackageFragmentRootArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n4];
                IBundleCoverage coverage = (IBundleCoverage)modelCoverage.getCoverageFor((IJavaElement)root);
                if (coverage != null) {
                    projectgroup.visitBundle(coverage, this.createSourceFileLocator(root));
                    monitor.worked(1);
                }
                ++n4;
            }
            ++n2;
        }
        formatter.visitEnd();
        monitor.done();
    }

    private IReportVisitor createFormatter() throws IOException {
        File file = new File(this.destination);
        if (ISessionExporter.ExportFormat.HTML.equals((Object)this.format)) {
            HTMLFormatter htmlFormatter = new HTMLFormatter();
            htmlFormatter.setFooterText(this.session.getDescription());
            return htmlFormatter.createVisitor((IMultiReportOutput)new FileMultiReportOutput(file));
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        switch (this.format) {
            case HTMLZIP: {
                HTMLFormatter htmlFormatter = new HTMLFormatter();
                htmlFormatter.setFooterText(this.session.getDescription());
                return htmlFormatter.createVisitor((IMultiReportOutput)new ZipMultiReportOutput((OutputStream)out));
            }
            case XML: {
                XMLFormatter xmlFormatter = new XMLFormatter();
                return xmlFormatter.createVisitor((OutputStream)out);
            }
            case CSV: {
                CSVFormatter csvFormatter = new CSVFormatter();
                return csvFormatter.createVisitor((OutputStream)out);
            }
        }
        ((OutputStream)out).close();
        throw new AssertionError((Object)("Unexpected format " + (Object)((Object)this.format)));
    }

    private ISourceFileLocator createSourceFileLocator(IPackageFragmentRoot root) throws JavaModelException {
        if (root.getKind() == 1) {
            return new SourceFolderSourceFileLocator(root);
        }
        return new LibrarySourceFileLocator(root);
    }

    private static abstract class AbstractSourceFileLocator
    implements ISourceFileLocator {
        protected final IPackageFragmentRoot root;
        private final int tabWidth;

        public AbstractSourceFileLocator(IPackageFragmentRoot root) {
            this.root = root;
            this.tabWidth = IndentManipulation.getTabWidth((Map)root.getJavaProject().getOptions(true));
        }

        public final int getTabWidth() {
            return this.tabWidth;
        }

        public final Reader getSourceFile(String packagename, String sourcename) throws IOException {
            try {
                packagename = packagename.replace('/', '.');
                IPackageFragment pkg = this.root.getPackageFragment(packagename);
                String source = this.getSourceReference(pkg, sourcename).getSource();
                if (source != null) {
                    return new StringReader(source);
                }
                return null;
            }
            catch (CoreException e) {
                IOException ioException = new IOException(e.getMessage());
                throw (IOException)ioException.initCause(e);
            }
        }

        protected abstract ISourceReference getSourceReference(IPackageFragment var1, String var2) throws CoreException;
    }

    private static class LibrarySourceFileLocator
    extends AbstractSourceFileLocator {
        public LibrarySourceFileLocator(IPackageFragmentRoot root) {
            super(root);
        }

        protected ISourceReference getSourceReference(IPackageFragment pkg, String sourcename) throws CoreException {
            int idx = sourcename.lastIndexOf(46);
            if (idx != -1) {
                sourcename = sourcename.substring(0, idx);
            }
            return pkg.getClassFile(String.valueOf(sourcename) + ".class");
        }
    }

    private static class SourceFolderSourceFileLocator
    extends AbstractSourceFileLocator {
        public SourceFolderSourceFileLocator(IPackageFragmentRoot root) {
            super(root);
        }

        protected ISourceReference getSourceReference(IPackageFragment pkg, String sourcename) throws CoreException {
            return pkg.getCompilationUnit(sourcename);
        }
    }
}

