/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.target;

import java.io.File;
import java.util.Objects;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.m2e.pde.target.CacheManager;
import org.eclipse.m2e.pde.target.shared.MavenBundleWrapper;
import org.eclipse.pde.core.target.TargetBundle;

public class MavenSourceBundle
extends TargetBundle {
    public MavenSourceBundle(BundleInfo sourceTarget, Artifact artifact, CacheManager cacheManager) throws Exception {
        Manifest manifest;
        this.fSourceTarget = sourceTarget;
        String symbolicName = sourceTarget.getSymbolicName();
        String version = sourceTarget.getVersion();
        this.fInfo.setSymbolicName(MavenBundleWrapper.getSourceBundleName(symbolicName));
        this.fInfo.setVersion(version);
        File sourceFile = artifact.getFile();
        Throwable throwable = null;
        Object var9_9 = null;
        try (JarFile jar = new JarFile(sourceFile);){
            manifest = Objects.requireNonNullElseGet(jar.getManifest(), Manifest::new);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (MavenBundleWrapper.isValidSourceManifest(manifest)) {
            this.fInfo.setLocation(sourceFile.toURI());
        } else {
            File generatedSourceBundle = cacheManager.accessArtifactFile(artifact, file2 -> {
                if (CacheManager.isOutdated(file2, sourceFile)) {
                    MavenBundleWrapper.addSourceBundleMetadata(manifest, symbolicName, version);
                    MavenBundleWrapper.transferJarEntries(sourceFile, manifest, file2);
                }
                return file2;
            });
            this.fInfo.setLocation(generatedSourceBundle.toURI());
        }
    }
}

