/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.editor3x;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;

public class RefactorModel {
    int fIndex = 0;
    IProject fNewProject;
    List<String> fNewTexts = new ArrayList<String>();
    IProject fOldProject;
    List<String> fOldTexts = new ArrayList<String>();
    private RefactoringParticipant fParticipant;

    public static RefactorModel getModel(RefactoringParticipant pParticipant) {
        return new RefactorModel().setRefactorParticipant(pParticipant);
    }

    public static RefactorModel getModel(RefactoringParticipant pParticipant, String pOldText, String pNewText) {
        return new RefactorModel().addTextRename(pOldText, pNewText);
    }

    public static RefactorModel getModel(RefactoringParticipant pParticipant, String pOldText, String pNewText, IProject pOldProject, IProject pNewProject) {
        return new RefactorModel().addTextRename(pOldText, pNewText).setProjectRename(pOldProject, pNewProject).setRefactorParticipant(pParticipant);
    }

    public RefactorModel addTextRename(String oldText, String newText) {
        Assert.isNotNull((Object)oldText);
        Assert.isNotNull((Object)newText);
        this.fOldTexts.add(oldText);
        this.fNewTexts.add(newText);
        return this;
    }

    public IProject getNewProject() {
        return this.fNewProject;
    }

    public String getNewTextCurrentIndex() {
        return this.fNewTexts.get(this.fIndex);
    }

    public IProject getOldProject() {
        return this.fOldProject;
    }

    public String getOldTextCurrentIndex() {
        return this.fOldTexts.get(this.fIndex);
    }

    public RefactoringParticipant getRefactoringParticipant() {
        return this.fParticipant;
    }

    public int getRenameCount() {
        return this.fOldTexts.size();
    }

    public TextChange getTextChange(IFile file) {
        return this.fParticipant.getTextChange((Object)file);
    }

    public boolean isProjectRename() {
        return this.fOldProject != null;
    }

    public RefactorModel setIndex(int index) {
        Assert.isTrue((index >= 0 ? 1 : 0) != 0);
        Assert.isTrue((index < this.fOldTexts.size() ? 1 : 0) != 0);
        this.fIndex = index;
        return this;
    }

    public RefactorModel setProjectRename(IProject oldProject, IProject newProject) {
        Assert.isNotNull((Object)oldProject);
        Assert.isNotNull((Object)newProject);
        this.fOldProject = oldProject;
        this.fNewProject = newProject;
        return this;
    }

    public RefactorModel setRefactorParticipant(RefactoringParticipant pParticipant) {
        this.fParticipant = pParticipant;
        return this;
    }
}

