/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junitlauncher;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.TestExecutionContext;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.TestResultFormatter;
import org.apache.tools.ant.util.FileUtils;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

abstract class AbstractJUnitResultFormatter
implements TestResultFormatter {
    protected TestExecutionContext context;
    private SysOutErrContentStore sysOutStore;
    private SysOutErrContentStore sysErrStore;

    AbstractJUnitResultFormatter() {
    }

    @Override
    public void sysOutAvailable(byte[] data) {
        if (this.sysOutStore == null) {
            this.sysOutStore = new SysOutErrContentStore(this.context, true);
        }
        try {
            this.sysOutStore.store(data);
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    @Override
    public void sysErrAvailable(byte[] data) {
        if (this.sysErrStore == null) {
            this.sysErrStore = new SysOutErrContentStore(this.context, false);
        }
        try {
            this.sysErrStore.store(data);
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    @Override
    public void setContext(TestExecutionContext context) {
        this.context = context;
    }

    boolean hasSysOut() {
        return this.sysOutStore != null && this.sysOutStore.hasData();
    }

    boolean hasSysErr() {
        return this.sysErrStore != null && this.sysErrStore.hasData();
    }

    Reader getSysOutReader() throws IOException {
        return this.sysOutStore.getReader();
    }

    Reader getSysErrReader() throws IOException {
        return this.sysErrStore.getReader();
    }

    void writeSysOut(Writer writer) throws IOException {
        Objects.requireNonNull(writer, "Writer cannot be null");
        this.writeFrom(this.sysOutStore, writer);
    }

    void writeSysErr(Writer writer) throws IOException {
        Objects.requireNonNull(writer, "Writer cannot be null");
        this.writeFrom(this.sysErrStore, writer);
    }

    static Optional<TestIdentifier> traverseAndFindTestClass(TestPlan testPlan, TestIdentifier testIdentifier) {
        if (AbstractJUnitResultFormatter.isTestClass(testIdentifier).isPresent()) {
            return Optional.of(testIdentifier);
        }
        Optional parent = testPlan.getParent(testIdentifier);
        return parent.isPresent() ? AbstractJUnitResultFormatter.traverseAndFindTestClass(testPlan, (TestIdentifier)parent.get()) : Optional.empty();
    }

    static Optional<ClassSource> isTestClass(TestIdentifier testIdentifier) {
        if (testIdentifier == null) {
            return Optional.empty();
        }
        Optional source = testIdentifier.getSource();
        if (!source.isPresent()) {
            return Optional.empty();
        }
        TestSource testSource = (TestSource)source.get();
        if (testSource instanceof ClassSource) {
            return Optional.of((ClassSource)testSource);
        }
        return Optional.empty();
    }

    private void writeFrom(SysOutErrContentStore store, Writer writer) throws IOException {
        char[] chars = new char[1024];
        int numRead = -1;
        try (Reader reader = store.getReader();){
            while ((numRead = reader.read(chars)) != -1) {
                writer.write(chars, 0, numRead);
            }
        }
    }

    @Override
    public void close() throws IOException {
        FileUtils.close((AutoCloseable)this.sysOutStore);
        FileUtils.close((AutoCloseable)this.sysErrStore);
    }

    protected void handleException(Throwable t) {
        this.context.getProject().ifPresent(p -> p.log("Exception in listener " + this.getClass().getName(), t, 4));
    }

    private static final class SysOutErrContentStore
    implements Closeable {
        private static final int DEFAULT_CAPACITY_IN_BYTES = 51200;
        private static final Reader EMPTY_READER = new Reader(){

            @Override
            public int read(char[] cbuf, int off, int len) throws IOException {
                return -1;
            }

            @Override
            public void close() throws IOException {
            }
        };
        private final TestExecutionContext context;
        private final String tmpFileSuffix;
        private ByteBuffer inMemoryStore = ByteBuffer.allocate(51200);
        private boolean usingFileStore = false;
        private Path filePath;
        private OutputStream fileOutputStream;

        private SysOutErrContentStore(TestExecutionContext context, boolean isSysOut) {
            this.context = context;
            this.tmpFileSuffix = isSysOut ? ".sysout" : ".syserr";
        }

        private void store(byte[] data) throws IOException {
            if (this.usingFileStore) {
                this.storeToFile(data, 0, data.length);
                return;
            }
            try {
                this.inMemoryStore.put(data);
                return;
            }
            catch (BufferOverflowException boe) {
                this.usingFileStore = true;
                this.fileOutputStream = this.createFileStore();
                this.storeToFile(this.inMemoryStore.array(), 0, this.inMemoryStore.position());
                this.storeToFile(data, 0, data.length);
                this.inMemoryStore = null;
                return;
            }
        }

        private void storeToFile(byte[] data, int offset, int length) throws IOException {
            if (this.fileOutputStream == null) {
                return;
            }
            this.fileOutputStream.write(data, offset, length);
        }

        private OutputStream createFileStore() throws IOException {
            this.filePath = FileUtils.getFileUtils().createTempFile((Project)this.context.getProject().orElse(null), null, this.tmpFileSuffix, null, true, true).toPath();
            return Files.newOutputStream(this.filePath, new OpenOption[0]);
        }

        private Reader getReader() throws IOException {
            if (this.usingFileStore && this.filePath != null) {
                return new BufferedReader(new FileReader(this.filePath.toFile()));
            }
            if (this.inMemoryStore != null) {
                return new InputStreamReader(new ByteArrayInputStream(this.inMemoryStore.array(), 0, this.inMemoryStore.position()));
            }
            return EMPTY_READER;
        }

        private boolean hasData() {
            if (this.inMemoryStore != null && this.inMemoryStore.position() > 0) {
                return true;
            }
            return this.usingFileStore && this.filePath != null;
        }

        @Override
        public void close() throws IOException {
            this.inMemoryStore = null;
            FileUtils.close((OutputStream)this.fileOutputStream);
            FileUtils.delete((File)this.filePath.toFile());
        }
    }
}

