/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclemma.internal.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.eclemma.core.CoverageTools;
import org.eclipse.eclemma.core.ICoverageSession;
import org.eclipse.eclemma.core.ISessionExporter;
import org.eclipse.eclemma.internal.ui.EclEmmaUIPlugin;
import org.eclipse.eclemma.internal.ui.UIMessages;
import org.eclipse.eclemma.internal.ui.wizards.SessionExportPage1;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class SessionExportWizard
extends Wizard
implements IExportWizard {
    public static final String ID = "org.eclipse.eclemma.ui.sessionExportWizard";
    private static final String SETTINGSID = "SessionExportWizard";
    private SessionExportPage1 page1;

    public SessionExportWizard() {
        IDialogSettings pluginsettings = EclEmmaUIPlugin.getInstance().getDialogSettings();
        IDialogSettings wizardsettings = pluginsettings.getSection(SETTINGSID);
        if (wizardsettings == null) {
            wizardsettings = pluginsettings.addNewSection(SETTINGSID);
        }
        this.setDialogSettings(wizardsettings);
        this.setWindowTitle(UIMessages.ExportSession_title);
        this.setDefaultPageImageDescriptor(EclEmmaUIPlugin.getImageDescriptor("icons/full/wizban/export_session.png"));
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.page1 = new SessionExportPage1();
        this.addPage((IWizardPage)this.page1);
    }

    public boolean performFinish() {
        this.page1.saveWidgetValues();
        return this.createReport();
    }

    private boolean createReport() {
        ICoverageSession session = this.page1.getSelectedSession();
        final ISessionExporter exporter = CoverageTools.getExporter((ICoverageSession)session);
        exporter.setFormat(this.page1.getExportFormat());
        exporter.setDestination(this.page1.getDestination());
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    exporter.export(monitor);
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            this.getContainer().run(true, true, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException ite) {
            Throwable ex = ite.getTargetException();
            EclEmmaUIPlugin.log(ex);
            String title = UIMessages.ExportSessionErrorDialog_title;
            String msg = UIMessages.ExportSessionErrorDialog_message;
            msg = NLS.bind((String)msg, (Object)session.getDescription());
            IStatus status = EclEmmaUIPlugin.errorStatus(String.valueOf(ex.getMessage()), ex);
            ErrorDialog.openError((Shell)this.getShell(), (String)title, (String)msg, (IStatus)status);
            return false;
        }
        return true;
    }
}

