/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.sync;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.internal.sync.DataProvider;
import org.eclipse.oomph.setup.internal.sync.Messages;
import org.eclipse.oomph.setup.internal.sync.SetupSyncPlugin;
import org.eclipse.oomph.setup.internal.sync.Snapshot;
import org.eclipse.oomph.setup.internal.sync.Synchronization;
import org.eclipse.oomph.setup.internal.sync.SynchronizerException;
import org.eclipse.oomph.setup.internal.sync.SynchronizerListener;
import org.eclipse.oomph.setup.sync.SyncAction;
import org.eclipse.oomph.util.LockFile;
import org.eclipse.osgi.util.NLS;

public class Synchronizer {
    private final List<SynchronizerListener> listeners = new CopyOnWriteArrayList<SynchronizerListener>();
    private final Snapshot localSnapshot;
    private final Snapshot remoteSnapshot;
    private LockFile lockFile;
    private Synchronization synchronization;

    public Synchronizer(Snapshot localSnapshot, Snapshot remoteSnapshot) {
        this.localSnapshot = localSnapshot;
        this.remoteSnapshot = remoteSnapshot;
    }

    public Synchronizer(DataProvider localDataProvider, DataProvider remoteDataProvider, File syncFolder) {
        this(localDataProvider, remoteDataProvider, syncFolder, true);
    }

    public Synchronizer(DataProvider localDataProvider, DataProvider remoteDataProvider, File syncFolder, boolean incremental) {
        this(new Snapshot(localDataProvider, syncFolder, incremental), new Snapshot(remoteDataProvider, syncFolder, incremental));
    }

    public Snapshot getLocalSnapshot() {
        return this.localSnapshot;
    }

    public Snapshot getRemoteSnapshot() {
        return this.remoteSnapshot;
    }

    public LockFile getLockFile() {
        return this.lockFile;
    }

    public void setLockFile(LockFile lockFile) {
        this.lockFile = lockFile;
    }

    public Synchronization synchronize() throws IOException, SynchronizerException {
        return this.synchronize(false);
    }

    public synchronized Synchronization synchronize(boolean deferLocal) throws IOException, SynchronizerException {
        if (this.synchronization != null) {
            this.synchronization.dispose();
            this.synchronization = null;
        }
        if (this.lockFile != null) {
            try {
                this.lockFile.lock();
            }
            catch (Exception ex) {
                throw new LockException(this.lockFile.getFile());
            }
        }
        try {
            this.synchronization = this.createSynchronization(deferLocal);
        }
        catch (IOException ex) {
            this.doReleaseLock();
            throw ex;
        }
        catch (RuntimeException ex) {
            this.doReleaseLock();
            throw ex;
        }
        catch (Error ex) {
            this.doReleaseLock();
            throw ex;
        }
        return this.synchronization;
    }

    protected Synchronization createSynchronization(boolean deferLocal) throws IOException {
        return new Synchronization(this, deferLocal);
    }

    public void copyFilesTo(File target) {
        if (this.localSnapshot != null) {
            this.localSnapshot.copyFilesTo(target);
        }
        if (this.remoteSnapshot != null) {
            this.remoteSnapshot.copyFilesTo(target);
        }
    }

    public void copyFilesFrom(File source) {
        if (this.localSnapshot != null) {
            this.localSnapshot.copyFilesFrom(source);
        }
        if (this.remoteSnapshot != null) {
            this.remoteSnapshot.copyFilesFrom(source);
        }
    }

    public SynchronizerListener[] getListeners() {
        return this.listeners.toArray(new SynchronizerListener[this.listeners.size()]);
    }

    public void addListener(SynchronizerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(SynchronizerListener listener) {
        this.listeners.remove(listener);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + String.valueOf(this.localSnapshot) + " <--> " + String.valueOf(this.remoteSnapshot) + "]";
    }

    protected void syncStarted() {
        for (SynchronizerListener listener : this.listeners) {
            try {
                listener.syncStarted(this.synchronization);
            }
            catch (Throwable ex) {
                SetupSyncPlugin.INSTANCE.log(ex);
            }
        }
    }

    protected void workingCopyCreated(Snapshot.WorkingCopy workingCopy) {
        for (SynchronizerListener listener : this.listeners) {
            try {
                listener.workingCopyCreated(this.synchronization, workingCopy);
            }
            catch (Throwable ex) {
                SetupSyncPlugin.INSTANCE.log(ex);
            }
        }
    }

    protected void tasksCollected(Synchronization synchronization, DataProvider.Location location, Map<String, SetupTask> oldTasks, Map<String, SetupTask> newTasks) {
        for (SynchronizerListener listener : this.listeners) {
            try {
                listener.tasksCollected(synchronization, location, oldTasks, newTasks);
            }
            catch (Throwable ex) {
                SetupSyncPlugin.INSTANCE.log(ex);
            }
        }
    }

    protected void actionsComputed(Map<String, SyncAction> actions) {
        for (SynchronizerListener listener : this.listeners) {
            try {
                listener.actionsComputed(this.synchronization, actions);
            }
            catch (Throwable ex) {
                SetupSyncPlugin.INSTANCE.log(ex);
            }
        }
    }

    protected void actionResolved(SyncAction action, String id) {
        for (SynchronizerListener listener : this.listeners) {
            try {
                listener.actionResolved(this.synchronization, action, id);
            }
            catch (Throwable ex) {
                SetupSyncPlugin.INSTANCE.log(ex);
            }
        }
    }

    protected void commitStarted() {
        for (SynchronizerListener listener : this.listeners) {
            try {
                listener.commitStarted(this.synchronization);
            }
            catch (Throwable ex) {
                SetupSyncPlugin.INSTANCE.log(ex);
            }
        }
    }

    protected void commitFinished(Throwable exception) {
        for (SynchronizerListener listener : this.listeners) {
            try {
                listener.commitFinished(this.synchronization, exception);
            }
            catch (Throwable ex) {
                SetupSyncPlugin.INSTANCE.log(ex);
            }
        }
    }

    protected synchronized void releaseLock() {
        if (this.synchronization != null) {
            Synchronization oldSynchronization = this.synchronization;
            this.synchronization = null;
            this.doReleaseLock();
            for (SynchronizerListener listener : this.listeners) {
                try {
                    listener.lockReleased(oldSynchronization);
                }
                catch (Throwable ex) {
                    SetupSyncPlugin.INSTANCE.log(ex);
                }
            }
        }
    }

    private void doReleaseLock() {
        if (this.lockFile != null) {
            this.lockFile.unlock();
        }
    }

    public static class LockException
    extends SynchronizerException {
        private static final long serialVersionUID = 1L;

        public LockException(File file) {
            super(NLS.bind((String)Messages.Synchronizer_OtherSyncLock_exception, (Object)file));
        }
    }
}

