/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.declaration;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.internal.DocumentUtil;
import org.eclipse.swt.custom.StyledText;

final class DeferredOpenDeclarationHyperlink
implements IHyperlink {
    private static final long DEFERRED_OPEN_TIMEOUT_NANOS = TimeUnit.SECONDS.toNanos(5L);
    private final ITextViewer viewer;
    private final IDocument document;
    private final long documentInitialModificationStamp;
    private final IRegion region;
    private final CompletableFuture<@Nullable IHyperlink> future;
    private final long createdNanos = System.nanoTime();

    DeferredOpenDeclarationHyperlink(ITextViewer viewer, IDocument document, IRegion region, CompletableFuture<@Nullable IHyperlink> future) {
        this.viewer = viewer;
        this.document = document;
        this.region = region;
        this.future = future;
        this.documentInitialModificationStamp = DocumentUtil.getDocumentModificationStamp(document);
    }

    public IRegion getHyperlinkRegion() {
        return this.region;
    }

    public @Nullable String getTypeLabel() {
        IHyperlink link = this.getResolvedLink();
        return link != null ? link.getTypeLabel() : null;
    }

    public @Nullable String getHyperlinkText() {
        IHyperlink link = this.getResolvedLink();
        return link != null ? link.getHyperlinkText() : null;
    }

    public void open() {
        this.future.whenComplete((link, ex) -> {
            if (ex != null) {
                LanguageServerPlugin.logError(ex.getLocalizedMessage(), ex);
                return;
            }
            StyledText widget = this.viewer.getTextWidget();
            if (widget == null) {
                return;
            }
            if (link == null) {
                LanguageServerPlugin.logWarning("No hyperlink target resolved for Open Declaration");
                return;
            }
            widget.getDisplay().asyncExec(() -> {
                if (this.isStale()) {
                    return;
                }
                link.open();
            });
        });
    }

    private @Nullable IHyperlink getResolvedLink() {
        try {
            return this.future.getNow(null);
        }
        catch (CompletionException ex) {
            LanguageServerPlugin.logError(ex.getLocalizedMessage(), ex);
            return null;
        }
    }

    private boolean isStale() {
        if (System.nanoTime() - this.createdNanos > DEFERRED_OPEN_TIMEOUT_NANOS) {
            return true;
        }
        StyledText widget = this.viewer.getTextWidget();
        if (widget == null || widget.isDisposed()) {
            return true;
        }
        return this.documentInitialModificationStamp != -1L && DocumentUtil.getDocumentModificationStamp(this.document) != this.documentInitialModificationStamp;
    }
}

