/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.util;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSelector;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSelectorList;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleRule;
import org.eclipse.wst.css.core.internal.util.AbstractCssTraverser;

public class SelectorsCollector
extends AbstractCssTraverser {
    protected Vector selectors = new Vector();
    protected Vector selectorsToAvoid = null;

    public SelectorsCollector() {
        this.setTraverseImported(false);
    }

    public void addSelectorToAvoid(ICSSSelector selToAvoid) {
        if (selToAvoid == null) {
            return;
        }
        if (this.selectorsToAvoid == null) {
            this.selectorsToAvoid = new Vector();
        }
        if (!this.selectorsToAvoid.contains(selToAvoid)) {
            this.selectorsToAvoid.add(selToAvoid);
        }
    }

    public void addSelectorToAvoid(ICSSStyleRule rule) {
        ICSSSelectorList list = rule.getSelectors();
        Iterator it = list.getIterator();
        while (it.hasNext()) {
            ICSSSelector sel = (ICSSSelector)it.next();
            this.addSelectorToAvoid(sel);
        }
    }

    public List getSelectors() {
        return this.selectors;
    }

    @Override
    protected short preNode(ICSSNode node) {
        if (node.getNodeType() == 1) {
            ICSSStyleRule rule = (ICSSStyleRule)node;
            ICSSSelectorList list = rule.getSelectors();
            Iterator it = list.getIterator();
            while (it.hasNext()) {
                Object obj = it.next();
                if (this.selectorsToAvoid != null && this.selectorsToAvoid.contains(obj) || this.selectors.contains(obj)) continue;
                this.selectors.add(obj);
            }
            return TRAV_PRUNE;
        }
        if (node.getNodeType() == 7) {
            return TRAV_CONT;
        }
        return TRAV_PRUNE;
    }

    public void setSelectorsToAvoid(Vector newSelectorsToAvoid) {
        this.selectorsToAvoid = newSelectorsToAvoid;
    }
}

