/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.ecj;

import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.scout.sdk.core.java.ecj.AbstractJavaElementWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.SpiWithEcjUtils;
import org.eclipse.scout.sdk.core.java.ecj.metavalue.MetaValueFactory;
import org.eclipse.scout.sdk.core.java.model.api.IAnnotationElement;
import org.eclipse.scout.sdk.core.java.model.api.IMetaValue;
import org.eclipse.scout.sdk.core.java.model.api.internal.AnnotationElementImplementor;
import org.eclipse.scout.sdk.core.java.model.spi.AbstractJavaEnvironment;
import org.eclipse.scout.sdk.core.java.model.spi.AnnotationElementSpi;
import org.eclipse.scout.sdk.core.java.model.spi.AnnotationSpi;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.core.util.SourceRange;

public class BindingAnnotationElementWithEcj
extends AbstractJavaElementWithEcj<IAnnotationElement>
implements AnnotationElementSpi {
    private final AnnotationSpi m_declaringAnnotation;
    private final ElementValuePair m_binding;
    private final String m_name;
    private final boolean m_syntheticDefaultValue;
    private final FinalValue<IMetaValue> m_value;
    private final FinalValue<SourceRange> m_source;
    private final FinalValue<SourceRange> m_expressionSource;
    private final FinalValue<MemberValuePair> m_memberValuePair;

    protected BindingAnnotationElementWithEcj(AbstractJavaEnvironment env, AnnotationSpi owner, ElementValuePair bindingPair, boolean syntheticDefaultValue) {
        super(env);
        this.m_declaringAnnotation = (AnnotationSpi)Ensure.notNull((Object)owner);
        this.m_binding = (ElementValuePair)Ensure.notNull((Object)bindingPair);
        this.m_syntheticDefaultValue = syntheticDefaultValue;
        this.m_name = new String(this.m_binding.getName());
        this.m_value = new FinalValue();
        this.m_source = new FinalValue();
        this.m_expressionSource = new FinalValue();
        this.m_memberValuePair = new FinalValue();
    }

    public AnnotationElementSpi internalFindNewElement() {
        return SpiWithEcjUtils.findNewAnnotationElementIn(this.getDeclaringAnnotation(), this.getElementName());
    }

    protected IAnnotationElement internalCreateApi() {
        return new AnnotationElementImplementor((AnnotationElementSpi)this);
    }

    public ElementValuePair getInternalBinding() {
        return this.m_binding;
    }

    public String getElementName() {
        return this.m_name;
    }

    protected static Object getAnnotationElementValue(BindingAnnotationElementWithEcj a) {
        return a.m_binding.getValue();
    }

    public IMetaValue getMetaValue() {
        return (IMetaValue)this.m_value.computeIfAbsentAndGet(() -> {
            Object value = BindingAnnotationElementWithEcj.getAnnotationElementValue(this);
            IMetaValue metaVal = SpiWithEcjUtils.resolveCompiledValue(this.javaEnvWithEcj(), this.m_declaringAnnotation.getOwner(), value, () -> this.withNewElement(BindingAnnotationElementWithEcj::getAnnotationElementValue));
            if (metaVal != null) {
                return metaVal;
            }
            return MetaValueFactory.createUnknown(value);
        });
    }

    public boolean isDefaultValue() {
        return this.m_syntheticDefaultValue;
    }

    public AnnotationSpi getDeclaringAnnotation() {
        return this.m_declaringAnnotation;
    }

    MemberValuePair memberValuePair() {
        return (MemberValuePair)this.m_memberValuePair.computeIfAbsentAndGet(() -> SpiWithEcjUtils.findAnnotationValueDeclaration(this));
    }

    public SourceRange getSource() {
        return (SourceRange)this.m_source.computeIfAbsentAndGet(() -> {
            MemberValuePair pairDecl = this.memberValuePair();
            if (pairDecl == null) {
                return null;
            }
            return new SourceRange((CharSequence)pairDecl.toString(), pairDecl.sourceStart);
        });
    }

    protected Expression getValueExpression() {
        MemberValuePair pairDecl = this.memberValuePair();
        if (pairDecl == null) {
            return null;
        }
        return pairDecl.value;
    }

    public SourceRange getSourceOfExpression() {
        return (SourceRange)this.m_expressionSource.computeIfAbsentAndGet(() -> {
            Expression expr = this.getValueExpression();
            if (expr != null) {
                return new SourceRange((CharSequence)expr.toString(), expr.sourceStart);
            }
            return null;
        });
    }
}

