/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.imports;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.java.JavaTypes;
import org.eclipse.scout.sdk.core.java.builder.IJavaBuilderContext;
import org.eclipse.scout.sdk.core.java.imports.IImportCollector;
import org.eclipse.scout.sdk.core.java.imports.TypeReferenceDescriptor;
import org.eclipse.scout.sdk.core.java.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.util.Strings;

public class ImportCollector
implements IImportCollector {
    private final IJavaBuilderContext m_context;
    private final Map<String, ImportElement> m_imports = new HashMap<String, ImportElement>();
    private final Map<String, ImportElement> m_staticImports = new HashMap<String, ImportElement>();

    public ImportCollector() {
        this(null);
    }

    public ImportCollector(IJavaBuilderContext context) {
        this.m_context = context;
    }

    protected static Stream<StringBuilder> getImports(Collection<ImportElement> imports) {
        return imports.stream().map(ImportElement::getImport);
    }

    protected static void addFiltered(Iterable<ImportElement> elements, boolean includeExisting, Collection<ImportElement> collector) {
        for (ImportElement e : elements) {
            if (!includeExisting && e.m_fromExisting || !e.m_static && (!e.m_used || "java.lang".equals(e.m_packageName))) continue;
            collector.add(e);
        }
    }

    protected static Stream<StringBuilder> organizeImports(Iterable<ImportElement> unsortedList1, Iterable<ImportElement> unsortedList2, boolean includeExisting) {
        TreeSet<ImportElement> workList = new TreeSet<ImportElement>(new ImportComparator());
        ImportCollector.addFiltered(unsortedList1, includeExisting, workList);
        ImportCollector.addFiltered(unsortedList2, includeExisting, workList);
        int lastGroup = -1;
        ArrayList<StringBuilder> result = new ArrayList<StringBuilder>(workList.size() + 7);
        for (ImportElement e : workList) {
            if (lastGroup > 0 && lastGroup != e.m_group) {
                result.add(new StringBuilder(0));
            }
            result.add(ImportCollector.createImportDeclaration(e.m_static, e.getImport()));
            lastGroup = e.m_group;
        }
        return result.stream();
    }

    @Override
    public Optional<IJavaBuilderContext> getContext() {
        return Optional.ofNullable(this.m_context);
    }

    @Override
    public Optional<IJavaEnvironment> getJavaEnvironment() {
        return this.getContext().flatMap(IJavaBuilderContext::environment);
    }

    @Override
    public String getQualifier() {
        return null;
    }

    @Override
    public void reserveElement(TypeReferenceDescriptor candidate) {
        this.registerElementInternal(candidate, false);
    }

    @Override
    public String registerElement(TypeReferenceDescriptor candidate) {
        return this.registerElementInternal(candidate, true);
    }

    protected String registerElementInternal(TypeReferenceDescriptor candidate, boolean markAsUsed) {
        ImportElement elem = this.m_imports.get(candidate.getSimpleName());
        if (elem == null) {
            this.m_imports.put(candidate.getSimpleName(), new ImportElement(false, candidate.getQualifier(), candidate.getSimpleName(), markAsUsed, false));
        } else {
            elem.m_used = markAsUsed || elem.m_used;
        }
        return candidate.getSimpleName();
    }

    @Override
    public String checkExistingImports(TypeReferenceDescriptor candidate) {
        if (candidate.isBaseType() || Strings.isBlank((CharSequence)candidate.getQualifier())) {
            return candidate.getSimpleName();
        }
        ImportElement existingElem = this.m_imports.get(candidate.getSimpleName());
        if (existingElem != null && Objects.equals(existingElem.m_packageName, candidate.getQualifier())) {
            if (existingElem.m_used) {
                return candidate.getSimpleName();
            }
            return null;
        }
        if (existingElem != null) {
            return candidate.getQualifiedName();
        }
        return null;
    }

    @Override
    public String checkCurrentScope(TypeReferenceDescriptor candidate) {
        return null;
    }

    @Override
    public void addImport(CharSequence fqn) {
        this.addImport(fqn, false);
    }

    public void addImport(CharSequence fqn, boolean fromExisting) {
        String packageName = JavaTypes.qualifier(fqn);
        String simpleName = JavaTypes.simpleName(fqn);
        this.m_imports.put(simpleName, new ImportElement(false, packageName, simpleName, true, fromExisting));
    }

    @Override
    public void addStaticImport(CharSequence fqn) {
        this.addStaticImport(fqn, false);
    }

    protected void addStaticImport(CharSequence fqn, boolean fromExisting) {
        String packageName = JavaTypes.qualifier(fqn);
        String simpleName = JavaTypes.simpleName(fqn);
        this.m_staticImports.put(simpleName, new ImportElement(true, packageName, simpleName, true, fromExisting));
    }

    @Override
    public Stream<StringBuilder> getImports() {
        return ImportCollector.getImports(this.m_imports.values());
    }

    @Override
    public Stream<StringBuilder> getStaticImports() {
        return ImportCollector.getImports(this.m_staticImports.values());
    }

    @Override
    public Stream<StringBuilder> createImportDeclarations() {
        return this.createImportDeclarations(true);
    }

    @Override
    public Stream<StringBuilder> createImportDeclarations(boolean includeExisting) {
        return ImportCollector.organizeImports(this.m_staticImports.values(), this.m_imports.values(), includeExisting);
    }

    public static StringBuilder createImportDeclaration(boolean isStatic, CharSequence fullImportExpr) {
        String importPart = "import ";
        String staticPart = "static ";
        StringBuilder b = new StringBuilder(importPart.length() + staticPart.length() + fullImportExpr.length() + 1);
        b.append(importPart);
        if (isStatic) {
            b.append(staticPart);
        }
        return b.append(fullImportExpr).append(';');
    }

    protected static final class ImportElement {
        private final boolean m_static;
        private final String m_packageName;
        private final String m_simpleName;
        private final boolean m_fromExisting;
        private final int m_group;
        private boolean m_used;

        private ImportElement(boolean isStatic, String packageName, String simpleName, boolean used, boolean fromExisting) {
            this.m_static = isStatic;
            this.m_packageName = packageName;
            this.m_simpleName = simpleName;
            this.m_used = used;
            this.m_fromExisting = fromExisting;
            this.m_group = ImportElement.calculateGroup(isStatic, packageName);
        }

        private static int calculateGroup(boolean isStaticImport, String packageName) {
            int factor = isStaticImport ? 1 : 10;
            if (packageName != null) {
                if (packageName.startsWith("java.")) {
                    return factor;
                }
                if (packageName.startsWith("javax.")) {
                    return 2 * factor;
                }
                if (packageName.startsWith("jakarta.")) {
                    return 3 * factor;
                }
                if (packageName.startsWith("org.")) {
                    return 4 * factor;
                }
            }
            return 5 * factor;
        }

        public StringBuilder getImport() {
            if (this.m_packageName == null) {
                return new StringBuilder(this.m_simpleName);
            }
            return new StringBuilder(this.m_packageName.length() + this.m_simpleName.length() + 1).append(this.m_packageName).append('.').append(this.m_simpleName);
        }
    }

    private static final class ImportComparator
    implements Comparator<ImportElement>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private ImportComparator() {
        }

        @Override
        public int compare(ImportElement e1, ImportElement e2) {
            int result = Integer.compare(e1.m_group, e2.m_group);
            if (result != 0) {
                return result;
            }
            result = ImportComparator.compareStrings(e1.m_packageName, e2.m_packageName);
            if (result != 0) {
                return result;
            }
            return e1.m_simpleName.compareTo(e2.m_simpleName);
        }

        private static int compareStrings(String a, String b) {
            if (a == b) {
                return 0;
            }
            if (a == null) {
                return 1;
            }
            if (b == null) {
                return -1;
            }
            return a.compareTo(b);
        }
    }
}

