/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.ecj;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.scout.sdk.core.java.ecj.AbstractJavaElementWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.AbstractMemberWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.SpiWithEcjUtils;
import org.eclipse.scout.sdk.core.java.model.api.ITypeParameter;
import org.eclipse.scout.sdk.core.java.model.api.internal.TypeParameterImplementor;
import org.eclipse.scout.sdk.core.java.model.spi.AbstractJavaEnvironment;
import org.eclipse.scout.sdk.core.java.model.spi.CompilationUnitSpi;
import org.eclipse.scout.sdk.core.java.model.spi.MemberSpi;
import org.eclipse.scout.sdk.core.java.model.spi.TypeParameterSpi;
import org.eclipse.scout.sdk.core.java.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.core.util.SourceRange;

public class DeclarationTypeParameterWithEcj
extends AbstractJavaElementWithEcj<ITypeParameter>
implements TypeParameterSpi {
    private final AbstractMemberWithEcj<?> m_declaringMember;
    private final TypeParameter m_astNode;
    private final int m_index;
    private final String m_name;
    private final FinalValue<List<TypeSpi>> m_bounds;
    private final FinalValue<SourceRange> m_source;

    protected DeclarationTypeParameterWithEcj(AbstractJavaEnvironment env, AbstractMemberWithEcj<?> declaringMember, TypeParameter astNode, int index) {
        super(env);
        this.m_declaringMember = (AbstractMemberWithEcj)((Object)Ensure.notNull(declaringMember));
        this.m_astNode = (TypeParameter)Ensure.notNull((Object)astNode);
        this.m_index = index;
        this.m_name = new String(this.m_astNode.name);
        this.m_bounds = new FinalValue();
        this.m_source = new FinalValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TypeBinding ensureResolvedType(Scope scope, Expression r) {
        TypeBinding resolvedType = r.resolvedType;
        if (resolvedType != null) {
            return resolvedType;
        }
        Object object = this.javaEnvWithEcj().lock();
        synchronized (object) {
            if (scope instanceof ClassScope) {
                r.resolveType((ClassScope)scope);
            } else {
                r.resolveType((BlockScope)scope);
            }
        }
        return r.resolvedType;
    }

    public TypeParameterSpi internalFindNewElement() {
        MemberSpi newMember = (MemberSpi)this.getDeclaringMember().internalFindNewElement();
        if (newMember != null && newMember.getTypeParameters().size() > this.m_index) {
            return (TypeParameterSpi)newMember.getTypeParameters().get(this.m_index);
        }
        return null;
    }

    protected ITypeParameter internalCreateApi() {
        return new TypeParameterImplementor((TypeParameterSpi)this);
    }

    public TypeParameter getInternalTypeParameter() {
        return this.m_astNode;
    }

    public List<TypeSpi> getBounds() {
        return (List)this.m_bounds.computeIfAbsentAndGet(this::computeBounds);
    }

    protected List<TypeSpi> computeBounds() {
        TypeSpi t;
        boolean hasType = this.m_astNode.type != null;
        boolean hasBounds = this.m_astNode.bounds != null && this.m_astNode.bounds.length > 0;
        int size = 0;
        if (hasType) {
            ++size;
        }
        if (hasBounds) {
            size += this.m_astNode.bounds.length;
        }
        ArrayList<TypeSpi> bounds = new ArrayList<TypeSpi>(size);
        if (hasType && (t = SpiWithEcjUtils.bindingToType(this.javaEnvWithEcj(), this.resolveType(this), () -> (TypeBinding)this.withNewElement(this::resolveType))) != null) {
            bounds.add(t);
        }
        if (hasBounds) {
            bounds.addAll(SpiWithEcjUtils.bindingsToTypes(this.javaEnvWithEcj(), this.resolveBounds(this), () -> (TypeBinding[])this.withNewElement(this::resolveBounds)));
        }
        return bounds;
    }

    protected TypeBinding resolveType(DeclarationTypeParameterWithEcj parameter) {
        Scope scope = SpiWithEcjUtils.memberScopeOf(parameter);
        return this.ensureResolvedType(scope, (Expression)parameter.m_astNode.type);
    }

    protected TypeBinding[] resolveBounds(DeclarationTypeParameterWithEcj parameter) {
        Scope scope = SpiWithEcjUtils.memberScopeOf(parameter);
        return (TypeBinding[])Arrays.stream(parameter.m_astNode.bounds).map(b -> this.ensureResolvedType(scope, (Expression)b)).toArray(TypeBinding[]::new);
    }

    public AbstractMemberWithEcj<?> getDeclaringMember() {
        return this.m_declaringMember;
    }

    public String getElementName() {
        return this.m_name;
    }

    public SourceRange getSource() {
        return (SourceRange)this.m_source.computeIfAbsentAndGet(() -> {
            CompilationUnitSpi cu = SpiWithEcjUtils.declaringTypeOf(this).getCompilationUnit();
            TypeParameter decl = this.m_astNode;
            return this.javaEnvWithEcj().getSource(cu, decl.declarationSourceStart, decl.declarationSourceEnd);
        });
    }
}

