/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.ClassGraphException;
import io.github.classgraph.ModulePathInfo;
import io.github.classgraph.ModuleRef;
import io.github.classgraph.PackageInfo;
import io.github.classgraph.ScanResult;
import io.github.classgraph.Scanner;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import nonapi.io.github.classgraph.classpath.SystemJarFinder;
import nonapi.io.github.classgraph.concurrency.AutoCloseableExecutorService;
import nonapi.io.github.classgraph.concurrency.InterruptionChecker;
import nonapi.io.github.classgraph.reflection.ReflectionUtils;
import nonapi.io.github.classgraph.scanspec.AcceptReject;
import nonapi.io.github.classgraph.scanspec.ScanSpec;
import nonapi.io.github.classgraph.utils.JarUtils;
import nonapi.io.github.classgraph.utils.LogNode;
import nonapi.io.github.classgraph.utils.VersionFinder;

public class ClassGraph {
    ScanSpec scanSpec = new ScanSpec();
    static final int DEFAULT_NUM_WORKER_THREADS = Math.max(2, (int)Math.ceil(Math.min(4.0, (double)Runtime.getRuntime().availableProcessors() * 0.75) + (double)Runtime.getRuntime().availableProcessors() * 1.25));
    public static CircumventEncapsulationMethod CIRCUMVENT_ENCAPSULATION = CircumventEncapsulationMethod.NONE;
    private final ReflectionUtils reflectionUtils = new ReflectionUtils();
    private LogNode topLevelLog;

    public ClassGraph() {
        ScanResult.init(this.reflectionUtils);
    }

    public static String getVersion() {
        return VersionFinder.getVersion();
    }

    public ClassGraph verbose() {
        if (this.topLevelLog == null) {
            this.topLevelLog = new LogNode();
        }
        return this;
    }

    public ClassGraph verbose(boolean verbose) {
        if (verbose) {
            this.verbose();
        }
        return this;
    }

    public ClassGraph enableAllInfo() {
        this.enableClassInfo();
        this.enableFieldInfo();
        this.enableMethodInfo();
        this.enableAnnotationInfo();
        this.enableStaticFinalFieldConstantInitializerValues();
        this.ignoreClassVisibility();
        this.ignoreFieldVisibility();
        this.ignoreMethodVisibility();
        return this;
    }

    public ClassGraph enableClassInfo() {
        this.scanSpec.enableClassInfo = true;
        this.scanSpec.enableMultiReleaseVersions = false;
        return this;
    }

    public ClassGraph ignoreClassVisibility() {
        this.enableClassInfo();
        this.scanSpec.ignoreClassVisibility = true;
        return this;
    }

    public ClassGraph enableMethodInfo() {
        this.enableClassInfo();
        this.scanSpec.enableMethodInfo = true;
        return this;
    }

    public ClassGraph ignoreMethodVisibility() {
        this.enableClassInfo();
        this.enableMethodInfo();
        this.scanSpec.ignoreMethodVisibility = true;
        return this;
    }

    public ClassGraph enableFieldInfo() {
        this.enableClassInfo();
        this.scanSpec.enableFieldInfo = true;
        return this;
    }

    public ClassGraph ignoreFieldVisibility() {
        this.enableClassInfo();
        this.enableFieldInfo();
        this.scanSpec.ignoreFieldVisibility = true;
        return this;
    }

    public ClassGraph enableStaticFinalFieldConstantInitializerValues() {
        this.enableClassInfo();
        this.enableFieldInfo();
        this.scanSpec.enableStaticFinalFieldConstantInitializerValues = true;
        return this;
    }

    public ClassGraph enableAnnotationInfo() {
        this.enableClassInfo();
        this.scanSpec.enableAnnotationInfo = true;
        return this;
    }

    public ClassGraph enableInterClassDependencies() {
        this.enableClassInfo();
        this.enableFieldInfo();
        this.enableMethodInfo();
        this.enableAnnotationInfo();
        this.ignoreClassVisibility();
        this.ignoreFieldVisibility();
        this.ignoreMethodVisibility();
        this.scanSpec.enableInterClassDependencies = true;
        return this;
    }

    public ClassGraph disableRuntimeInvisibleAnnotations() {
        this.enableClassInfo();
        this.scanSpec.disableRuntimeInvisibleAnnotations = true;
        return this;
    }

    public ClassGraph disableJarScanning() {
        this.scanSpec.scanJars = false;
        return this;
    }

    public ClassGraph disableNestedJarScanning() {
        this.scanSpec.scanNestedJars = false;
        return this;
    }

    public ClassGraph disableDirScanning() {
        this.scanSpec.scanDirs = false;
        return this;
    }

    public ClassGraph disableModuleScanning() {
        this.scanSpec.scanModules = false;
        return this;
    }

    public ClassGraph enableExternalClasses() {
        this.enableClassInfo();
        this.scanSpec.enableExternalClasses = true;
        return this;
    }

    public ClassGraph initializeLoadedClasses() {
        this.scanSpec.initializeLoadedClasses = true;
        return this;
    }

    public ClassGraph removeTemporaryFilesAfterScan() {
        this.scanSpec.removeTemporaryFilesAfterScan = true;
        return this;
    }

    public ClassGraph overrideClasspath(String overrideClasspath) {
        if (overrideClasspath.isEmpty()) {
            throw new IllegalArgumentException("Can't override classpath with an empty path");
        }
        String[] stringArray = JarUtils.smartPathSplit(overrideClasspath, this.scanSpec);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String classpathElement = stringArray[n2];
            this.scanSpec.addClasspathOverride(classpathElement);
            ++n2;
        }
        return this;
    }

    public ClassGraph overrideClasspath(Iterable<?> overrideClasspathElements) {
        if (!overrideClasspathElements.iterator().hasNext()) {
            throw new IllegalArgumentException("Can't override classpath with an empty path");
        }
        for (Object classpathElement : overrideClasspathElements) {
            this.scanSpec.addClasspathOverride(classpathElement);
        }
        return this;
    }

    public ClassGraph overrideClasspath(Object ... overrideClasspathElements) {
        if (overrideClasspathElements.length == 0) {
            throw new IllegalArgumentException("Can't override classpath with an empty path");
        }
        Object[] objectArray = overrideClasspathElements;
        int n = overrideClasspathElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object classpathElement = objectArray[n2];
            this.scanSpec.addClasspathOverride(classpathElement);
            ++n2;
        }
        return this;
    }

    public ClassGraph filterClasspathElements(ClasspathElementFilter classpathElementFilter) {
        this.scanSpec.filterClasspathElements(classpathElementFilter);
        return this;
    }

    public ClassGraph filterClasspathElementsByURL(ClasspathElementURLFilter classpathElementURLFilter) {
        this.scanSpec.filterClasspathElements(classpathElementURLFilter);
        return this;
    }

    public ClassGraph addClassLoader(ClassLoader classLoader) {
        this.scanSpec.addClassLoader(classLoader);
        return this;
    }

    public ClassGraph overrideClassLoaders(ClassLoader ... overrideClassLoaders) {
        this.scanSpec.overrideClassLoaders(overrideClassLoaders);
        return this;
    }

    public ClassGraph ignoreParentClassLoaders() {
        this.scanSpec.ignoreParentClassLoaders = true;
        return this;
    }

    public ClassGraph addModuleLayer(Object moduleLayer) {
        this.scanSpec.addModuleLayer(moduleLayer);
        return this;
    }

    public ClassGraph overrideModuleLayers(Object ... overrideModuleLayers) {
        this.scanSpec.overrideModuleLayers(overrideModuleLayers);
        return this;
    }

    public ClassGraph ignoreParentModuleLayers() {
        this.scanSpec.ignoreParentModuleLayers = true;
        return this;
    }

    public ClassGraph acceptPackages(String ... packageNames) {
        this.enableClassInfo();
        String[] stringArray = packageNames;
        int n = packageNames.length;
        int n2 = 0;
        while (n2 < n) {
            String packageName = stringArray[n2];
            String packageNameNormalized = AcceptReject.normalizePackageOrClassName(packageName);
            this.scanSpec.packageAcceptReject.addToAccept(packageNameNormalized);
            String path = AcceptReject.packageNameToPath(packageNameNormalized);
            this.scanSpec.pathAcceptReject.addToAccept(String.valueOf(path) + "/");
            if (packageNameNormalized.isEmpty()) {
                this.scanSpec.pathAcceptReject.addToAccept("");
            }
            if (!packageNameNormalized.contains("*")) {
                if (packageNameNormalized.isEmpty()) {
                    this.scanSpec.packagePrefixAcceptReject.addToAccept("");
                    this.scanSpec.pathPrefixAcceptReject.addToAccept("");
                } else {
                    this.scanSpec.packagePrefixAcceptReject.addToAccept(String.valueOf(packageNameNormalized) + ".");
                    this.scanSpec.pathPrefixAcceptReject.addToAccept(String.valueOf(path) + "/");
                }
            }
            ++n2;
        }
        return this;
    }

    @Deprecated
    public ClassGraph whitelistPackages(String ... packageNames) {
        return this.acceptPackages(packageNames);
    }

    public ClassGraph acceptPaths(String ... paths) {
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            String pathNormalized = AcceptReject.normalizePath(path);
            String packageName = AcceptReject.pathToPackageName(pathNormalized);
            this.scanSpec.packageAcceptReject.addToAccept(packageName);
            this.scanSpec.pathAcceptReject.addToAccept(String.valueOf(pathNormalized) + "/");
            if (pathNormalized.isEmpty()) {
                this.scanSpec.pathAcceptReject.addToAccept("");
            }
            if (!pathNormalized.contains("*")) {
                if (pathNormalized.isEmpty()) {
                    this.scanSpec.packagePrefixAcceptReject.addToAccept("");
                    this.scanSpec.pathPrefixAcceptReject.addToAccept("");
                } else {
                    this.scanSpec.packagePrefixAcceptReject.addToAccept(String.valueOf(packageName) + ".");
                    this.scanSpec.pathPrefixAcceptReject.addToAccept(String.valueOf(pathNormalized) + "/");
                }
            }
            ++n2;
        }
        return this;
    }

    @Deprecated
    public ClassGraph whitelistPaths(String ... paths) {
        return this.acceptPaths(paths);
    }

    public ClassGraph acceptPackagesNonRecursive(String ... packageNames) {
        this.enableClassInfo();
        String[] stringArray = packageNames;
        int n = packageNames.length;
        int n2 = 0;
        while (n2 < n) {
            String packageName = stringArray[n2];
            String packageNameNormalized = AcceptReject.normalizePackageOrClassName(packageName);
            if (packageNameNormalized.contains("*")) {
                throw new IllegalArgumentException("Cannot use a glob wildcard here: " + packageNameNormalized);
            }
            this.scanSpec.packageAcceptReject.addToAccept(packageNameNormalized);
            this.scanSpec.pathAcceptReject.addToAccept(String.valueOf(AcceptReject.packageNameToPath(packageNameNormalized)) + "/");
            if (packageNameNormalized.isEmpty()) {
                this.scanSpec.pathAcceptReject.addToAccept("");
            }
            ++n2;
        }
        return this;
    }

    @Deprecated
    public ClassGraph whitelistPackagesNonRecursive(String ... packageNames) {
        return this.acceptPackagesNonRecursive(packageNames);
    }

    public ClassGraph acceptPathsNonRecursive(String ... paths) {
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            if (path.contains("*")) {
                throw new IllegalArgumentException("Cannot use a glob wildcard here: " + path);
            }
            String pathNormalized = AcceptReject.normalizePath(path);
            this.scanSpec.packageAcceptReject.addToAccept(AcceptReject.pathToPackageName(pathNormalized));
            this.scanSpec.pathAcceptReject.addToAccept(String.valueOf(pathNormalized) + "/");
            if (pathNormalized.isEmpty()) {
                this.scanSpec.pathAcceptReject.addToAccept("");
            }
            ++n2;
        }
        return this;
    }

    @Deprecated
    public ClassGraph whitelistPathsNonRecursive(String ... paths) {
        return this.acceptPathsNonRecursive(paths);
    }

    public ClassGraph rejectPackages(String ... packageNames) {
        this.enableClassInfo();
        String[] stringArray = packageNames;
        int n = packageNames.length;
        int n2 = 0;
        while (n2 < n) {
            String packageName = stringArray[n2];
            String packageNameNormalized = AcceptReject.normalizePackageOrClassName(packageName);
            if (packageNameNormalized.isEmpty()) {
                throw new IllegalArgumentException("Rejecting the root package (\"\") will cause nothing to be scanned");
            }
            this.scanSpec.packageAcceptReject.addToReject(packageNameNormalized);
            String path = AcceptReject.packageNameToPath(packageNameNormalized);
            this.scanSpec.pathAcceptReject.addToReject(String.valueOf(path) + "/");
            if (!packageNameNormalized.contains("*")) {
                this.scanSpec.packagePrefixAcceptReject.addToReject(String.valueOf(packageNameNormalized) + ".");
                this.scanSpec.pathPrefixAcceptReject.addToReject(String.valueOf(path) + "/");
            }
            ++n2;
        }
        return this;
    }

    @Deprecated
    public ClassGraph blacklistPackages(String ... packageNames) {
        return this.rejectPackages(packageNames);
    }

    public ClassGraph rejectPaths(String ... paths) {
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            String pathNormalized = AcceptReject.normalizePath(path);
            if (pathNormalized.isEmpty()) {
                throw new IllegalArgumentException("Rejecting the root package (\"\") will cause nothing to be scanned");
            }
            String packageName = AcceptReject.pathToPackageName(pathNormalized);
            this.scanSpec.packageAcceptReject.addToReject(packageName);
            this.scanSpec.pathAcceptReject.addToReject(String.valueOf(pathNormalized) + "/");
            if (!pathNormalized.contains("*")) {
                this.scanSpec.packagePrefixAcceptReject.addToReject(String.valueOf(packageName) + ".");
                this.scanSpec.pathPrefixAcceptReject.addToReject(String.valueOf(pathNormalized) + "/");
            }
            ++n2;
        }
        return this;
    }

    @Deprecated
    public ClassGraph blacklistPaths(String ... paths) {
        return this.rejectPaths(paths);
    }

    public ClassGraph acceptClasses(String ... classNames) {
        this.enableClassInfo();
        String[] stringArray = classNames;
        int n = classNames.length;
        int n2 = 0;
        while (n2 < n) {
            String className = stringArray[n2];
            String classNameNormalized = AcceptReject.normalizePackageOrClassName(className);
            this.scanSpec.classAcceptReject.addToAccept(classNameNormalized);
            this.scanSpec.classfilePathAcceptReject.addToAccept(AcceptReject.classNameToClassfilePath(classNameNormalized));
            String packageName = PackageInfo.getParentPackageName(classNameNormalized);
            this.scanSpec.classPackageAcceptReject.addToAccept(packageName);
            this.scanSpec.classPackagePathAcceptReject.addToAccept(String.valueOf(AcceptReject.packageNameToPath(packageName)) + "/");
            ++n2;
        }
        return this;
    }

    @Deprecated
    public ClassGraph whitelistClasses(String ... classNames) {
        return this.acceptClasses(classNames);
    }

    public ClassGraph rejectClasses(String ... classNames) {
        this.enableClassInfo();
        String[] stringArray = classNames;
        int n = classNames.length;
        int n2 = 0;
        while (n2 < n) {
            String className = stringArray[n2];
            String classNameNormalized = AcceptReject.normalizePackageOrClassName(className);
            this.scanSpec.classAcceptReject.addToReject(classNameNormalized);
            this.scanSpec.classfilePathAcceptReject.addToReject(AcceptReject.classNameToClassfilePath(classNameNormalized));
            ++n2;
        }
        return this;
    }

    @Deprecated
    public ClassGraph blacklistClasses(String ... classNames) {
        return this.rejectClasses(classNames);
    }

    public ClassGraph acceptJars(String ... jarLeafNames) {
        String[] stringArray = jarLeafNames;
        int n = jarLeafNames.length;
        int n2 = 0;
        while (n2 < n) {
            String jarLeafName = stringArray[n2];
            String leafName = JarUtils.leafName(jarLeafName);
            if (!leafName.equals(jarLeafName)) {
                throw new IllegalArgumentException("Can only accept jars by leafname: " + jarLeafName);
            }
            this.scanSpec.jarAcceptReject.addToAccept(leafName);
            ++n2;
        }
        return this;
    }

    @Deprecated
    public ClassGraph whitelistJars(String ... jarLeafNames) {
        return this.acceptJars(jarLeafNames);
    }

    public ClassGraph rejectJars(String ... jarLeafNames) {
        String[] stringArray = jarLeafNames;
        int n = jarLeafNames.length;
        int n2 = 0;
        while (n2 < n) {
            String jarLeafName = stringArray[n2];
            String leafName = JarUtils.leafName(jarLeafName);
            if (!leafName.equals(jarLeafName)) {
                throw new IllegalArgumentException("Can only reject jars by leafname: " + jarLeafName);
            }
            this.scanSpec.jarAcceptReject.addToReject(leafName);
            ++n2;
        }
        return this;
    }

    @Deprecated
    public ClassGraph blacklistJars(String ... jarLeafNames) {
        return this.rejectJars(jarLeafNames);
    }

    private void acceptOrRejectLibOrExtJars(boolean accept, String ... jarLeafNames) {
        if (jarLeafNames.length == 0) {
            for (String libOrExtJar : SystemJarFinder.getJreLibOrExtJars()) {
                this.acceptOrRejectLibOrExtJars(accept, JarUtils.leafName(libOrExtJar));
            }
        } else {
            String[] stringArray = jarLeafNames;
            int n = jarLeafNames.length;
            int n2 = 0;
            while (n2 < n) {
                String jarLeafName = stringArray[n2];
                String leafName = JarUtils.leafName(jarLeafName);
                if (!leafName.equals(jarLeafName)) {
                    throw new IllegalArgumentException("Can only " + (accept ? "accept" : "reject") + " jars by leafname: " + jarLeafName);
                }
                if (jarLeafName.contains("*")) {
                    Pattern pattern = AcceptReject.globToPattern(jarLeafName, true);
                    boolean found = false;
                    for (String libOrExtJarPath : SystemJarFinder.getJreLibOrExtJars()) {
                        String libOrExtJarLeafName = JarUtils.leafName(libOrExtJarPath);
                        if (!pattern.matcher(libOrExtJarLeafName).matches()) continue;
                        if (!libOrExtJarLeafName.contains("*")) {
                            this.acceptOrRejectLibOrExtJars(accept, libOrExtJarLeafName);
                        }
                        found = true;
                    }
                    if (!found && this.topLevelLog != null) {
                        this.topLevelLog.log("Could not find lib or ext jar matching wildcard: " + jarLeafName);
                    }
                } else {
                    boolean found = false;
                    for (String libOrExtJarPath : SystemJarFinder.getJreLibOrExtJars()) {
                        String libOrExtJarLeafName = JarUtils.leafName(libOrExtJarPath);
                        if (!jarLeafName.equals(libOrExtJarLeafName)) continue;
                        if (accept) {
                            this.scanSpec.libOrExtJarAcceptReject.addToAccept(jarLeafName);
                        } else {
                            this.scanSpec.libOrExtJarAcceptReject.addToReject(jarLeafName);
                        }
                        if (this.topLevelLog != null) {
                            this.topLevelLog.log(String.valueOf(accept ? "Accepting" : "Rejecting") + " lib or ext jar: " + libOrExtJarPath);
                        }
                        found = true;
                        break;
                    }
                    if (!found && this.topLevelLog != null) {
                        this.topLevelLog.log("Could not find lib or ext jar: " + jarLeafName);
                    }
                }
                ++n2;
            }
        }
    }

    public ClassGraph acceptLibOrExtJars(String ... jarLeafNames) {
        this.acceptOrRejectLibOrExtJars(true, jarLeafNames);
        return this;
    }

    @Deprecated
    public ClassGraph whitelistLibOrExtJars(String ... jarLeafNames) {
        return this.acceptLibOrExtJars(jarLeafNames);
    }

    public ClassGraph rejectLibOrExtJars(String ... jarLeafNames) {
        this.acceptOrRejectLibOrExtJars(false, jarLeafNames);
        return this;
    }

    @Deprecated
    public ClassGraph blacklistLibOrExtJars(String ... jarLeafNames) {
        return this.rejectLibOrExtJars(jarLeafNames);
    }

    public ClassGraph acceptModules(String ... moduleNames) {
        String[] stringArray = moduleNames;
        int n = moduleNames.length;
        int n2 = 0;
        while (n2 < n) {
            String moduleName = stringArray[n2];
            this.scanSpec.moduleAcceptReject.addToAccept(AcceptReject.normalizePackageOrClassName(moduleName));
            ++n2;
        }
        return this;
    }

    @Deprecated
    public ClassGraph whitelistModules(String ... moduleNames) {
        return this.acceptModules(moduleNames);
    }

    public ClassGraph rejectModules(String ... moduleNames) {
        String[] stringArray = moduleNames;
        int n = moduleNames.length;
        int n2 = 0;
        while (n2 < n) {
            String moduleName = stringArray[n2];
            this.scanSpec.moduleAcceptReject.addToReject(AcceptReject.normalizePackageOrClassName(moduleName));
            ++n2;
        }
        return this;
    }

    @Deprecated
    public ClassGraph blacklistModules(String ... moduleNames) {
        return this.rejectModules(moduleNames);
    }

    public ClassGraph acceptClasspathElementsContainingResourcePath(String ... resourcePaths) {
        String[] stringArray = resourcePaths;
        int n = resourcePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String resourcePath = stringArray[n2];
            String resourcePathNormalized = AcceptReject.normalizePath(resourcePath);
            this.scanSpec.classpathElementResourcePathAcceptReject.addToAccept(resourcePathNormalized);
            ++n2;
        }
        return this;
    }

    @Deprecated
    public ClassGraph whitelistClasspathElementsContainingResourcePath(String ... resourcePaths) {
        return this.acceptClasspathElementsContainingResourcePath(resourcePaths);
    }

    public ClassGraph rejectClasspathElementsContainingResourcePath(String ... resourcePaths) {
        String[] stringArray = resourcePaths;
        int n = resourcePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String resourcePath = stringArray[n2];
            String resourcePathNormalized = AcceptReject.normalizePath(resourcePath);
            this.scanSpec.classpathElementResourcePathAcceptReject.addToReject(resourcePathNormalized);
            ++n2;
        }
        return this;
    }

    @Deprecated
    public ClassGraph blacklistClasspathElementsContainingResourcePath(String ... resourcePaths) {
        return this.rejectClasspathElementsContainingResourcePath(resourcePaths);
    }

    public ClassGraph enableRemoteJarScanning() {
        this.scanSpec.enableURLScheme("http");
        this.scanSpec.enableURLScheme("https");
        return this;
    }

    public ClassGraph enableURLScheme(String scheme) {
        this.scanSpec.enableURLScheme(scheme);
        return this;
    }

    public ClassGraph enableSystemJarsAndModules() {
        this.enableClassInfo();
        this.scanSpec.enableSystemJarsAndModules = true;
        return this;
    }

    public ClassGraph setMaxBufferedJarRAMSize(int maxBufferedJarRAMSize) {
        this.scanSpec.maxBufferedJarRAMSize = maxBufferedJarRAMSize;
        return this;
    }

    public ClassGraph enableMemoryMapping() {
        if (VersionFinder.JAVA_MAJOR_VERSION > 23) {
            throw new IllegalArgumentException("enableMemoryMapping() is not supported on Java 24+");
        }
        this.scanSpec.enableMemoryMapping = true;
        return this;
    }

    public ClassGraph enableMultiReleaseVersions() {
        this.scanSpec.enableMultiReleaseVersions = true;
        this.scanSpec.enableClassInfo = false;
        this.scanSpec.ignoreClassVisibility = false;
        this.scanSpec.enableMethodInfo = false;
        this.scanSpec.ignoreMethodVisibility = false;
        this.scanSpec.enableFieldInfo = false;
        this.scanSpec.ignoreFieldVisibility = false;
        this.scanSpec.enableStaticFinalFieldConstantInitializerValues = false;
        this.scanSpec.enableAnnotationInfo = false;
        this.scanSpec.enableInterClassDependencies = false;
        this.scanSpec.disableRuntimeInvisibleAnnotations = false;
        this.scanSpec.enableExternalClasses = false;
        this.scanSpec.enableSystemJarsAndModules = false;
        return this;
    }

    public ClassGraph enableRealtimeLogging() {
        this.verbose();
        LogNode.logInRealtime(true);
        return this;
    }

    public void scanAsync(final ExecutorService executorService, final int numParallelTasks, final ScanResultProcessor scanResultProcessor, final FailureHandler failureHandler) {
        if (scanResultProcessor == null) {
            throw new IllegalArgumentException("scanResultProcessor cannot be null");
        }
        if (failureHandler == null) {
            throw new IllegalArgumentException("failureHandler cannot be null");
        }
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    new Scanner(true, ClassGraph.this.scanSpec, executorService, numParallelTasks, scanResultProcessor, failureHandler, ClassGraph.this.reflectionUtils, ClassGraph.this.topLevelLog).call();
                }
                catch (InterruptedException | CancellationException | ExecutionException e) {
                    failureHandler.onFailure(e);
                }
            }
        });
    }

    private Future<ScanResult> scanAsync(boolean performScan, ExecutorService executorService, int numParallelTasks) {
        try {
            return executorService.submit(new Scanner(performScan, this.scanSpec, executorService, numParallelTasks, null, null, this.reflectionUtils, this.topLevelLog));
        }
        catch (InterruptedException e) {
            return executorService.submit(new Callable<ScanResult>(){

                @Override
                public ScanResult call() throws Exception {
                    throw e;
                }
            });
        }
    }

    public Future<ScanResult> scanAsync(ExecutorService executorService, int numParallelTasks) {
        return this.scanAsync(true, executorService, numParallelTasks);
    }

    public ScanResult scan(ExecutorService executorService, int numParallelTasks) {
        try {
            ScanResult scanResult = this.scanAsync(executorService, numParallelTasks).get();
            if (scanResult == null) {
                throw new NullPointerException();
            }
            return scanResult;
        }
        catch (InterruptedException | CancellationException e) {
            throw new ClassGraphException("Scan interrupted", e);
        }
        catch (ExecutionException e) {
            throw new ClassGraphException("Uncaught exception during scan", InterruptionChecker.getCause(e));
        }
    }

    public ScanResult scan(int numThreads) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (AutoCloseableExecutorService executorService = new AutoCloseableExecutorService(numThreads);){
            return this.scan(executorService, numThreads);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public ScanResult scan() {
        return this.scan(DEFAULT_NUM_WORKER_THREADS);
    }

    ScanResult getClasspathScanResult(AutoCloseableExecutorService executorService) {
        try {
            ScanResult scanResult = this.scanAsync(false, executorService, DEFAULT_NUM_WORKER_THREADS).get();
            if (scanResult == null) {
                throw new NullPointerException();
            }
            return scanResult;
        }
        catch (InterruptedException | CancellationException e) {
            throw new ClassGraphException("Scan interrupted", e);
        }
        catch (ExecutionException e) {
            throw new ClassGraphException("Uncaught exception during scan", InterruptionChecker.getCause(e));
        }
    }

    /*
     * Loose catch block
     */
    public List<File> getClasspathFiles() {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            List<File> list;
            ScanResult scanResult;
            AutoCloseableExecutorService executorService;
            block16: {
                executorService = new AutoCloseableExecutorService(DEFAULT_NUM_WORKER_THREADS);
                scanResult = this.getClasspathScanResult(executorService);
                list = scanResult.getClasspathFiles();
                if (scanResult != null) {
                    scanResult.close();
                }
                if (executorService == null) break block16;
                executorService.close();
            }
            return list;
            {
                catch (Throwable throwable2) {
                    try {
                        if (scanResult != null) {
                            scanResult.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (executorService != null) {
                            executorService.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public String getClasspath() {
        return JarUtils.pathElementsToPathStr(this.getClasspathFiles());
    }

    /*
     * Loose catch block
     */
    public List<URI> getClasspathURIs() {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            List<URI> list;
            ScanResult scanResult;
            AutoCloseableExecutorService executorService;
            block16: {
                executorService = new AutoCloseableExecutorService(DEFAULT_NUM_WORKER_THREADS);
                scanResult = this.getClasspathScanResult(executorService);
                list = scanResult.getClasspathURIs();
                if (scanResult != null) {
                    scanResult.close();
                }
                if (executorService == null) break block16;
                executorService.close();
            }
            return list;
            {
                catch (Throwable throwable2) {
                    try {
                        if (scanResult != null) {
                            scanResult.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (executorService != null) {
                            executorService.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    public List<URL> getClasspathURLs() {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            List<URL> list;
            ScanResult scanResult;
            AutoCloseableExecutorService executorService;
            block16: {
                executorService = new AutoCloseableExecutorService(DEFAULT_NUM_WORKER_THREADS);
                scanResult = this.getClasspathScanResult(executorService);
                list = scanResult.getClasspathURLs();
                if (scanResult != null) {
                    scanResult.close();
                }
                if (executorService == null) break block16;
                executorService.close();
            }
            return list;
            {
                catch (Throwable throwable2) {
                    try {
                        if (scanResult != null) {
                            scanResult.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (executorService != null) {
                            executorService.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    public List<ModuleRef> getModules() {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            List<ModuleRef> list;
            ScanResult scanResult;
            AutoCloseableExecutorService executorService;
            block16: {
                executorService = new AutoCloseableExecutorService(DEFAULT_NUM_WORKER_THREADS);
                scanResult = this.getClasspathScanResult(executorService);
                list = scanResult.getModules();
                if (scanResult != null) {
                    scanResult.close();
                }
                if (executorService == null) break block16;
                executorService.close();
            }
            return list;
            {
                catch (Throwable throwable2) {
                    try {
                        if (scanResult != null) {
                            scanResult.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (executorService != null) {
                            executorService.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public ModulePathInfo getModulePathInfo() {
        this.scanSpec.modulePathInfo.getRuntimeInfo(this.reflectionUtils);
        return this.scanSpec.modulePathInfo;
    }

    public static enum CircumventEncapsulationMethod {
        NONE,
        NARCISSUS;

    }

    @FunctionalInterface
    public static interface ClasspathElementFilter {
        public boolean includeClasspathElement(String var1);
    }

    @FunctionalInterface
    public static interface ClasspathElementURLFilter {
        public boolean includeClasspathElement(URL var1);
    }

    @FunctionalInterface
    public static interface FailureHandler {
        public void onFailure(Throwable var1);
    }

    @FunctionalInterface
    public static interface ScanResultProcessor {
        public void processScanResult(ScanResult var1);
    }
}

