/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.plugins;

import aQute.bnd.build.Workspace;
import aQute.bnd.build.WorkspaceRepository;
import aQute.bnd.osgi.Jar;
import aQute.bnd.service.RepositoryListenerPlugin;
import aQute.bnd.service.RepositoryPlugin;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.component.annotations.Component;

@Component(service={RepositoryListenerPlugin.class})
public class RepositoriesViewRefresher
implements RepositoryListenerPlugin {
    private static final AtomicReference<State> state = new AtomicReference<State>(State.IDLE);
    private static final Map<TreeViewer, RefreshModel> viewers = new ConcurrentHashMap<TreeViewer, RefreshModel>();

    public static void refreshRepositories(final RepositoryPlugin target) {
        if (state.updateAndGet(current -> current == State.IDLE ? State.BUSY : State.REDO) == State.REDO) {
            return;
        }
        new WorkspaceJob("Updating repositories content"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                Map<Workspace, List<WorkspaceTreeViewerRefreshModel>> map = viewers.entrySet().stream().map(entry -> {
                    Workspace workspace = ((RefreshModel)entry.getValue()).getWorkspace();
                    return new WorkspaceTreeViewerRefreshModel(workspace, (TreeViewer)entry.getKey(), (RefreshModel)entry.getValue());
                }).filter(m -> m.workspace() != null).collect(Collectors.groupingBy(m -> m.workspace()));
                for (Map.Entry<Workspace, List<WorkspaceTreeViewerRefreshModel>> wsentry : map.entrySet()) {
                    HashSet<RepositoryPlugin> repos = new HashSet<RepositoryPlugin>();
                    if (target != null) {
                        repos.add(target);
                    } else {
                        for (WorkspaceTreeViewerRefreshModel m2 : wsentry.getValue()) {
                            repos.addAll(m2.model().getRepositories());
                        }
                    }
                    RepositoriesViewRefresher.ensureLoaded(monitor, repos, wsentry.getKey());
                    HashMap<WorkspaceTreeViewerRefreshModel, List<RepositoryPlugin>> entryRepos = new HashMap<WorkspaceTreeViewerRefreshModel, List<RepositoryPlugin>>();
                    for (WorkspaceTreeViewerRefreshModel entry2 : wsentry.getValue()) {
                        entryRepos.put(entry2, entry2.model().getRepositories());
                    }
                    state.set(State.BUSY);
                    for (WorkspaceTreeViewerRefreshModel entry2 : wsentry.getValue()) {
                        TreeViewer viewer = entry2.viewer();
                        viewer.getControl().getDisplay().asyncExec(() -> {
                            TreePath[] expandedTreePaths = viewer.getExpandedTreePaths();
                            viewer.setInput(entryRepos.get(entry2));
                            if (expandedTreePaths != null && expandedTreePaths.length > 0) {
                                viewer.setExpandedTreePaths(expandedTreePaths);
                            }
                        });
                    }
                    if (state.getAndSet(State.IDLE) != State.REDO) continue;
                    RepositoriesViewRefresher.refreshRepositories(null);
                }
                return Status.OK_STATUS;
            }
        }.schedule(1000L);
    }

    private static IStatus ensureLoaded(IProgressMonitor monitor, Collection<RepositoryPlugin> repos, Workspace ws) {
        int n = 0;
        try {
            WorkspaceRepository workspaceRepo = ws.getWorkspaceRepository();
            for (RepositoryPlugin repo : repos) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                monitor.beginTask(repo.getName(), n++);
                if (repo != workspaceRepo) {
                    repo.list(null);
                    continue;
                }
                try {
                    ws.readLocked(() -> RepositoriesViewRefresher.lambda$1((RepositoryPlugin)workspaceRepo), () -> ((IProgressMonitor)monitor).isCanceled());
                }
                catch (InterruptedException | TimeoutException e) {
                    return Status.error((String)("Unable to acquire lock to refresh repository " + repo.getName()), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            return Status.error((String)"Exception refreshing repositories", (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public static void addViewer(TreeViewer viewer, RefreshModel model) {
        viewers.put(viewer, model);
        RepositoriesViewRefresher.refreshViewer(viewer, model);
    }

    public static void refreshViewer(final TreeViewer viewer, final RefreshModel model) {
        new Job("Updating repositories"){

            protected IStatus run(IProgressMonitor monitor) {
                List<RepositoryPlugin> repositories = model.getRepositories();
                Display.getDefault().asyncExec(() -> viewer.setInput((Object)repositories));
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public static void removeViewer(TreeViewer viewer) {
        viewers.remove(viewer);
    }

    public void bundleAdded(RepositoryPlugin repository, Jar jar, File file) {
        RepositoriesViewRefresher.refreshRepositories(repository);
    }

    public void bundleRemoved(RepositoryPlugin repository, Jar jar, File file) {
        RepositoriesViewRefresher.refreshRepositories(repository);
    }

    public void repositoryRefreshed(RepositoryPlugin repository) {
        RepositoriesViewRefresher.refreshRepositories(repository);
    }

    public void repositoriesRefreshed() {
        RepositoriesViewRefresher.refreshRepositories(null);
    }

    private static /* synthetic */ List lambda$1(RepositoryPlugin repositoryPlugin) throws Exception {
        return repositoryPlugin.list(null);
    }

    public static interface RefreshModel {
        public List<RepositoryPlugin> getRepositories();

        public Workspace getWorkspace();
    }

    static enum State {
        IDLE,
        BUSY,
        REDO;

    }

    private record WorkspaceTreeViewerRefreshModel(Workspace workspace, TreeViewer viewer, RefreshModel model) {
    }
}

