/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.query;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sirius.business.internal.session.parser.RepresentationsFileSaxParser;
import org.eclipse.sirius.common.tools.api.util.WorkspaceUtil;
import org.eclipse.sirius.tools.api.Messages;

public class SiriusProjectQuery {
    public static final String ZERO_REPRESENTATIONS_FILE_FOUND_IN = "0";
    public static final String A_MODELING_PROJECT_MUST_CONTAIN_ONLY_ONE = "*";
    private final IProject project;

    public SiriusProjectQuery(IProject project) {
        this.project = project;
    }

    public List<IFile> getRepresentationFiles() {
        return WorkspaceUtil.getFilesFromWorkspace(Collections.singleton(this.project), (String)"aird");
    }

    public URI computeMainRepresentationsFileURI() throws IllegalArgumentException {
        URI result = null;
        List<URI> notReferencedURIs = this.getMainAirdURIs();
        if (notReferencedURIs.isEmpty()) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.ModelingProjectQuery_mustContainOneRepFileMsg, this.project.getName()), new Throwable(ZERO_REPRESENTATIONS_FILE_FOUND_IN));
        }
        if (notReferencedURIs.size() != 1) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.ModelingProjectQuery_severalRepresentationsFiles, notReferencedURIs.size(), this.project.getName(), this.getFragments(notReferencedURIs)), new Throwable(A_MODELING_PROJECT_MUST_CONTAIN_ONLY_ONE));
        }
        result = notReferencedURIs.get(0);
        return result;
    }

    public List<URI> getMainAirdURIs() {
        return new ArrayList<URI>(this.getMainAirdReferencedURIs().keySet());
    }

    public Map<URI, Set<URI>> getMainAirdReferencedURIs() {
        List<IFile> sessionFiles = this.getRepresentationFiles();
        LinkedHashMap<URI, Set<URI>> references = new LinkedHashMap<URI, Set<URI>>(sessionFiles.size());
        for (IFile sessionFile : sessionFiles) {
            RepresentationsFileSaxParser sessionSaxParser = new RepresentationsFileSaxParser(sessionFile);
            sessionSaxParser.analyze();
            references.put(sessionSaxParser.getRepresentationsFileURI(), sessionSaxParser.getReferencedAnalysis());
        }
        ArrayList<URI> notReferencedURIs = new ArrayList<URI>();
        ArrayList keys = new ArrayList(references.keySet());
        for (URI uri2 : references.keySet()) {
            boolean referenced = false;
            for (URI uri22 : keys) {
                if (!((Set)references.get(uri22)).contains(uri2)) continue;
                referenced = true;
                break;
            }
            if (referenced) continue;
            notReferencedURIs.add(uri2);
        }
        Map<URI, Set<URI>> mainAirdWithReferencedAnalysisURIs = notReferencedURIs.stream().collect(Collectors.toMap(uri -> uri, uri -> (Set)references.get(uri)));
        return mainAirdWithReferencedAnalysisURIs;
    }

    private String getFragments(List<URI> uris) {
        StringBuffer result = new StringBuffer();
        Iterator<URI> iterator = uris.iterator();
        while (iterator.hasNext()) {
            URI uri = iterator.next();
            if (!iterator.hasNext()) {
                result.delete(result.length() - 2, result.length());
                result.append(Messages.ModelingProjectQuery_and);
            }
            result.append(uri.lastSegment());
            if (!iterator.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }
}

