/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.ui.preferences;

import java.text.MessageFormat;
import org.eclipse.cdt.codan.core.CodanRuntime;
import org.eclipse.cdt.codan.core.model.CodanSeverity;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.model.IProblemCategory;
import org.eclipse.cdt.codan.core.model.IProblemElement;
import org.eclipse.cdt.codan.core.model.IProblemProfile;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.codan.core.param.IProblemPreference;
import org.eclipse.cdt.codan.core.param.LaunchModeProblemPreference;
import org.eclipse.cdt.codan.core.param.RootProblemPreference;
import org.eclipse.cdt.codan.internal.core.CodanPreferencesLoader;
import org.eclipse.cdt.codan.internal.ui.CodanUIActivator;
import org.eclipse.cdt.codan.internal.ui.CodanUIMessages;
import org.eclipse.cdt.codan.internal.ui.preferences.CheckedTreeEditor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class ProblemsTreeEditor
extends CheckedTreeEditor {
    private static final String EMPTY_STRING = "";
    private static final String SINGLE_PLACEHOLDER_ONLY = "{0}";
    private CodanPreferencesLoader codanPreferencesLoader = new CodanPreferencesLoader();

    public ProblemsTreeEditor() {
    }

    @Override
    public void checkStateChanged(CheckStateChangedEvent event) {
        Object element = event.getElement();
        if (element instanceof IProblemWorkingCopy) {
            ((IProblemWorkingCopy)element).setEnabled(event.getChecked());
        } else if (element instanceof IProblemCategory) {
            IProblemCategory cat = (IProblemCategory)element;
            IProblemElement[] children = cat.getChildren();
            int i = 0;
            while (i < children.length) {
                IProblemElement pe = children[i];
                this.checkStateChanged(new CheckStateChangedEvent((ICheckable)this.getTreeViewer(), (Object)pe, event.getChecked()));
                ++i;
            }
        }
        this.getTreeViewer().refresh();
    }

    public ProblemsTreeEditor(Composite parent, IProblemProfile profile) {
        super("problems", CodanUIMessages.ProblemsTreeEditor_Problems, parent);
        this.setEmptySelectionAllowed(true);
        this.getTreeViewer().getTree().setHeaderVisible(true);
        this.getTreeViewer().setContentProvider((IContentProvider)new ProblemsContentProvider());
        this.getTreeViewer().setCheckStateProvider((ICheckStateProvider)new ProblemsCheckStateProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.getTreeViewer(), (int)1);
        TreeViewerColumn column1 = new TreeViewerColumn((TreeViewer)this.getTreeViewer(), 0);
        column1.getColumn().setWidth(300);
        column1.getColumn().setText(CodanUIMessages.ProblemsTreeEditor_NameColumn);
        column1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IProblem) {
                    IProblem p = (IProblem)element;
                    return p.getName();
                }
                if (element instanceof IProblemCategory) {
                    IProblemCategory p = (IProblemCategory)element;
                    return p.getName();
                }
                return null;
            }

            public boolean useNativeToolTip(Object object) {
                return true;
            }

            public String getToolTipText(Object element) {
                if (element instanceof IProblem) {
                    IProblem p = (IProblem)element;
                    String sampleMessage = ProblemsTreeEditor.getSampleMessage(p);
                    int wrapLen = sampleMessage.length();
                    if (wrapLen < 60) {
                        wrapLen = 60;
                    }
                    if (wrapLen > 100) {
                        wrapLen = 100;
                    }
                    Object toolTip = ProblemsTreeEditor.EMPTY_STRING;
                    String description = p.getDescription();
                    if (description != null) {
                        toolTip = this.wrapText(description, wrapLen);
                        toolTip = (String)toolTip + "\n\n";
                    }
                    toolTip = (String)toolTip + CodanUIMessages.ProblemsTreeEditor_ToolTip;
                    toolTip = (String)toolTip + "\n  ";
                    toolTip = (String)toolTip + this.wrapText(sampleMessage, wrapLen);
                    return toolTip;
                }
                return super.getToolTipText(element);
            }

            private String wrapText(String description, int i) {
                Object result = ProblemsTreeEditor.EMPTY_STRING;
                while (description.length() > i) {
                    int k = description.lastIndexOf(32, i);
                    if (k < 0) {
                        k = i;
                    }
                    result = (String)result + description.substring(0, k);
                    result = (String)result + "\n";
                    description = description.substring(k);
                }
                return (String)result + description;
            }
        });
        TreeViewerColumn column2 = new TreeViewerColumn((TreeViewer)this.getTreeViewer(), 0);
        column2.getColumn().setWidth(100);
        column2.getColumn().setText(CodanUIMessages.ProblemsTreeEditor_SeverityColumn);
        column2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof IProblem) {
                    IProblem p = (IProblem)element;
                    switch (p.getSeverity().intValue()) {
                        case 0: {
                            return CodanUIActivator.getDefault().getImage("icons/blue_bug.gif");
                        }
                        case 1: {
                            return CodanUIActivator.getDefault().getImage("icons/yellow_bug.gif");
                        }
                        case 2: {
                            return CodanUIActivator.getDefault().getImage("icons/red_bug.gif");
                        }
                    }
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof IProblem) {
                    IProblem p = (IProblem)element;
                    return p.getSeverity().toTranslatableString();
                }
                return null;
            }
        });
        column2.setEditingSupport(new EditingSupport((ColumnViewer)this.getTreeViewer()){

            protected boolean canEdit(Object element) {
                return element instanceof IProblem;
            }

            protected CellEditor getCellEditor(Object element) {
                return new ComboBoxCellEditor((Composite)ProblemsTreeEditor.this.getTreeViewer().getTree(), CodanSeverity.stringValues(), 8);
            }

            protected Object getValue(Object element) {
                return ((IProblem)element).getSeverity().intValue();
            }

            protected void setValue(Object element, Object value) {
                int index = (Integer)value;
                CodanSeverity val = CodanSeverity.values()[index];
                ((IProblemWorkingCopy)element).setSeverity(val);
                ProblemsTreeEditor.this.getTreeViewer().update(element, null);
            }
        });
        this.getTreeViewer().setAutoExpandLevel(2);
        this.codanPreferencesLoader.setInput(profile);
        this.getViewer().setInput((Object)profile);
    }

    @Override
    protected void doLoad() {
        if (this.getTreeControl() != null) {
            IProblem[] probs = this.codanPreferencesLoader.getProblems();
            int i = 0;
            while (i < probs.length) {
                String id = probs[i].getId();
                String s = this.getPreferenceStore().getString(id);
                if (s == null || s.length() == 0) {
                    s = this.codanPreferencesLoader.getProperty(id);
                }
                this.codanPreferencesLoader.setProperty(id, s);
                ++i;
            }
            this.getViewer().setInput((Object)this.codanPreferencesLoader.getInput());
        }
    }

    @Override
    protected void doLoadDefault() {
        if (this.getTreeControl() != null) {
            CodanPreferencesLoader defaultPreferences = new CodanPreferencesLoader(CodanRuntime.getInstance().getCheckersRegistry().getDefaultProfile());
            IProblem[] probs = this.codanPreferencesLoader.getProblems();
            int i = 0;
            while (i < probs.length) {
                String id = probs[i].getId();
                String s = this.getPreferenceStore().getDefaultString(id);
                if (s == null || s.length() == 0) {
                    s = defaultPreferences.getProperty(id);
                }
                this.codanPreferencesLoader.setProperty(id, s);
                ++i;
            }
            this.getViewer().setInput((Object)this.codanPreferencesLoader.getInput());
            this.setPresentsDefaultValue(true);
        }
    }

    @Override
    protected void doStore() {
        this.codanPreferencesLoader.setInput((IProblemProfile)this.getViewer().getInput());
        IProblem[] probs = this.codanPreferencesLoader.getProblems();
        int i = 0;
        while (i < probs.length) {
            String id = probs[i].getId();
            String s = this.codanPreferencesLoader.getProperty(id);
            this.getPreferenceStore().setValue(id, s);
            String params = this.codanPreferencesLoader.getPreferencesString(id);
            if (params != null) {
                this.getPreferenceStore().setValue(this.codanPreferencesLoader.getPreferencesKey(id), params);
            }
            ++i;
        }
    }

    @Override
    protected Object modelFromString(String s) {
        return this.codanPreferencesLoader.getInput();
    }

    @Override
    protected String modelToString(Object model) {
        return EMPTY_STRING;
    }

    public static String getSampleMessage(IProblem problem) {
        String messagePattern = problem.getMessagePattern();
        String message = CodanUIMessages.CodanPreferencePage_NoInfo;
        if (SINGLE_PLACEHOLDER_ONLY.equals(messagePattern)) {
            message = EMPTY_STRING;
        } else if (messagePattern != null) {
            message = MessageFormat.format(messagePattern, "X", "Y", "Z");
        }
        return message;
    }

    @Override
    protected CheckboxTreeViewer doCreateTreeViewer(Composite parent, int style) {
        PatternFilter filter = new PatternFilter();
        filter.setIncludeLeadingWildcard(true);
        FilteredTree filteredTree = new FilteredTree(parent, 68354, filter, true){

            protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
                return new CheckboxTreeViewer(parent, style);
            }
        };
        return (CheckboxTreeViewer)filteredTree.getViewer();
    }

    class ProblemsCheckStateProvider
    implements ICheckStateProvider {
        ProblemsCheckStateProvider() {
        }

        public boolean isChecked(Object element) {
            if (element instanceof IProblem) {
                IProblem p = (IProblem)element;
                return p.isEnabled();
            }
            if (element instanceof IProblemCategory) {
                IProblemCategory p = (IProblemCategory)element;
                IProblemElement[] children = p.getChildren();
                int i = 0;
                while (i < children.length) {
                    IProblemElement object = children[i];
                    if (this.isChecked(object)) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        public boolean isGrayed(Object element) {
            if (element instanceof IProblem) {
                IProblem p = (IProblem)element;
                IProblemPreference preference = p.getPreference();
                if (preference instanceof RootProblemPreference) {
                    LaunchModeProblemPreference pref = ((RootProblemPreference)preference).getLaunchModePreference();
                    if (pref == null) {
                        return false;
                    }
                    boolean enabled = p.isEnabled();
                    boolean match = pref.isAllEnabled();
                    if (enabled && match) {
                        return false;
                    }
                    return enabled || !pref.isAllDisabled();
                }
                return false;
            }
            if (element instanceof IProblemCategory) {
                IProblemCategory p = (IProblemCategory)element;
                IProblemElement[] children = p.getChildren();
                boolean all_checked = true;
                boolean all_unchecked = true;
                int i = 0;
                while (i < children.length) {
                    IProblemElement object = children[i];
                    if (this.isChecked(object)) {
                        all_unchecked = false;
                    } else {
                        all_checked = false;
                    }
                    ++i;
                }
                return !all_checked && !all_unchecked;
            }
            return false;
        }
    }

    class ProblemsContentProvider
    implements ITreeContentProvider {
        ProblemsContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Object[]) {
                return (Object[])parentElement;
            }
            if (parentElement instanceof IProblemCategory) {
                return ((IProblemCategory)parentElement).getChildren();
            }
            if (parentElement instanceof IProblemProfile) {
                return ((IProblemProfile)parentElement).getRoot().getChildren();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }
    }
}

