/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SlowImpactsEnum;
import org.apache.lucene.search.DocAndFloatFeatureBuffer;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.ImpactsDISI;
import org.apache.lucene.search.MaxScoreCache;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.LongsRef;

public final class TermScorer
extends Scorer {
    private final PostingsEnum postingsEnum;
    private final DocIdSetIterator iterator;
    private final Similarity.SimScorer scorer;
    private final Similarity.BulkSimScorer bulkScorer;
    private final NumericDocValues norms;
    private final ImpactsDISI impactsDisi;
    private final MaxScoreCache maxScoreCache;
    private long[] normValues = LongsRef.EMPTY_LONGS;

    public TermScorer(PostingsEnum postingsEnum, Similarity.SimScorer scorer, NumericDocValues norms) {
        this.postingsEnum = postingsEnum;
        this.iterator = this.postingsEnum;
        SlowImpactsEnum impactsEnum = new SlowImpactsEnum(postingsEnum);
        this.maxScoreCache = new MaxScoreCache(impactsEnum, scorer);
        this.impactsDisi = null;
        this.scorer = scorer;
        this.norms = norms;
        this.bulkScorer = scorer.asBulkSimScorer();
    }

    public TermScorer(ImpactsEnum impactsEnum, Similarity.SimScorer scorer, NumericDocValues norms, boolean topLevelScoringClause) {
        this.postingsEnum = impactsEnum;
        this.maxScoreCache = new MaxScoreCache(impactsEnum, scorer);
        if (topLevelScoringClause) {
            this.impactsDisi = new ImpactsDISI(impactsEnum, this.maxScoreCache);
            this.iterator = this.impactsDisi;
        } else {
            this.impactsDisi = null;
            this.iterator = impactsEnum;
        }
        this.scorer = scorer;
        this.norms = norms;
        this.bulkScorer = scorer.asBulkSimScorer();
    }

    @Override
    public int docID() {
        return this.postingsEnum.docID();
    }

    public final int freq() throws IOException {
        return this.postingsEnum.freq();
    }

    @Override
    public DocIdSetIterator iterator() {
        return this.iterator;
    }

    @Override
    public float score() throws IOException {
        PostingsEnum postingsEnum = this.postingsEnum;
        NumericDocValues norms = this.norms;
        long norm = 1L;
        if (norms != null && norms.advanceExact(postingsEnum.docID())) {
            norm = norms.longValue();
        }
        return this.scorer.score(postingsEnum.freq(), norm);
    }

    @Override
    public float smoothingScore(int docId) throws IOException {
        long norm = 1L;
        if (this.norms != null && this.norms.advanceExact(docId)) {
            norm = this.norms.longValue();
        }
        return this.scorer.score(0.0f, norm);
    }

    @Override
    public int advanceShallow(int target) throws IOException {
        return this.maxScoreCache.advanceShallow(target);
    }

    @Override
    public float getMaxScore(int upTo) throws IOException {
        return this.maxScoreCache.getMaxScore(upTo);
    }

    @Override
    public void setMinCompetitiveScore(float minScore) {
        if (this.impactsDisi != null) {
            this.impactsDisi.setMinCompetitiveScore(minScore);
        }
    }

    @Override
    public void nextDocsAndScores(int upTo, Bits liveDocs, DocAndFloatFeatureBuffer buffer) throws IOException {
        int size;
        do {
            if (this.impactsDisi != null) {
                this.impactsDisi.ensureCompetitive();
            }
            this.postingsEnum.nextPostings(upTo, buffer);
            if (liveDocs == null || buffer.size == 0) break;
            buffer.apply(liveDocs);
        } while (buffer.size == 0);
        if (this.normValues.length < (size = buffer.size)) {
            this.normValues = new long[ArrayUtil.oversize(size, 8)];
            if (this.norms == null) {
                Arrays.fill(this.normValues, 1L);
            }
        }
        if (this.norms != null) {
            for (int i = 0; i < size; ++i) {
                this.normValues[i] = this.norms.advanceExact(buffer.docs[i]) ? this.norms.longValue() : 1L;
            }
        }
        this.bulkScorer.score(buffer.size, buffer.features, this.normValues, buffer.features);
    }
}

