/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.base.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.api.agreements.GlobalAgreement;
import org.eclipse.passage.lic.api.conditions.ConditionPack;
import org.eclipse.passage.lic.api.conditions.evaluation.Emission;
import org.eclipse.passage.lic.api.conditions.evaluation.Permission;
import org.eclipse.passage.lic.api.conditions.evaluation.PermissionEmittingService;
import org.eclipse.passage.lic.api.registry.Registry;
import org.eclipse.passage.lic.api.registry.StringServiceId;
import org.eclipse.passage.lic.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.base.SumOfCollections;

public final class Permissions
implements Supplier<ServiceInvocationResult<AppliedLicenses>> {
    private final Registry<StringServiceId, PermissionEmittingService> registry;
    private final Collection<ConditionPack> conditions;
    private final LicensedProduct product;

    public Permissions(Registry<StringServiceId, PermissionEmittingService> registry, Collection<ConditionPack> conditions, LicensedProduct product) {
        this.registry = registry;
        this.conditions = conditions;
        this.product = product;
    }

    @Override
    public ServiceInvocationResult<AppliedLicenses> get() {
        BaseServiceInvocationResult<Collection<Permission>> permissions = this.permissions();
        return new BaseServiceInvocationResult<AppliedLicenses>(permissions.diagnostic(), new AppliedLicenses(permissions.data().get(), this.agreements()));
    }

    private BaseServiceInvocationResult<Collection<Permission>> permissions() {
        return this.registry.services().stream().map(service -> service.emit(this.conditions, this.product)).reduce(new BaseServiceInvocationResult.Sum(new SumOfCollections())).map(r -> new BaseServiceInvocationResult<Collection<Permission>>(r.diagnostic(), this.allPermissions(r.data()))).orElse(new BaseServiceInvocationResult(Collections.emptyList()));
    }

    private Collection<Permission> allPermissions(Optional<Collection<Emission>> emissions) {
        if (!emissions.isPresent()) {
            return Collections.emptyList();
        }
        return emissions.get().stream().reduce(new ArrayList(), new SumEmissionsToData(), new SumOfCollections());
    }

    private Collection<GlobalAgreement> agreements() {
        return this.conditions.stream().map(ConditionPack::agreements).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static final class AppliedLicenses {
        private final Collection<Permission> permissions;
        private final Collection<GlobalAgreement> agreements;

        AppliedLicenses() {
            this(Collections.emptyList(), Collections.emptyList());
        }

        AppliedLicenses(Collection<Permission> permissions, Collection<GlobalAgreement> agreements) {
            this.permissions = permissions;
            this.agreements = agreements;
        }

        Collection<Permission> permissions() {
            return this.permissions;
        }

        Collection<GlobalAgreement> agreements() {
            return this.agreements;
        }
    }

    private static final class SumEmissionsToData
    implements BiFunction<Collection<Permission>, Emission, Collection<Permission>> {
        private SumEmissionsToData() {
        }

        @Override
        public Collection<Permission> apply(Collection<Permission> sum, Emission emission) {
            sum.addAll(emission.permissions());
            return sum;
        }
    }
}

