/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.selectionactions;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.Region;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ASTNodes;
import org.eclipse.php.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.corext.dom.SelectionAnalyzer;
import org.eclipse.php.internal.core.documentModel.dom.ElementImplForPHP;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.editor.selectionactions.Messages;
import org.eclipse.php.ui.editor.SharedASTProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;

final class StructureSelectUtil {
    StructureSelectUtil() {
    }

    static ISourceModule getSourceModule(ExecutionEvent event) {
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        ITextEditor textEditor = null;
        if (editor instanceof ITextEditor) {
            textEditor = (ITextEditor)editor;
        } else {
            Object o = editor.getAdapter(ITextEditor.class);
            if (o != null) {
                textEditor = (ITextEditor)o;
            }
        }
        if (textEditor != null) {
            ISourceModule sourceModule;
            block7: {
                sourceModule = EditorUtility.getEditorInputModelElement((IEditorPart)textEditor, (boolean)false);
                ISourceRange sourceRange = sourceModule.getSourceRange();
                if (sourceRange != null && sourceRange.getLength() != 0) break block7;
                MessageDialog.openInformation((Shell)textEditor.getEditorSite().getShell(), (String)Messages.StructureSelect_error_title, (String)Messages.StructureSelect_error_message);
                return null;
            }
            try {
                return sourceModule;
            }
            catch (ModelException e) {
                Logger.logException(e);
            }
        }
        return null;
    }

    static boolean isPHP(IndexedRegion indexedRegion) {
        return indexedRegion instanceof ElementImplForPHP && ((ElementImplForPHP)indexedRegion).isPHPTag();
    }

    static Program getAST(ISourceModule sourceModule) throws ModelException, IOException {
        return SharedASTProvider.getAST(sourceModule, SharedASTProvider.WAIT_YES, null);
    }

    static Region getLastCoveringNodeRange(Region oldSourceRange, ISourceReference sr, SelectionAnalyzer selAnalyzer) throws ModelException {
        if (selAnalyzer.getLastCoveringNode() == null) {
            return oldSourceRange;
        }
        return StructureSelectUtil.getSelectedNodeSourceRange(sr, selAnalyzer.getLastCoveringNode());
    }

    static Region getSelectedNodeSourceRange(ISourceReference sr, ASTNode nodeToSelect) throws ModelException {
        int offset = nodeToSelect.getStart();
        int end = Math.min(sr.getSourceRange().getLength(), nodeToSelect.getStart() + nodeToSelect.getLength() - 1);
        return StructureSelectUtil.createSourceRange(offset, end);
    }

    static Region createSourceRange(int start, int end) {
        return new Region(start, end - start + 1);
    }

    static ASTNode[] getSiblingNodes(ASTNode node) {
        ASTNode parent = node.getParent();
        StructuralPropertyDescriptor locationInParent = node.getLocationInParent();
        if (locationInParent.isChildListProperty()) {
            List siblings = ASTNodes.getChildListProperty((ASTNode)parent, (ChildListPropertyDescriptor)((ChildListPropertyDescriptor)locationInParent));
            return siblings.toArray(new ASTNode[siblings.size()]);
        }
        return null;
    }

    static int findIndex(Object[] array, Object o) {
        int i = 0;
        while (i < array.length) {
            Object object = array[i];
            if (object == o) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

