/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xerces.xmlmodel;

import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.parsers.XIncludeAwareParserConfiguration;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics.LSPErrorReporterForXML;
import org.eclipse.lemminx.extensions.xerces.xmlmodel.XMLModelHandler;

public class XMLModelAwareParserConfiguration
extends XIncludeAwareParserConfiguration {
    public static final String ERROR_REPORTER_FOR_GRAMMAR = "http://apache.org/xml/properties/internal/error-reporter-grammar";
    protected boolean xmlModelEnabled = true;
    private XMLModelHandler xmlModelHandler;
    private XMLErrorReporter reporterForGrammar;

    public XMLModelAwareParserConfiguration() {
        this((SymbolTable)null, (XMLGrammarPool)null, (LSPErrorReporterForXML)null);
    }

    public XMLModelAwareParserConfiguration(SymbolTable symbolTable) {
        this(symbolTable, (XMLGrammarPool)null, (LSPErrorReporterForXML)null);
    }

    public XMLModelAwareParserConfiguration(SymbolTable symbolTable, XMLGrammarPool grammarPool) {
        this(symbolTable, grammarPool, (LSPErrorReporterForXML)null);
    }

    public XMLModelAwareParserConfiguration(SymbolTable symbolTable, XMLGrammarPool grammarPool, LSPErrorReporterForXML reporterForGrammar) {
        super(symbolTable, grammarPool);
        this.reporterForGrammar = reporterForGrammar;
    }

    @Override
    protected void configurePipeline() {
        super.configurePipeline();
        this.configureXMLModelPipeline();
    }

    @Override
    protected void configureXML11Pipeline() {
        super.configureXML11Pipeline();
        this.configureXMLModelPipeline();
    }

    private void configureXMLModelPipeline() {
        if (this.xmlModelEnabled) {
            if (this.xmlModelHandler == null) {
                this.xmlModelHandler = new XMLModelHandler();
                this.addCommonComponent(this.xmlModelHandler);
                this.xmlModelHandler.reset(this);
            }
            XMLDocumentSource prev = null;
            if (this.fFeatures.get("http://apache.org/xml/features/validation/schema") == Boolean.TRUE) {
                prev = this.fSchemaValidator.getDocumentSource();
            } else {
                prev = this.fLastComponent;
                this.fLastComponent = this.xmlModelHandler;
            }
            XMLDocumentHandler next = prev.getDocumentHandler();
            prev.setDocumentHandler(this.xmlModelHandler);
            this.xmlModelHandler.setDocumentSource(prev);
            if (next != null) {
                this.xmlModelHandler.setDocumentHandler(next);
                next.setDocumentSource(this.xmlModelHandler);
            }
        }
    }

    @Override
    protected void checkProperty(String propertyId) throws XMLConfigurationException {
        if ("http://apache.org/xml/properties/dtd/external-doctype".equals(propertyId)) {
            return;
        }
        if (ERROR_REPORTER_FOR_GRAMMAR.equals(propertyId)) {
            return;
        }
        super.checkProperty(propertyId);
    }

    @Override
    public Object getProperty(String propertyId) throws XMLConfigurationException {
        if (ERROR_REPORTER_FOR_GRAMMAR.equals(propertyId)) {
            return this.reporterForGrammar;
        }
        return super.getProperty(propertyId);
    }

    public XMLErrorReporter getReporterForGrammar() {
        return this.reporterForGrammar;
    }
}

