/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.php.debug.core.debugger.handlers.IDebugMessageHandler;
import org.eclipse.php.debug.core.debugger.messages.IDebugMessage;
import org.eclipse.php.internal.debug.core.zend.debugger.RemoteDebugger;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.IniAlteredNotification;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;

public class IniAlteredNotificationHandler
implements IDebugMessageHandler {
    private static final String INCLUDE_PATH = "include_path";

    @Override
    public void handle(IDebugMessage message, PHPDebugTarget debugTarget) {
        IniAlteredNotification iniMessage = (IniAlteredNotification)message;
        if (INCLUDE_PATH.equals(iniMessage.getName())) {
            List<String> oldValues = this.parseEntries(iniMessage.getOldValue());
            List<String> newValues = this.parseEntries(iniMessage.getNewValue());
            for (String oldValue : oldValues) {
                if (!newValues.contains(oldValue)) continue;
                newValues.remove(oldValue);
            }
            if (newValues.size() > 0) {
                RemoteDebugger debugger = (RemoteDebugger)debugTarget.getRemoteDebugger();
                ArrayList<IProject> toAddFiles = new ArrayList<IProject>();
                for (String newValue : newValues) {
                    IProject project;
                    String localPath = debugger.convertToLocalFilename(newValue, debugger.getCurrentWorkingDirectory(), debugTarget.getLastFileName());
                    IResource member = ResourcesPlugin.getWorkspace().getRoot().findMember(localPath);
                    if (member == null || (project = member.getProject()) == null || project.equals((Object)debugTarget.getProject())) continue;
                    toAddFiles.add(project);
                }
                if (toAddFiles.size() > 0) {
                    debugTarget.addBreakpointFiles(toAddFiles.toArray(new IProject[toAddFiles.size()]));
                }
            }
        }
    }

    private List<String> parseEntries(String oldValue) {
        if (oldValue == null || oldValue.trim().length() == 0) {
            return new ArrayList<String>();
        }
        String separator = ":";
        int semicolonIndex = oldValue.indexOf(59);
        if (semicolonIndex != -1) {
            separator = ";";
        }
        return new ArrayList<String>(Arrays.asList(oldValue.split(separator)));
    }
}

