/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.net4j.buffer;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.text.MessageFormat;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.internal.net4j.buffer.BufferProvider;
import org.eclipse.internal.net4j.bundle.OM;
import org.eclipse.net4j.buffer.IBuffer;
import org.eclipse.net4j.buffer.IBufferPool;
import org.eclipse.net4j.buffer.IBufferProvider;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.ref.CleanableReferenceQueue;
import org.eclipse.spi.net4j.InternalBuffer;

public class BufferPool
extends BufferProvider
implements IBufferPool.Introspection {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_BUFFER, BufferPool.class);
    private final IBufferProvider provider;
    private int pooledBuffers;
    @ReflectUtil.ExcludeFromDump
    private final Queue<BufferRef> buffers = new ConcurrentLinkedQueue<BufferRef>();
    @ReflectUtil.ExcludeFromDump
    private final CleanableReferenceQueue<IBuffer> referenceQueue = new CleanableReferenceQueue<IBuffer>(){

        protected Reference<IBuffer> createReference(IBuffer buffer) {
            return new BufferRef(buffer, (ReferenceQueue<IBuffer>)((Object)this));
        }

        protected void cleanReference(Reference<? extends IBuffer> reference) {
            if (BufferPool.this.buffers.remove(reference)) {
                BufferPool bufferPool = BufferPool.this;
                bufferPool.pooledBuffers = bufferPool.pooledBuffers - 1;
                if (TRACER.isEnabled()) {
                    TRACER.trace("Collected buffer");
                }
            }
        }
    };

    public BufferPool(IBufferProvider provider) {
        super(provider.getBufferCapacity());
        this.provider = provider;
    }

    public IBufferProvider getProvider() {
        return this.provider;
    }

    public ReferenceQueue<IBuffer> getReferenceQueue() {
        return this.referenceQueue;
    }

    @Override
    public int getPooledBuffers() {
        return this.pooledBuffers;
    }

    @Override
    public boolean evictOne() {
        BufferRef bufferRef;
        IBuffer buffer;
        do {
            if ((bufferRef = this.buffers.poll()) != null) continue;
            return false;
        } while ((buffer = (IBuffer)bufferRef.get()) == null);
        if (TRACER.isEnabled()) {
            TRACER.trace("Evicting " + buffer);
        }
        this.provider.retainBuffer(buffer);
        --this.pooledBuffers;
        return true;
    }

    @Override
    public int evict(int survivors) {
        int evictedBuffers = 0;
        while (this.pooledBuffers > survivors) {
            if (!this.evictOne()) break;
            ++evictedBuffers;
        }
        return evictedBuffers;
    }

    @Override
    public String toString() {
        return MessageFormat.format("BufferPool[{0}]", this.getBufferCapacity());
    }

    protected BufferRef createBufferRef(IBuffer buffer) {
        return new BufferRef(buffer, (ReferenceQueue<IBuffer>)this.referenceQueue);
    }

    @Override
    protected IBuffer doProvideBuffer() {
        IBuffer buffer = null;
        BufferRef bufferRef = this.buffers.poll();
        if (bufferRef != null) {
            buffer = (IBuffer)bufferRef.get();
        }
        if (buffer == null) {
            buffer = this.provider.provideBuffer();
            ((InternalBuffer)buffer).setBufferProvider(this);
        } else {
            --this.pooledBuffers;
        }
        buffer.clear();
        if (TRACER.isEnabled()) {
            TRACER.trace("Obtained " + buffer);
        }
        return buffer;
    }

    @Override
    protected void doRetainBuffer(IBuffer buffer) {
        if (buffer.getCapacity() != this.getBufferCapacity()) {
            throw new IllegalArgumentException("buffer.getCapacity() != getBufferCapacity()");
        }
        if (TRACER.isEnabled()) {
            TRACER.trace("Retaining " + buffer);
        }
        BufferRef bufferRef = this.createBufferRef(buffer);
        this.buffers.add(bufferRef);
        ++this.pooledBuffers;
    }

    private static final class BufferRef
    extends SoftReference<IBuffer> {
        public BufferRef(IBuffer buffer, ReferenceQueue<IBuffer> queue) {
            super(buffer, queue);
        }
    }
}

