/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.internal.ImageUtils;
import org.eclipse.gef.internal.InternalGEFPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class InternalImages {
    public static final ImageDescriptor DESC_ZOOM_IN;
    public static final ImageDescriptor DESC_ZOOM_OUT;
    public static final ImageDescriptor DESC_MATCH_SIZE;
    public static final ImageDescriptor DESC_MATCH_WIDTH;
    public static final ImageDescriptor DESC_MATCH_HEIGHT;
    public static final ImageDescriptor DESC_MATCH_SIZE_DIS;
    public static final ImageDescriptor DESC_MATCH_WIDTH_DIS;
    public static final ImageDescriptor DESC_MATCH_HEIGHT_DIS;
    public static final ImageDescriptor DESC_HORZ_ALIGN_CENTER;
    public static final ImageDescriptor DESC_HORZ_ALIGN_LEFT;
    public static final ImageDescriptor DESC_HORZ_ALIGN_RIGHT;
    public static final ImageDescriptor DESC_VERT_ALIGN_MIDDLE;
    public static final ImageDescriptor DESC_VERT_ALIGN_TOP;
    public static final ImageDescriptor DESC_VERT_ALIGN_BOTTOM;
    public static final ImageDescriptor DESC_HORZ_ALIGN_CENTER_DIS;
    public static final ImageDescriptor DESC_HORZ_ALIGN_LEFT_DIS;
    public static final ImageDescriptor DESC_HORZ_ALIGN_RIGHT_DIS;
    public static final ImageDescriptor DESC_VERT_ALIGN_MIDDLE_DIS;
    public static final ImageDescriptor DESC_VERT_ALIGN_TOP_DIS;
    public static final ImageDescriptor DESC_VERT_ALIGN_BOTTOM_DIS;
    public static final ImageDescriptor DESC_SEPARATOR;
    public static final ImageDescriptor DESC_FOLDER_OPEN;
    public static final ImageDescriptor DESC_FOLDER_CLOSED;
    public static final ImageDescriptor DESC_BOLD;
    public static final ImageDescriptor DESC_ITALIC;
    public static final ImageDescriptor DESC_UNDERLINE;
    public static final ImageDescriptor DESC_BLOCK_LTR;
    public static final ImageDescriptor DESC_BLOCK_RTL;
    public static final ImageDescriptor DESC_BLOCK_ALIGN_LEFT;
    public static final ImageDescriptor DESC_BLOCK_ALIGN_CENTER;
    public static final ImageDescriptor DESC_BLOCK_ALIGN_RIGHT;
    public static final ImageDescriptor DESC_PINNED;
    public static final ImageDescriptor DESC_UNPINNED;
    public static final ImageDescriptor DESC_PALETTE;
    public static final String IMG_PINNED = "icons/pinned.svg";
    public static final String IMG_UNPINNED = "icons/unpinned.svg";
    public static final String IMG_PALETTE = "icons/palette_view.svg";
    private static final Map<String, Image> overloadedImages;

    static {
        overloadedImages = new HashMap<String, Image>();
        DESC_BOLD = InternalImages.createDescriptor("icons/style_bold.svg");
        DESC_ITALIC = InternalImages.createDescriptor("icons/style_italic.svg");
        DESC_UNDERLINE = InternalImages.createDescriptor("icons/style_underline.svg");
        DESC_BLOCK_LTR = InternalImages.createDescriptor("icons/style_paragraph_ltr.svg");
        DESC_BLOCK_RTL = InternalImages.createDescriptor("icons/style_paragraph_rtl.svg");
        DESC_BLOCK_ALIGN_LEFT = InternalImages.createDescriptor("icons/style_paragraph_left.svg");
        DESC_BLOCK_ALIGN_CENTER = InternalImages.createDescriptor("icons/style_paragraph_center.svg");
        DESC_BLOCK_ALIGN_RIGHT = InternalImages.createDescriptor("icons/style_paragraph_right.svg");
        DESC_ZOOM_IN = InternalImages.createDescriptor("icons/zoom_in.svg");
        DESC_ZOOM_OUT = InternalImages.createDescriptor("icons/zoom_out.svg");
        DESC_MATCH_SIZE = InternalImages.createDescriptor("icons/matchsize.png");
        DESC_MATCH_WIDTH = InternalImages.createDescriptor("icons/matchwidth.png");
        DESC_MATCH_HEIGHT = InternalImages.createDescriptor("icons/matchheight.png");
        DESC_MATCH_SIZE_DIS = InternalImages.createDescriptor("icons/matchsize_d.png");
        DESC_MATCH_WIDTH_DIS = InternalImages.createDescriptor("icons/matchwidth_d.png");
        DESC_MATCH_HEIGHT_DIS = InternalImages.createDescriptor("icons/matchheight_d.png");
        DESC_VERT_ALIGN_BOTTOM = InternalImages.createDescriptor("icons/alignbottom.png");
        DESC_HORZ_ALIGN_CENTER = InternalImages.createDescriptor("icons/aligncenter.png");
        DESC_HORZ_ALIGN_LEFT = InternalImages.createDescriptor("icons/alignleft.png");
        DESC_VERT_ALIGN_MIDDLE = InternalImages.createDescriptor("icons/alignmid.png");
        DESC_HORZ_ALIGN_RIGHT = InternalImages.createDescriptor("icons/alignright.png");
        DESC_VERT_ALIGN_TOP = InternalImages.createDescriptor("icons/aligntop.png");
        DESC_VERT_ALIGN_BOTTOM_DIS = InternalImages.createDescriptor("icons/alignbottom_d.png");
        DESC_HORZ_ALIGN_CENTER_DIS = InternalImages.createDescriptor("icons/aligncenter_d.png");
        DESC_HORZ_ALIGN_LEFT_DIS = InternalImages.createDescriptor("icons/alignleft_d.png");
        DESC_VERT_ALIGN_MIDDLE_DIS = InternalImages.createDescriptor("icons/alignmid_d.png");
        DESC_HORZ_ALIGN_RIGHT_DIS = InternalImages.createDescriptor("icons/alignright_d.png");
        DESC_VERT_ALIGN_TOP_DIS = InternalImages.createDescriptor("icons/aligntop_d.png");
        DESC_SEPARATOR = InternalImages.createDescriptor("icons/separator.svg");
        DESC_FOLDER_OPEN = InternalImages.createDescriptor("icons/folder_open.svg");
        DESC_FOLDER_CLOSED = InternalImages.createDescriptor("icons/folder_closed.svg");
        DESC_PINNED = InternalImages.createAndCache(IMG_PINNED);
        DESC_UNPINNED = InternalImages.createAndCache(IMG_UNPINNED);
        DESC_PALETTE = InternalImages.createAndCache(IMG_PALETTE);
    }

    public static ImageDescriptor createDescriptor(String filename) {
        return ImageDescriptor.createFromFile(InternalImages.class, (String)ImageUtils.getEffectiveFileName((String)filename));
    }

    private static ImageDescriptor createAndCache(String imageName) {
        ImageDescriptor result = InternalImages.createDescriptor(imageName);
        InternalGEFPlugin.getDefault().getImageRegistry().put(imageName, result);
        return result;
    }

    public static Image get(String imageName) {
        Image image = overloadedImages.get(imageName);
        if (image != null) {
            return image;
        }
        return InternalGEFPlugin.getDefault().getImageRegistry().get(imageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set(String imageName, Image image) {
        Map<String, Image> map = overloadedImages;
        synchronized (map) {
            overloadedImages.put(imageName, image);
        }
    }
}

