/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum XSDProcessContents implements Enumerator
{
    STRICT_LITERAL(0, "strict", "strict"),
    LAX_LITERAL(1, "lax", "lax"),
    SKIP_LITERAL(2, "skip", "skip");

    public static final int STRICT = 0;
    public static final int LAX = 1;
    public static final int SKIP = 2;
    private static final XSDProcessContents[] VALUES_ARRAY;
    public static final List<XSDProcessContents> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new XSDProcessContents[]{STRICT_LITERAL, LAX_LITERAL, SKIP_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static XSDProcessContents get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            XSDProcessContents result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static XSDProcessContents getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            XSDProcessContents result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static XSDProcessContents get(int value) {
        switch (value) {
            case 0: {
                return STRICT_LITERAL;
            }
            case 1: {
                return LAX_LITERAL;
            }
            case 2: {
                return SKIP_LITERAL;
            }
        }
        return null;
    }

    private XSDProcessContents(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

