/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.layout;

import java.util.Optional;
import java.util.WeakHashMap;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.AbstractLayoutEditPartProvider;
import org.eclipse.sirius.diagram.description.CustomLayoutConfiguration;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.ui.api.layout.CustomLayoutAlgorithm;
import org.eclipse.sirius.diagram.ui.business.api.query.EditPartQuery;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.api.layout.provider.AbstractLayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.api.layout.provider.CompoundLayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.api.layout.provider.DefaultLayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.api.layout.provider.ExtendableLayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.api.layout.provider.LayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.provider.ArrangeSelectionLayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.provider.PinnedElementsLayoutProvider;

public class GenericLayoutProvider
implements LayoutProvider {
    private WeakHashMap<IGraphicalEditPart, LayoutProviderData> editPartToLayoutProviderCache = new WeakHashMap();

    @Override
    public AbstractLayoutEditPartProvider getLayoutNodeProvider(IGraphicalEditPart partToLayout) {
        AbstractLayoutProvider result = null;
        LayoutProviderData layoutProviderData = Optional.ofNullable(this.editPartToLayoutProviderCache.get(partToLayout)).orElseGet(() -> this.getLayoutProviderData(partToLayout).orElse(null));
        if (layoutProviderData != null) {
            CompoundLayoutProvider clp = new CompoundLayoutProvider();
            clp.addProvider(layoutProviderData.defaultLayoutProvider);
            if (layoutProviderData.defaultLayoutProvider instanceof ExtendableLayoutProvider) {
                ExtendableLayoutProvider layoutProvider = (ExtendableLayoutProvider)((Object)layoutProviderData.defaultLayoutProvider);
                clp.addProvider(new PinnedElementsLayoutProvider(layoutProvider));
            }
            result = layoutProviderData.useStandardArrangeSelectionMechanism ? new ArrangeSelectionLayoutProvider(clp) : clp;
        }
        return result;
    }

    public Optional<CustomLayoutConfiguration> getLayoutConfiguration(IGraphicalEditPart partToLayout) {
        EditPartQuery editPartQuery = new EditPartQuery(partToLayout);
        DiagramDescription diagramDescription = editPartQuery.getDiagramDescription();
        CustomLayoutConfiguration layoutConfiguration = null;
        if (diagramDescription != null && diagramDescription.getLayout() instanceof CustomLayoutConfiguration) {
            layoutConfiguration = (CustomLayoutConfiguration)diagramDescription.getLayout();
        }
        return Optional.ofNullable(layoutConfiguration);
    }

    public boolean shouldLaunchSnapTo(IGraphicalEditPart partToLayout) {
        Optional<CustomLayoutAlgorithm> customLayoutAlgorithm;
        Optional<CustomLayoutConfiguration> customLayoutConfiguration = this.getLayoutConfiguration(partToLayout);
        if (customLayoutConfiguration.isPresent() && (customLayoutAlgorithm = this.getCustomLayoutAlgorithm(customLayoutConfiguration.get())).isPresent()) {
            return customLayoutAlgorithm.get().isLaunchSnapAfter();
        }
        return false;
    }

    public boolean shouldReverseLayoutsOrder(IGraphicalEditPart partToLayout) {
        Optional<CustomLayoutAlgorithm> customLayoutAlgorithm;
        Optional<CustomLayoutConfiguration> customLayoutConfiguration = this.getLayoutConfiguration(partToLayout);
        if (customLayoutConfiguration.isPresent() && (customLayoutAlgorithm = this.getCustomLayoutAlgorithm(customLayoutConfiguration.get())).isPresent()) {
            return customLayoutAlgorithm.get().shouldReverseLayoutsOrder();
        }
        return false;
    }

    private Optional<CustomLayoutAlgorithm> getCustomLayoutAlgorithm(CustomLayoutConfiguration configuration) {
        return Optional.ofNullable(DiagramUIPlugin.getPlugin().getLayoutAlgorithms().get(configuration.getId()));
    }

    @Override
    public boolean provides(IGraphicalEditPart container) {
        Optional<LayoutProviderData> layoutProviderData = this.getLayoutProviderData(container);
        if (layoutProviderData.isPresent()) {
            this.editPartToLayoutProviderCache.put(container, layoutProviderData.get());
            return true;
        }
        this.editPartToLayoutProviderCache.remove(container);
        return false;
    }

    private Optional<LayoutProviderData> getLayoutProviderData(IGraphicalEditPart container) {
        Optional<CustomLayoutAlgorithm> customLayoutAlgorithm;
        LayoutProviderData layoutProviderData = null;
        Optional<CustomLayoutConfiguration> customLayoutConfiguration = this.getLayoutConfiguration(container);
        if (customLayoutConfiguration.isPresent() && (customLayoutAlgorithm = this.getCustomLayoutAlgorithm(customLayoutConfiguration.get())).isPresent()) {
            DefaultLayoutProvider defaultLayoutProvider = this.getGenericLayoutProvider(customLayoutConfiguration.get(), customLayoutAlgorithm.get());
            layoutProviderData = new LayoutProviderData(defaultLayoutProvider, customLayoutAlgorithm.get().isLaunchSnapAfter(), customLayoutAlgorithm.get().useStandardArrangeSelectionMechanism());
        }
        return Optional.ofNullable(layoutProviderData);
    }

    @Override
    public boolean isDiagramLayoutProvider() {
        return true;
    }

    private Optional<DefaultLayoutProvider> getGenericLayoutProvider(IGraphicalEditPart partToLayout) {
        Optional<CustomLayoutConfiguration> customLayoutConfiguration = this.getLayoutConfiguration(partToLayout);
        if (customLayoutConfiguration.isPresent()) {
            return this.getGenericLayoutProvider(customLayoutConfiguration.get());
        }
        return Optional.empty();
    }

    private Optional<DefaultLayoutProvider> getGenericLayoutProvider(CustomLayoutConfiguration customLayoutConfiguration) {
        DefaultLayoutProvider defaultLayoutProvider = null;
        Optional<CustomLayoutAlgorithm> customLayoutAlgorithm = this.getCustomLayoutAlgorithm(customLayoutConfiguration);
        if (customLayoutAlgorithm.isPresent()) {
            defaultLayoutProvider = this.getGenericLayoutProvider(customLayoutConfiguration, customLayoutAlgorithm.get());
        }
        return Optional.ofNullable(defaultLayoutProvider);
    }

    private DefaultLayoutProvider getGenericLayoutProvider(CustomLayoutConfiguration customLayoutConfiguration, CustomLayoutAlgorithm customLayoutAlgorithm) {
        DefaultLayoutProvider layoutAlgorithmInstance = customLayoutAlgorithm.getLayoutAlgorithmInstance();
        layoutAlgorithmInstance.setLayoutConfiguration(customLayoutConfiguration);
        return layoutAlgorithmInstance;
    }

    private class LayoutProviderData {
        DefaultLayoutProvider defaultLayoutProvider;
        boolean shouldLaunchSnapTo;
        boolean useStandardArrangeSelectionMechanism;

        public LayoutProviderData(DefaultLayoutProvider defaultLayoutProvider, boolean shouldLaunchSnapTo, boolean useStandardArrangeSelectionMechanism) {
            this.defaultLayoutProvider = defaultLayoutProvider;
            this.shouldLaunchSnapTo = shouldLaunchSnapTo;
            this.useStandardArrangeSelectionMechanism = useStandardArrangeSelectionMechanism;
        }
    }
}

