/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.views;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.parsley.edit.ui.dnd.ViewerDragAndDropHelper;
import org.eclipse.emf.parsley.menus.ViewerContextMenuHelper;
import org.eclipse.emf.parsley.viewers.IStructuredViewerProvider;
import org.eclipse.emf.parsley.viewers.IViewerMouseListener;
import org.eclipse.emf.parsley.views.AbstractSaveableView;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractSaveableViewerView
extends AbstractSaveableView
implements IStructuredViewerProvider {
    @Inject
    private ViewerContextMenuHelper contextMenuHelper;
    @Inject
    private ViewerDragAndDropHelper dragAndDropHelper;
    @Inject
    private Provider<IViewerMouseListener> viewerMouseListenerProvider;

    protected void afterCreateViewer() {
        this.addContextMenuToViewer();
        this.addDragAndDropToViewer();
        this.addMouseListenerToViewer();
        this.setViewerAsSelectionProvider();
    }

    protected void setViewerAsSelectionProvider() {
        this.getSite().setSelectionProvider((ISelectionProvider)this.getViewer());
    }

    public void postCommandStackChanged(Command mostRecentCommand) {
    }

    @Override
    public void mostRecentCommandAffectsResource(Command mostRecentCommand) {
        super.mostRecentCommandAffectsResource(mostRecentCommand);
        if (mostRecentCommand != null && (mostRecentCommand instanceof CreateChildCommand || mostRecentCommand instanceof AddCommand)) {
            this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
        }
    }

    protected void setSelectionToViewer(Collection<?> collection) {
        Collection<?> theSelection = collection;
        if (theSelection != null && !theSelection.isEmpty()) {
            Runnable runnable = () -> {
                if (this.getViewer() != null) {
                    this.getViewer().setSelection((ISelection)new StructuredSelection(theSelection.toArray()), true);
                }
            };
            this.getSite().getShell().getDisplay().asyncExec(runnable);
        }
    }

    protected void addContextMenuToViewer() {
        this.contextMenuHelper.addViewerContextMenu(this.getViewer(), (IWorkbenchPart)this);
    }

    protected void addDragAndDropToViewer() {
        this.dragAndDropHelper.addDragAndDrop(this.getViewer(), this.getEditingDomain());
    }

    public void addMouseListenerToViewer() {
        this.getViewer().getControl().addMouseListener((MouseListener)this.viewerMouseListenerProvider.get());
    }
}

