/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.AbstractVectorSimilarityQuery;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.VectorScorer;
import org.apache.lucene.search.knn.KnnCollectorManager;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.VectorUtil;

public class FloatVectorSimilarityQuery
extends AbstractVectorSimilarityQuery {
    private final float[] target;

    public FloatVectorSimilarityQuery(String field, float[] target, float traversalSimilarity, float resultSimilarity, Query filter) {
        super(field, traversalSimilarity, resultSimilarity, filter);
        this.target = VectorUtil.checkFinite(Objects.requireNonNull(target, "target"));
    }

    public FloatVectorSimilarityQuery(String field, float[] target, float traversalSimilarity, float resultSimilarity) {
        this(field, target, traversalSimilarity, resultSimilarity, null);
    }

    public FloatVectorSimilarityQuery(String field, float[] target, float resultSimilarity, Query filter) {
        this(field, target, resultSimilarity, resultSimilarity, filter);
    }

    public FloatVectorSimilarityQuery(String field, float[] target, float resultSimilarity) {
        this(field, target, resultSimilarity, resultSimilarity, null);
    }

    @Override
    VectorScorer createVectorScorer(LeafReaderContext context) throws IOException {
        FloatVectorValues vectorValues = context.reader().getFloatVectorValues(this.field);
        if (vectorValues == null) {
            return null;
        }
        return vectorValues.scorer(this.target);
    }

    @Override
    protected TopDocs approximateSearch(LeafReaderContext context, Bits acceptDocs, int visitLimit, KnnCollectorManager knnCollectorManager) throws IOException {
        KnnCollector collector = knnCollectorManager.newCollector(visitLimit, null, context);
        context.reader().searchNearestVectors(this.field, this.target, collector, acceptDocs);
        return collector.topDocs();
    }

    @Override
    public String toString(String field) {
        return String.format(Locale.ROOT, "%s[field=%s target=[%f...] traversalSimilarity=%f resultSimilarity=%f filter=%s]", this.getClass().getSimpleName(), field, Float.valueOf(this.target[0]), Float.valueOf(this.traversalSimilarity), Float.valueOf(this.resultSimilarity), this.filter);
    }

    @Override
    public boolean equals(Object o) {
        return this.sameClassAs(o) && super.equals(o) && Arrays.equals(this.target, ((FloatVectorSimilarityQuery)o).target);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.target);
        return result;
    }
}

