/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel;

import java.util.Enumeration;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.AttributeElementType;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.BeanElement;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.TypeElement;
import org.eclipse.wst.ws.internal.datamodel.BasicElement;
import org.eclipse.wst.ws.internal.datamodel.Element;

public class AttributeElement
extends BasicElement
implements AttributeElementType {
    public static final String copyright = "(c) Copyright IBM Corporation 2000, 2002.";
    public static final String REL_TYPE = "type";
    public static final String REL_OWNING_BEAN = "owningbean";
    private String fSetterMethod;
    private String fGetterMethod;

    public AttributeElement(BeanElement beanElement, String name) {
        super(name, (Element)beanElement, REL_OWNING_BEAN, BeanElement.REL_ATTRIBUTES);
    }

    @Override
    public void setSetterMethod(String setterMethod) {
        this.fSetterMethod = setterMethod;
    }

    @Override
    public String getSetterMethod() {
        return this.fSetterMethod;
    }

    @Override
    public String getGetterMethod() {
        return this.fGetterMethod;
    }

    @Override
    public void setGetterMethod(String getterMethod) {
        this.fGetterMethod = getterMethod;
    }

    @Override
    public String getSetterSignature(String attribute) {
        int bracket = this.fSetterMethod.indexOf("(");
        String setter = this.fSetterMethod.substring(0, ++bracket);
        String fullSetter = String.valueOf(setter) + attribute + ");";
        return fullSetter;
    }

    @Override
    public BeanElement getOwningBeanElement() {
        Enumeration e = this.getElements(REL_OWNING_BEAN);
        return e.hasMoreElements() ? (BeanElement)((Object)e.nextElement()) : null;
    }

    @Override
    public TypeElement getTypeElement() {
        Enumeration e = this.getElements(REL_TYPE);
        return e.hasMoreElements() ? (TypeElement)((Object)e.nextElement()) : null;
    }
}

