/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.actions;

import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.cdt.internal.ui.actions.BlockCommentAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.ui.texteditor.ITextEditor;

public class RemoveBlockCommentAction
extends BlockCommentAction {
    public RemoveBlockCommentAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    @Override
    protected void runInternal(ITextSelection selection, IDocumentExtension3 docExtension, BlockCommentAction.Edit.EditFactory factory) throws BadPartitioningException, BadLocationException {
        ITypedRegion partition;
        if (!(docExtension instanceof IDocument)) {
            return;
        }
        LinkedList<BlockCommentAction.Edit> edits = new LinkedList<BlockCommentAction.Edit>();
        int partitionStart = -1;
        int partitionEnd = selection.getOffset();
        while ((partition = docExtension.getPartition("___c_partitioning", partitionEnd, false)).getOffset() > partitionStart) {
            partitionStart = partition.getOffset();
            partitionEnd = partitionStart + partition.getLength();
            if (partition.getType() == "__c_multiline_comment" || partition.getType() == "__c_multiline_doc_comment") {
                this.uncommentPartition((IDocument)docExtension, factory, edits, partitionStart, partitionEnd);
            }
            if (partitionEnd < selection.getOffset() + selection.getLength()) continue;
        }
        this.executeEdits(edits);
    }

    private void uncommentPartition(IDocument doc, BlockCommentAction.Edit.EditFactory factory, List<BlockCommentAction.Edit> edits, int partitionStart, int partitionEnd) throws BadLocationException {
        String eol;
        IRegion lineRegion;
        String lineContent;
        String eol2;
        IRegion lineRegion2;
        String lineContent2;
        int startCommentTokenLength = this.getCommentStart().length();
        int endCommentTokenLength = this.getCommentEnd().length();
        if (partitionStart >= 0 && (lineContent2 = doc.get((lineRegion2 = doc.getLineInformationOfOffset(partitionStart)).getOffset(), lineRegion2.getLength())).equals(this.getCommentStart()) && (eol2 = doc.getLineDelimiter(doc.getLineOfOffset(partitionStart))) != null) {
            startCommentTokenLength += eol2.length();
        }
        int commentContentEnd = partitionEnd - endCommentTokenLength;
        if (partitionEnd < doc.getLength() && (lineContent = doc.get((lineRegion = doc.getLineInformationOfOffset(partitionEnd)).getOffset(), lineRegion.getLength())).equals(this.getCommentEnd()) && (eol = doc.getLineDelimiter(doc.getLineOfOffset(partitionEnd))) != null) {
            endCommentTokenLength += eol.length();
        }
        edits.add(factory.createEdit(partitionStart, startCommentTokenLength, ""));
        edits.add(factory.createEdit(commentContentEnd, endCommentTokenLength, ""));
    }

    @Override
    protected boolean isValidSelection(ITextSelection selection) {
        return selection != null && !selection.isEmpty() && selection.getLength() > 0;
    }
}

