/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.testsrunner.internal.ui.view;

import java.util.Iterator;
import org.eclipse.cdt.testsrunner.internal.model.TestingSessionsManager;
import org.eclipse.cdt.testsrunner.internal.ui.view.MessagesViewer;
import org.eclipse.cdt.testsrunner.internal.ui.view.ResultsView;
import org.eclipse.cdt.testsrunner.internal.ui.view.TestsHierarchyViewer;
import org.eclipse.cdt.testsrunner.internal.ui.view.UIViewMessages;
import org.eclipse.cdt.testsrunner.internal.ui.view.actions.MessageLevelFilterAction;
import org.eclipse.cdt.testsrunner.internal.ui.view.actions.MessagesOrderingAction;
import org.eclipse.cdt.testsrunner.model.ITestItem;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;

public class ResultsPanel {
    private SashForm sashForm;
    private MessagesViewer messagesViewer;
    private TestsHierarchyViewer testsHierarchyViewer;
    static final String TAG_WEIGHT0 = "weight0";
    static final String TAG_WEIGHT1 = "weight1";
    static final String TAG_MESSAGES_ORDERING_ACTION = "messagesOrderingAction";
    static final String TAG_ERROR_FILTER_ACTION = "errorFilterAction";
    static final String TAG_WARNING_FILTER_ACTION = "warningFilterAction";
    static final String TAG_INFO_FILTER_ACTION = "infoFilterAction";
    Action messagesOrderingAction;
    Action errorFilterAction;
    Action warningFilterAction;
    Action infoFilterAction;

    public ResultsPanel(Composite parent, TestingSessionsManager sessionsManager, IWorkbench workbench, IViewSite site, Clipboard clipboard) {
        this.sashForm = new SashForm(parent, 512);
        ViewForm top = new ViewForm((Composite)this.sashForm, 0);
        Composite empty = new Composite((Composite)top, 0);
        empty.setLayout(new Layout(){

            protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
                return new Point(1, 1);
            }

            protected void layout(Composite composite, boolean flushCache) {
            }
        });
        top.setTopLeft((Control)empty);
        this.testsHierarchyViewer = new TestsHierarchyViewer((Composite)top, site, clipboard);
        top.setContent(this.testsHierarchyViewer.getTreeViewer().getControl());
        ViewForm bottom = new ViewForm((Composite)this.sashForm, 0);
        this.messagesViewer = new MessagesViewer((Composite)bottom, sessionsManager, workbench, site, clipboard);
        Composite topLeftPanel = new Composite((Composite)bottom, 0);
        RowLayout topLeftPanelLayout = new RowLayout(256);
        topLeftPanelLayout.spacing = 0;
        topLeftPanelLayout.center = true;
        topLeftPanelLayout.marginTop = 0;
        topLeftPanelLayout.marginRight = 0;
        topLeftPanelLayout.marginLeft = 0;
        topLeftPanelLayout.marginBottom = 0;
        topLeftPanel.setLayout((Layout)topLeftPanelLayout);
        ToolBar leftMessagesToolBar = new ToolBar(topLeftPanel, 0x800040);
        ToolBarManager leftMessagesToolBarManager = new ToolBarManager(leftMessagesToolBar);
        this.messagesOrderingAction = new MessagesOrderingAction(this.messagesViewer);
        leftMessagesToolBarManager.add((IAction)this.messagesOrderingAction);
        leftMessagesToolBarManager.update(true);
        CLabel label = new CLabel(topLeftPanel, 0);
        label.setText(UIViewMessages.MessagesPanel_label);
        bottom.setTopLeft((Control)topLeftPanel);
        ToolBar rightMessagesToolBar = new ToolBar((Composite)bottom, 0x800040);
        ToolBarManager rightMessagesToolBarManager = new ToolBarManager(rightMessagesToolBar);
        this.errorFilterAction = new MessageLevelFilterAction(this.messagesViewer, MessagesViewer.LevelFilter.Error, true);
        this.warningFilterAction = new MessageLevelFilterAction(this.messagesViewer, MessagesViewer.LevelFilter.Warning, true);
        this.infoFilterAction = new MessageLevelFilterAction(this.messagesViewer, MessagesViewer.LevelFilter.Info, false);
        rightMessagesToolBarManager.add((IAction)this.errorFilterAction);
        rightMessagesToolBarManager.add((IAction)this.warningFilterAction);
        rightMessagesToolBarManager.add((IAction)this.infoFilterAction);
        rightMessagesToolBarManager.update(true);
        bottom.setTopCenter((Control)rightMessagesToolBar);
        bottom.setContent(this.messagesViewer.getTableViewer().getControl());
        this.sashForm.setWeights(new int[]{50, 50});
        this.testsHierarchyViewer.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ResultsPanel.this.handleTestItemSelected();
            }
        });
        this.setShowFailedOnly(false);
        this.sashForm.setLayoutData((Object)new GridData(1808));
    }

    public TestsHierarchyViewer getTestsHierarchyViewer() {
        return this.testsHierarchyViewer;
    }

    public MessagesViewer getMessagesViewer() {
        return this.messagesViewer;
    }

    private void handleTestItemSelected() {
        IStructuredSelection selection = (IStructuredSelection)this.testsHierarchyViewer.getTreeViewer().getSelection();
        ITestItem[] testItems = new ITestItem[selection.size()];
        int index = 0;
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            testItems[index] = (ITestItem)it.next();
            ++index;
        }
        this.messagesViewer.showItemsMessages(testItems);
    }

    public void setPanelOrientation(ResultsView.Orientation orientation) {
        this.sashForm.setOrientation(orientation == ResultsView.Orientation.Horizontal ? 256 : 512);
    }

    public boolean getShowFailedOnly() {
        return this.messagesViewer.getShowFailedOnly();
    }

    public void setShowFailedOnly(boolean showFailedOnly) {
        this.testsHierarchyViewer.setShowFailedOnly(showFailedOnly);
        this.messagesViewer.setShowFailedOnly(showFailedOnly);
    }

    private void restoreActionChecked(IMemento memento, String key, Action action) {
        Boolean checked = memento.getBoolean(key);
        if (checked != null) {
            action.setChecked(checked.booleanValue());
            action.run();
        }
    }

    public void restoreState(IMemento memento) {
        Integer weight0 = memento.getInteger(TAG_WEIGHT0);
        Integer weight1 = memento.getInteger(TAG_WEIGHT1);
        if (weight0 != null && weight1 != null) {
            this.sashForm.setWeights(new int[]{weight0, weight1});
        }
        this.restoreActionChecked(memento, TAG_MESSAGES_ORDERING_ACTION, this.messagesOrderingAction);
        this.restoreActionChecked(memento, TAG_ERROR_FILTER_ACTION, this.errorFilterAction);
        this.restoreActionChecked(memento, TAG_WARNING_FILTER_ACTION, this.warningFilterAction);
        this.restoreActionChecked(memento, TAG_INFO_FILTER_ACTION, this.infoFilterAction);
    }

    public void saveState(IMemento memento) {
        int[] weights = this.sashForm.getWeights();
        memento.putInteger(TAG_WEIGHT0, weights[0]);
        memento.putInteger(TAG_WEIGHT1, weights[1]);
        memento.putBoolean(TAG_MESSAGES_ORDERING_ACTION, this.messagesOrderingAction.isChecked());
        memento.putBoolean(TAG_ERROR_FILTER_ACTION, this.errorFilterAction.isChecked());
        memento.putBoolean(TAG_WARNING_FILTER_ACTION, this.warningFilterAction.isChecked());
        memento.putBoolean(TAG_INFO_FILTER_ACTION, this.infoFilterAction.isChecked());
    }
}

