/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.text;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;

public class TextRegionListImpl
implements ITextRegionList {
    private static final int growthConstant = 2;
    private ITextRegion[] fRegions;
    private int fRegionsCount = 0;

    public TextRegionListImpl() {
    }

    public TextRegionListImpl(ITextRegionList regionList) {
        this();
        this.fRegions = (ITextRegion[])regionList.toArray().clone();
        this.fRegionsCount = this.fRegions.length;
    }

    @Override
    public boolean add(ITextRegion region) {
        if (region == null) {
            return false;
        }
        this.ensureCapacity(this.fRegionsCount + 1);
        this.fRegions[this.fRegionsCount++] = region;
        return true;
    }

    @Override
    public boolean addAll(int insertPos, ITextRegionList newRegionList) {
        if (insertPos < 0 || insertPos > this.fRegionsCount) {
            throw new ArrayIndexOutOfBoundsException(insertPos);
        }
        int newRegionListSize = newRegionList.size();
        this.ensureCapacity(this.fRegionsCount + newRegionListSize);
        int numMoved = this.fRegionsCount - insertPos;
        if (numMoved > 0) {
            System.arraycopy(this.fRegions, insertPos, this.fRegions, insertPos + newRegionListSize, numMoved);
        }
        if (newRegionList instanceof TextRegionListImpl && ((TextRegionListImpl)newRegionList).fRegions != null) {
            System.arraycopy(((TextRegionListImpl)newRegionList).fRegions, 0, this.fRegions, insertPos, newRegionListSize);
        } else {
            int i = 0;
            while (i < newRegionListSize) {
                this.fRegions[insertPos++] = newRegionList.get(i);
                ++i;
            }
        }
        this.fRegionsCount += newRegionListSize;
        return newRegionListSize != 0;
    }

    @Override
    public void clear() {
        this.fRegionsCount = 0;
    }

    private void ensureCapacity(int needed) {
        if (this.fRegions == null) {
            this.fRegions = new ITextRegion[needed];
            return;
        }
        int oldLength = this.fRegions.length;
        if (oldLength < needed) {
            ITextRegion[] oldAdapters = this.fRegions;
            ITextRegion[] newAdapters = new ITextRegion[needed + 2];
            System.arraycopy(oldAdapters, 0, newAdapters, 0, this.fRegionsCount);
            this.fRegions = newAdapters;
        }
    }

    @Override
    public ITextRegion get(int index) {
        if (index < 0 || index >= this.fRegionsCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.fRegions[index];
    }

    @Override
    public int indexOf(ITextRegion region) {
        int result = -1;
        if (region != null && this.fRegions != null) {
            int i = 0;
            while (i < this.fRegions.length) {
                if (region.equals(this.fRegions[i])) {
                    result = i;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.fRegionsCount == 0;
    }

    public Iterator iterator() {
        if (this.size() == 0) {
            return new NullIterator();
        }
        return new RegionIterator(this.toArray());
    }

    @Override
    public ITextRegion remove(int index) {
        ITextRegion oneToRemove = this.get(index);
        this.remove(oneToRemove);
        return oneToRemove;
    }

    @Override
    public void remove(ITextRegion a) {
        if (this.fRegions == null || a == null) {
            return;
        }
        int newIndex = 0;
        ITextRegion[] newRegions = new ITextRegion[this.fRegionsCount];
        int oldRegionCount = this.fRegionsCount;
        boolean found = false;
        int oldIndex = 0;
        while (oldIndex < oldRegionCount) {
            ITextRegion candidate = this.fRegions[oldIndex];
            if (a == candidate) {
                --this.fRegionsCount;
                found = true;
            } else {
                newRegions[newIndex++] = this.fRegions[oldIndex];
            }
            ++oldIndex;
        }
        if (found) {
            this.fRegions = newRegions;
        }
    }

    @Override
    public void removeAll(ITextRegionList regionList) {
        if (regionList != null) {
            int i = 0;
            while (i < regionList.size()) {
                this.remove(regionList.get(i));
                ++i;
            }
        }
    }

    @Override
    public int size() {
        return this.fRegionsCount;
    }

    @Override
    public ITextRegion[] toArray() {
        ITextRegion[] newArray = new ITextRegion[this.fRegionsCount];
        System.arraycopy(this.fRegions, 0, newArray, 0, this.fRegionsCount);
        return newArray;
    }

    public void trimToSize() {
        if (this.fRegions.length > this.fRegionsCount) {
            ITextRegion[] newRegions = new ITextRegion[this.fRegionsCount];
            System.arraycopy(this.fRegions, 0, newRegions, 0, this.fRegionsCount);
            this.fRegions = newRegions;
        }
    }

    private static class NullIterator
    implements Iterator {
        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("can not remove regions via iterator");
        }
    }

    private static class RegionIterator
    implements Iterator {
        private ITextRegion[] fIteratorRegions;
        private int index = -1;
        private int maxindex = -1;

        public RegionIterator(ITextRegion[] regions) {
            this.fIteratorRegions = regions;
            this.maxindex = this.fIteratorRegions.length - 1;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.maxindex;
        }

        public Object next() {
            if (this.index >= this.maxindex) {
                throw new NoSuchElementException();
            }
            return this.fIteratorRegions[++this.index];
        }

        @Override
        public void remove() {
            if (this.index < 0) {
                throw new IllegalStateException("can not remove regions without prior invocation of next()");
            }
            throw new UnsupportedOperationException("can not remove regions via iterator");
        }
    }
}

