/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.completion;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.CompletionContext;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.text.completion.AbstractScriptCompletionProposal;
import org.eclipse.dltk.ui.text.completion.CompletionProposalLabelProvider;
import org.eclipse.dltk.ui.text.completion.ICompletionProposalInfo;
import org.eclipse.dltk.ui.text.completion.ICompletionProposalLabelProviderExtension;
import org.eclipse.dltk.ui.text.completion.ScriptContentAssistInvocationContext;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public abstract class LazyScriptCompletionProposal
extends AbstractScriptCompletionProposal {
    protected static final String LPAREN = "(";
    protected static final String RPAREN = ")";
    protected static final String COMMA = ",";
    protected static final String SPACE = " ";
    private boolean fDisplayStringComputed;
    private boolean fReplacementStringComputed;
    private boolean fReplacementOffsetComputed;
    private boolean fReplacementLengthComputed;
    private boolean fCursorPositionComputed;
    private boolean fImageComputed;
    private boolean fContextInformationComputed;
    private boolean fProposalInfoComputed;
    private boolean fTriggerCharactersComputed;
    private boolean fRelevanceComputed;
    protected final CompletionProposal fProposal;
    protected final ScriptContentAssistInvocationContext fInvocationContext;
    private boolean fDisplayStyledStringComputed;

    public LazyScriptCompletionProposal(CompletionProposal proposal, ScriptContentAssistInvocationContext context) {
        Assert.isNotNull((Object)proposal);
        Assert.isNotNull((Object)context);
        this.fInvocationContext = context;
        this.fProposal = proposal;
    }

    @Override
    public final char[] getTriggerCharacters() {
        if (!this.fTriggerCharactersComputed) {
            this.setTriggerCharacters(this.computeTriggerCharacters());
        }
        return super.getTriggerCharacters();
    }

    protected char[] computeTriggerCharacters() {
        return CharOperation.NO_CHAR;
    }

    @Override
    public final void setTriggerCharacters(char[] triggerCharacters) {
        this.fTriggerCharactersComputed = true;
        super.setTriggerCharacters(triggerCharacters);
    }

    @Override
    public final void setProposalInfo(ICompletionProposalInfo proposalInfo) {
        this.fProposalInfoComputed = true;
        super.setProposalInfo(proposalInfo);
    }

    @Override
    public final ICompletionProposalInfo getProposalInfo() {
        if (!this.fProposalInfoComputed) {
            this.setProposalInfo(this.computeProposalInfo());
        }
        return super.getProposalInfo();
    }

    protected ICompletionProposalInfo computeProposalInfo() {
        return null;
    }

    @Override
    public final void setCursorPosition(int cursorPosition) {
        this.fCursorPositionComputed = true;
        super.setCursorPosition(cursorPosition);
    }

    @Override
    protected final int getCursorPosition() {
        if (!this.fCursorPositionComputed) {
            this.setCursorPosition(this.computeCursorPosition());
        }
        return super.getCursorPosition();
    }

    protected int computeCursorPosition() {
        return this.getReplacementString().length();
    }

    @Override
    protected boolean isInDoc() {
        CompletionContext coreContext = this.fInvocationContext.getCoreContext();
        return coreContext != null && coreContext.isInDoc();
    }

    @Override
    public final IContextInformation getContextInformation() {
        if (!this.fContextInformationComputed) {
            this.setContextInformation(this.computeContextInformation());
        }
        return super.getContextInformation();
    }

    protected IContextInformation computeContextInformation() {
        return null;
    }

    @Override
    public final void setContextInformation(IContextInformation contextInformation) {
        this.fContextInformationComputed = true;
        super.setContextInformation(contextInformation);
    }

    @Override
    public final String getDisplayString() {
        if (!this.fDisplayStringComputed) {
            this.setDisplayString(this.computeDisplayString());
        }
        return super.getDisplayString();
    }

    @Override
    protected final void setDisplayString(String string) {
        this.fDisplayStringComputed = true;
        super.setDisplayString(string);
    }

    protected String computeDisplayString() {
        return this.fInvocationContext.getLabelProvider().createLabel(this.fProposal);
    }

    @Override
    public StyledString getStyledDisplayString() {
        if (!this.fDisplayStyledStringComputed) {
            this.setStyledDisplayString(this.computeStyledDisplayString());
        }
        return super.getStyledDisplayString();
    }

    @Override
    public final void setStyledDisplayString(StyledString string) {
        this.fDisplayStyledStringComputed = true;
        super.setStyledDisplayString(string);
    }

    protected StyledString computeStyledDisplayString() {
        CompletionProposalLabelProvider labelProvider = this.fInvocationContext.getLabelProvider();
        if (labelProvider instanceof ICompletionProposalLabelProviderExtension) {
            return ((ICompletionProposalLabelProviderExtension)((Object)labelProvider)).createStyledLabel(this.fProposal);
        }
        return new StyledString(labelProvider.createLabel(this.fProposal));
    }

    @Override
    public final String getAdditionalProposalInfo() {
        return super.getAdditionalProposalInfo();
    }

    @Override
    public final int getContextInformationPosition() {
        if (this.getContextInformation() == null) {
            return this.getReplacementOffset() - 1;
        }
        return this.getReplacementOffset() + this.getCursorPosition();
    }

    @Override
    public final int getReplacementOffset() {
        if (!this.fReplacementOffsetComputed) {
            this.setReplacementOffset(this.fProposal.getReplaceStart());
        }
        return super.getReplacementOffset();
    }

    @Override
    public final void setReplacementOffset(int replacementOffset) {
        this.fReplacementOffsetComputed = true;
        super.setReplacementOffset(replacementOffset);
    }

    @Override
    public int getPrefixCompletionStart(IDocument document, int completionOffset) {
        return this.getReplacementOffset();
    }

    @Override
    public final int getReplacementLength() {
        if (!this.fReplacementLengthComputed) {
            this.setReplacementLength(this.fProposal.getReplaceEnd() - this.fProposal.getReplaceStart());
        }
        return super.getReplacementLength();
    }

    @Override
    public final void setReplacementLength(int replacementLength) {
        this.fReplacementLengthComputed = true;
        super.setReplacementLength(replacementLength);
    }

    @Override
    public final String getReplacementString() {
        if (!this.fReplacementStringComputed) {
            this.setReplacementString(this.computeReplacementString());
        }
        return super.getReplacementString();
    }

    protected String computeReplacementString() {
        return this.fProposal.getCompletion();
    }

    @Override
    public final void setReplacementString(String replacementString) {
        this.fReplacementStringComputed = true;
        super.setReplacementString(replacementString);
    }

    @Override
    public final Image getImage() {
        if (!this.fImageComputed) {
            this.setImage(this.computeImage());
        }
        return super.getImage();
    }

    protected Image computeImage() {
        return DLTKUIPlugin.getImageDescriptorRegistry().get(this.fInvocationContext.getLabelProvider().createImageDescriptor(this.fProposal));
    }

    @Override
    public final void setImage(Image image) {
        this.fImageComputed = true;
        super.setImage(image);
    }

    @Override
    protected boolean isValidPrefix(String prefix) {
        if (super.isValidPrefix(prefix)) {
            return true;
        }
        if (this.fProposal.getKind() == 10) {
            StringBuilder buf = new StringBuilder();
            buf.append('.');
            buf.append(this.getDisplayString());
            return this.isPrefix(prefix, buf.toString());
        }
        return false;
    }

    @Override
    public final int getRelevance() {
        if (!this.fRelevanceComputed) {
            this.setRelevance(this.computeRelevance());
        }
        return super.getRelevance();
    }

    @Override
    public final void setRelevance(int relevance) {
        this.fRelevanceComputed = true;
        super.setRelevance(relevance);
    }

    protected int computeRelevance() {
        int baseRelevance = this.fProposal.getRelevance() * 16;
        switch (this.fProposal.getKind()) {
            case 3: {
                return baseRelevance + 0;
            }
            case 2: {
                return baseRelevance + 1;
            }
            case 11: {
                return baseRelevance + 1;
            }
            case 7: {
                return baseRelevance + 2;
            }
            case 5: 
            case 6: 
            case 10: {
                return baseRelevance + 3;
            }
            case 9: {
                return baseRelevance + 3;
            }
            case 1: {
                return baseRelevance + 4;
            }
            case 4: 
            case 8: {
                return baseRelevance + 5;
            }
        }
        return baseRelevance;
    }

    @Override
    public final void setSortString(String string) {
        super.setSortString(string);
    }
}

